/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (12 + ivec4(-64, 72, 88, -76)) => ivec4(-52, 84, 100, -64)
 * (12 + ivec4(64, 72, 88, 76)) => ivec4(76, 84, 100, 88)
 * (12 + ivec4(-24, 40, -23, 64)) => ivec4(-12, 52, -11, 76)
 * (12 + ivec4(24, 40, 23, 64)) => ivec4(36, 52, 35, 76)
 * (-6 + ivec4(-64, 72, 88, -76)) => ivec4(-70, 66, 82, -82)
 * (-6 + ivec4(64, 72, 88, 76)) => ivec4(58, 66, 82, 70)
 * (-6 + ivec4(-24, 40, -23, 64)) => ivec4(-30, 34, -29, 58)
 * (-6 + ivec4(24, 40, 23, 64)) => ivec4(18, 34, 17, 58)
 * (76 + ivec4(-64, 72, 88, -76)) => ivec4(12, 148, 164, 0)
 * (76 + ivec4(64, 72, 88, 76)) => ivec4(140, 148, 164, 152)
 * (76 + ivec4(-24, 40, -23, 64)) => ivec4(52, 116, 53, 140)
 * (76 + ivec4(24, 40, 23, 64)) => ivec4(100, 116, 99, 140)
 * (-32 + ivec4(-64, 72, 88, -76)) => ivec4(-96, 40, 56, -108)
 * (-32 + ivec4(64, 72, 88, 76)) => ivec4(32, 40, 56, 44)
 * (-32 + ivec4(-24, 40, -23, 64)) => ivec4(-56, 8, -55, 32)
 * (-32 + ivec4(24, 40, 23, 64)) => ivec4(-8, 8, -9, 32)
 * (0 + ivec4(-64, 72, 88, -76)) => ivec4(-64, 72, 88, -76)
 * (0 + ivec4(64, 72, 88, 76)) => ivec4(64, 72, 88, 76)
 * (0 + ivec4(-24, 40, -23, 64)) => ivec4(-24, 40, -23, 64)
 * (0 + ivec4(24, 40, 23, 64)) => ivec4(24, 40, 23, 64)
 */
#version 120

void main()
{
  float[all(equal((12 + ivec4(-64, 72, 88, -76)), ivec4(-52, 84, 100, -64))) ? 1 : -1] array0;
  float[all(equal((12 + ivec4(64, 72, 88, 76)), ivec4(76, 84, 100, 88))) ? 1 : -1] array1;
  float[all(equal((12 + ivec4(-24, 40, -23, 64)), ivec4(-12, 52, -11, 76))) ? 1 : -1] array2;
  float[all(equal((12 + ivec4(24, 40, 23, 64)), ivec4(36, 52, 35, 76))) ? 1 : -1] array3;
  float[all(equal((-6 + ivec4(-64, 72, 88, -76)), ivec4(-70, 66, 82, -82))) ? 1 : -1] array4;
  float[all(equal((-6 + ivec4(64, 72, 88, 76)), ivec4(58, 66, 82, 70))) ? 1 : -1] array5;
  float[all(equal((-6 + ivec4(-24, 40, -23, 64)), ivec4(-30, 34, -29, 58))) ? 1 : -1] array6;
  float[all(equal((-6 + ivec4(24, 40, 23, 64)), ivec4(18, 34, 17, 58))) ? 1 : -1] array7;
  float[all(equal((76 + ivec4(-64, 72, 88, -76)), ivec4(12, 148, 164, 0))) ? 1 : -1] array8;
  float[all(equal((76 + ivec4(64, 72, 88, 76)), ivec4(140, 148, 164, 152))) ? 1 : -1] array9;
  float[all(equal((76 + ivec4(-24, 40, -23, 64)), ivec4(52, 116, 53, 140))) ? 1 : -1] array10;
  float[all(equal((76 + ivec4(24, 40, 23, 64)), ivec4(100, 116, 99, 140))) ? 1 : -1] array11;
  float[all(equal((-32 + ivec4(-64, 72, 88, -76)), ivec4(-96, 40, 56, -108))) ? 1 : -1] array12;
  float[all(equal((-32 + ivec4(64, 72, 88, 76)), ivec4(32, 40, 56, 44))) ? 1 : -1] array13;
  float[all(equal((-32 + ivec4(-24, 40, -23, 64)), ivec4(-56, 8, -55, 32))) ? 1 : -1] array14;
  float[all(equal((-32 + ivec4(24, 40, 23, 64)), ivec4(-8, 8, -9, 32))) ? 1 : -1] array15;
  float[all(equal((0 + ivec4(-64, 72, 88, -76)), ivec4(-64, 72, 88, -76))) ? 1 : -1] array16;
  float[all(equal((0 + ivec4(64, 72, 88, 76)), ivec4(64, 72, 88, 76))) ? 1 : -1] array17;
  float[all(equal((0 + ivec4(-24, 40, -23, 64)), ivec4(-24, 40, -23, 64))) ? 1 : -1] array18;
  float[all(equal((0 + ivec4(24, 40, 23, 64)), ivec4(24, 40, 23, 64))) ? 1 : -1] array19;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length());
}
