/**
An AudioContext interface representing an audio-processing graph built from linked together AudioNodes. In contrast with a standard AudioContext, an OfflineAudioContext doesn't render the audio to the device hardware; instead, it generates it, as fast as it can, and outputs the result to an AudioBuffer.

@returns {OfflineAudioContext}
*/
OfflineAudioContext = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
OfflineAudioContext.prototype.length = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: OfflineAudioContext, ev: OfflineAudioCompletionEvent) => any) | null
**/
OfflineAudioContext.prototype.oncomplete = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Promise}
**/
OfflineAudioContext.prototype.resume = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Promise}
**/
OfflineAudioContext.prototype.startRendering = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} suspendTime
@returns {Promise}
**/
OfflineAudioContext.prototype.suspend = function(suspendTime) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Appends an event listener for events whose type attribute value is type. The callback argument sets the callback that will be invoked when the event is dispatched.

The options argument sets listener-specific options. For compatibility this can be a boolean, in which case the method behaves exactly as if the value was specified as options's capture.

When set to true, options's capture prevents callback from being invoked when the event's eventPhase attribute value is BUBBLING_PHASE. When false (or not present), callback will not be invoked when event's eventPhase attribute value is CAPTURING_PHASE. Either way, callback will be invoked if event's eventPhase attribute value is AT_TARGET.

When set to true, options's passive indicates that the callback will not cancel the event by invoking preventDefault(). This is used to enable performance optimizations described in § 2.8 Observing event listeners.

When set to true, options's once indicates that the callback will only be invoked once after which the event listener will be removed.

If an AbortSignal is passed for options's signal, then the event listener will be removed when signal is aborted.

The event listener is appended to target's event listener list and is not appended if it has the same type, callback, and capture.

@param {String} type
@param {(EventListener | EventListenerObject)} listener EventListenerOrEventListenerObject
@param {(Boolean | AddEventListenerOptions)} [options] boolean | AddEventListenerOptions
@returns {undefined}
**/
OfflineAudioContext.prototype.addEventListener = function(type, listener) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Removes the event listener in target's event listener list with the same type, callback, and options.

@param {String} type
@param {(EventListener | EventListenerObject)} listener EventListenerOrEventListenerObject
@param {(Boolean | EventListenerOptions)} [options] boolean | EventListenerOptions
@returns {undefined}
**/
OfflineAudioContext.prototype.removeEventListener = function(type, listener) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {AudioWorklet}
**/
OfflineAudioContext.prototype.audioWorklet = new AudioWorklet();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
OfflineAudioContext.prototype.currentTime = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {AudioDestinationNode}
**/
OfflineAudioContext.prototype.destination = new AudioDestinationNode();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {AudioListener}
**/
OfflineAudioContext.prototype.listener = new AudioListener();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: BaseAudioContext, ev: Event) => any) | null
**/
OfflineAudioContext.prototype.onstatechange = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
OfflineAudioContext.prototype.sampleRate = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {("closed" | "running" | "suspended")} AudioContextState
**/
OfflineAudioContext.prototype.state = new Object();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {AnalyserNode}
**/
OfflineAudioContext.prototype.createAnalyser = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {BiquadFilterNode}
**/
OfflineAudioContext.prototype.createBiquadFilter = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} numberOfChannels
@param {Number} length
@param {Number} sampleRate
@returns {AudioBuffer}
**/
OfflineAudioContext.prototype.createBuffer = function(numberOfChannels, length, sampleRate) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {AudioBufferSourceNode}
**/
OfflineAudioContext.prototype.createBufferSource = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} [numberOfInputs]
@returns {ChannelMergerNode}
**/
OfflineAudioContext.prototype.createChannelMerger = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} [numberOfOutputs]
@returns {ChannelSplitterNode}
**/
OfflineAudioContext.prototype.createChannelSplitter = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {ConstantSourceNode}
**/
OfflineAudioContext.prototype.createConstantSource = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {ConvolverNode}
**/
OfflineAudioContext.prototype.createConvolver = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} [maxDelayTime]
@returns {DelayNode}
**/
OfflineAudioContext.prototype.createDelay = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {DynamicsCompressorNode}
**/
OfflineAudioContext.prototype.createDynamicsCompressor = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {GainNode}
**/
OfflineAudioContext.prototype.createGain = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.iterable.d.ts
/**


@param {Iterable} feedforward Iterable
@param {Iterable} feedback Iterable
@returns {IIRFilterNode}
**/
OfflineAudioContext.prototype.createIIRFilter = function(feedforward, feedback) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {OscillatorNode}
**/
OfflineAudioContext.prototype.createOscillator = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {PannerNode}
**/
OfflineAudioContext.prototype.createPanner = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.iterable.d.ts
/**


@param {Iterable} real Iterable
@param {Iterable} imag Iterable
@param {PeriodicWaveConstraints} [constraints] PeriodicWaveConstraints
@returns {PeriodicWave}
**/
OfflineAudioContext.prototype.createPeriodicWave = function(real, imag) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} [bufferSize]
@param {Number} [numberOfInputChannels]
@param {Number} [numberOfOutputChannels]
@returns {ScriptProcessorNode}
**/
OfflineAudioContext.prototype.createScriptProcessor = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {StereoPannerNode}
**/
OfflineAudioContext.prototype.createStereoPanner = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {WaveShaperNode}
**/
OfflineAudioContext.prototype.createWaveShaper = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {ArrayBuffer} audioData ArrayBuffer
@param {(DecodeSuccessCallback | null)} [successCallback] DecodeSuccessCallback | null
@param {(DecodeErrorCallback | null)} [errorCallback] DecodeErrorCallback | null
@returns {Promise}
**/
OfflineAudioContext.prototype.decodeAudioData = function(audioData) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Appends an event listener for events whose type attribute value is type. The callback argument sets the callback that will be invoked when the event is dispatched.

The options argument sets listener-specific options. For compatibility this can be a boolean, in which case the method behaves exactly as if the value was specified as options's capture.

When set to true, options's capture prevents callback from being invoked when the event's eventPhase attribute value is BUBBLING_PHASE. When false (or not present), callback will not be invoked when event's eventPhase attribute value is CAPTURING_PHASE. Either way, callback will be invoked if event's eventPhase attribute value is AT_TARGET.

When set to true, options's passive indicates that the callback will not cancel the event by invoking preventDefault(). This is used to enable performance optimizations described in § 2.8 Observing event listeners.

When set to true, options's once indicates that the callback will only be invoked once after which the event listener will be removed.

If an AbortSignal is passed for options's signal, then the event listener will be removed when signal is aborted.

The event listener is appended to target's event listener list and is not appended if it has the same type, callback, and capture.

@param {String} type
@param {(EventListener | EventListenerObject)} listener EventListenerOrEventListenerObject
@param {(Boolean | AddEventListenerOptions)} [options] boolean | AddEventListenerOptions
@returns {undefined}
**/
OfflineAudioContext.prototype.addEventListener = function(type, listener) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Removes the event listener in target's event listener list with the same type, callback, and options.

@param {String} type
@param {(EventListener | EventListenerObject)} listener EventListenerOrEventListenerObject
@param {(Boolean | EventListenerOptions)} [options] boolean | EventListenerOptions
@returns {undefined}
**/
OfflineAudioContext.prototype.removeEventListener = function(type, listener) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Appends an event listener for events whose type attribute value is type. The callback argument sets the callback that will be invoked when the event is dispatched.

The options argument sets listener-specific options. For compatibility this can be a boolean, in which case the method behaves exactly as if the value was specified as options's capture.

When set to true, options's capture prevents callback from being invoked when the event's eventPhase attribute value is BUBBLING_PHASE. When false (or not present), callback will not be invoked when event's eventPhase attribute value is CAPTURING_PHASE. Either way, callback will be invoked if event's eventPhase attribute value is AT_TARGET.

When set to true, options's passive indicates that the callback will not cancel the event by invoking preventDefault(). This is used to enable performance optimizations described in § 2.8 Observing event listeners.

When set to true, options's once indicates that the callback will only be invoked once after which the event listener will be removed.

If an AbortSignal is passed for options's signal, then the event listener will be removed when signal is aborted.

The event listener is appended to target's event listener list and is not appended if it has the same type, callback, and capture.

@param {String} type
@param {(EventListener | EventListenerObject | null)} callback EventListenerOrEventListenerObject | null
@param {(AddEventListenerOptions | Boolean)} [options] AddEventListenerOptions | boolean
@returns {undefined}
**/
OfflineAudioContext.prototype.addEventListener = function(type, callback) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Dispatches a synthetic event event to target and returns true if either event's cancelable attribute value is false or its preventDefault() method was not invoked, and false otherwise.

@param {Event} event Event
@returns {Boolean}
**/
OfflineAudioContext.prototype.dispatchEvent = function(event) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Removes the event listener in target's event listener list with the same type, callback, and options.

@param {String} type
@param {(EventListener | EventListenerObject | null)} callback EventListenerOrEventListenerObject | null
@param {(EventListenerOptions | Boolean)} [options] EventListenerOptions | boolean
@returns {undefined}
**/
OfflineAudioContext.prototype.removeEventListener = function(type, callback) {};

