/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.api;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.document.AtomicLockDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.KeystrokeHandler;
import org.netbeans.modules.csl.api.UiUtils;
import org.openide.ErrorManager;

class CamelCaseOperations {
    CamelCaseOperations() {
    }

    static int nextCamelCasePosition(JTextComponent textComponent) {
        int nextOffset;
        Document doc;
        int offset = textComponent.getCaretPosition();
        if (offset == (doc = textComponent.getDocument()).getLength()) {
            return -1;
        }
        KeystrokeHandler bc = UiUtils.getBracketCompletion(doc, offset);
        if (bc != null && (nextOffset = bc.getNextWordOffset(doc, offset, false)) != -1) {
            return nextOffset;
        }
        try {
            return Utilities.getNextWord((JTextComponent)textComponent, (int)offset);
        }
        catch (BadLocationException ble) {
            ErrorManager.getDefault().notify((Throwable)ble);
            return -1;
        }
    }

    static int previousCamelCasePosition(JTextComponent textComponent) {
        int nextOffset;
        int offset = textComponent.getCaretPosition();
        if (offset == 0) {
            return -1;
        }
        Document doc = textComponent.getDocument();
        KeystrokeHandler bc = UiUtils.getBracketCompletion(doc, offset);
        if (bc != null && (nextOffset = bc.getNextWordOffset(doc, offset, true)) != -1) {
            return nextOffset;
        }
        try {
            return Utilities.getPreviousWord((JTextComponent)textComponent, (int)offset);
        }
        catch (BadLocationException ble) {
            ErrorManager.getDefault().notify((Throwable)ble);
            return -1;
        }
    }

    static void replaceChar(JTextComponent textComponent, int offset, char c) {
        if (!textComponent.isEditable()) {
            return;
        }
        CamelCaseOperations.replaceText(textComponent, offset, 1, String.valueOf(c));
    }

    static void replaceText(JTextComponent textComponent, int offset, int length, String text) {
        if (!textComponent.isEditable()) {
            return;
        }
        Document document = textComponent.getDocument();
        AtomicLockDocument ld = (AtomicLockDocument)LineDocumentUtils.asRequired((Document)document, AtomicLockDocument.class);
        ld.runAtomic(() -> {
            try {
                if (length > 0) {
                    document.remove(offset, length);
                }
                document.insertString(offset, text, null);
            }
            catch (BadLocationException ble) {
                ErrorManager.getDefault().notify((Throwable)ble);
            }
        });
    }
}

