/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.nodes;

import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.editor.api.PhpModifiers;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.model.nodes.ASTNodeInfo;
import org.netbeans.modules.php.editor.parser.astnodes.CaseDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.Scalar;
import org.netbeans.modules.php.editor.parser.astnodes.UnaryOperation;

public class CaseDeclarationInfo
extends ASTNodeInfo<Identifier> {
    private final String value;
    private final CaseDeclaration caseDeclaration;

    CaseDeclarationInfo(Identifier node, String value, CaseDeclaration caseDeclaration) {
        super(node);
        this.value = value;
        this.caseDeclaration = caseDeclaration;
    }

    public static CaseDeclarationInfo create(CaseDeclaration caseDeclaration) {
        Identifier name = caseDeclaration.getName();
        Expression initializer = caseDeclaration.getInitializer();
        String value = CaseDeclarationInfo.getCaseValue(initializer);
        return new CaseDeclarationInfo(name, value, caseDeclaration);
    }

    @Override
    public ASTNodeInfo.Kind getKind() {
        return ASTNodeInfo.Kind.ENUM_CASE;
    }

    @Override
    public String getName() {
        return ((Identifier)this.getOriginalNode()).getName();
    }

    @Override
    public QualifiedName getQualifiedName() {
        return QualifiedName.createUnqualifiedName(this.getName());
    }

    @Override
    public OffsetRange getRange() {
        Identifier name = (Identifier)this.getOriginalNode();
        return new OffsetRange(name.getStartOffset(), name.getEndOffset());
    }

    @CheckForNull
    public String getValue() {
        return this.value;
    }

    public PhpModifiers getAccessModifiers() {
        return PhpModifiers.fromBitMask(this.caseDeclaration.getModifier());
    }

    public CaseDeclaration getCaseDeclaration() {
        return this.caseDeclaration;
    }

    @CheckForNull
    protected static String getCaseValue(Expression expr) {
        UnaryOperation up;
        if (expr instanceof Scalar) {
            return ((Scalar)expr).getStringValue();
        }
        if (expr instanceof UnaryOperation && (up = (UnaryOperation)expr).getOperator() == UnaryOperation.Operator.MINUS && up.getExpression() instanceof Scalar) {
            return "-" + ((Scalar)up.getExpression()).getStringValue();
        }
        return null;
    }
}

