/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.impl;

import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Pattern;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.PredefinedSymbols;
import org.netbeans.modules.php.editor.api.AliasedName;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.QualifiedNameKind;
import org.netbeans.modules.php.editor.elements.TypeNameResolverImpl;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.model.ArrowFunctionScope;
import org.netbeans.modules.php.editor.model.CaseElement;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.EnumScope;
import org.netbeans.modules.php.editor.model.FieldElement;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.FunctionScope;
import org.netbeans.modules.php.editor.model.IndexScope;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TraitScope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.UseScope;
import org.netbeans.modules.php.editor.model.VariableName;
import org.netbeans.modules.php.editor.model.VariableScope;
import org.netbeans.modules.php.editor.model.impl.AssignmentImpl;
import org.netbeans.modules.php.editor.model.impl.FieldElementImpl;
import org.netbeans.modules.php.editor.model.impl.FunctionScopeImpl;
import org.netbeans.modules.php.editor.model.impl.IndexScopeImpl;
import org.netbeans.modules.php.editor.model.impl.NamespaceScopeImpl;
import org.netbeans.modules.php.editor.model.impl.Type;
import org.netbeans.modules.php.editor.parser.api.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.AnonymousObjectVariable;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayCreation;
import org.netbeans.modules.php.editor.parser.astnodes.Assignment;
import org.netbeans.modules.php.editor.parser.astnodes.Attribute;
import org.netbeans.modules.php.editor.parser.astnodes.AttributeDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Attributed;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreationVariable;
import org.netbeans.modules.php.editor.parser.astnodes.ClassName;
import org.netbeans.modules.php.editor.parser.astnodes.CloneExpression;
import org.netbeans.modules.php.editor.parser.astnodes.Comment;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.Include;
import org.netbeans.modules.php.editor.parser.astnodes.InfixExpression;
import org.netbeans.modules.php.editor.parser.astnodes.IntersectionType;
import org.netbeans.modules.php.editor.parser.astnodes.MethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceName;
import org.netbeans.modules.php.editor.parser.astnodes.NullableType;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocBlock;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTypeNode;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocVarTypeTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPVarComment;
import org.netbeans.modules.php.editor.parser.astnodes.ParenthesisExpression;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.Reference;
import org.netbeans.modules.php.editor.parser.astnodes.Scalar;
import org.netbeans.modules.php.editor.parser.astnodes.SingleFieldDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.StaticConstantAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticDispatch;
import org.netbeans.modules.php.editor.parser.astnodes.StaticFieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticMethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.UnionType;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.VariableBase;
import org.netbeans.modules.php.project.api.PhpSourcePath;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Pair;
import org.openide.util.Parameters;

public final class VariousUtils {
    public static final String PRE_OPERATION_TYPE_DELIMITER = "@";
    public static final String POST_OPERATION_TYPE_DELIMITER = ":";
    public static final String POST_OPERATION_TYPE_DELIMITER_SUBS = "_POTD_";
    public static final String CONSTRUCTOR_TYPE_PREFIX = "constuct-type:";
    public static final String FUNCTION_TYPE_PREFIX = "fn-type:";
    public static final String METHOD_TYPE_PREFIX = "mtd-type:";
    public static final String STATIC_METHOD_TYPE_PREFIX = "static.mtd-type:";
    public static final String FIELD_TYPE_PREFIX = "fld-type:";
    public static final String STATIC_FIELD_TYPE_PREFIX = "static.fld-type:";
    public static final String STATIC_CONSTANT_TYPE_PREFIX = "static.constant-type:";
    public static final String VAR_TYPE_PREFIX = "var-type:";
    public static final String ARRAY_TYPE_PREFIX = "array-type:";
    public static final String TYPE_TYPE_PREFIX = "type-type:";
    private static final Collection<String> SPECIAL_CLASS_NAMES = new LinkedList<String>();
    private static final Collection<String> STATIC_CLASS_NAMES = new LinkedList<String>();
    private static final String VAR_TYPE_COMMENT_PREFIX = "@var";
    private static final String SPACES_AND_TYPE_DELIMITERS = "[| ]*";
    private static final Pattern SEMI_TYPE_NAME_PATTERN = Pattern.compile("[@:]");
    private static final Pattern SEMICOLON_PATTERN = Pattern.compile("\\;");
    private static final Pattern DOT_PATTERN = Pattern.compile("\\.");
    private static final Pattern TYPE_SEPARATOR_PATTERN = Pattern.compile("\\|");
    private static final Pattern TYPE_SEPARATOR_INTERSECTION_PATTERN = Pattern.compile("\\&");
    private static Set<String> recursionDetection;
    private static final Collection<PHPTokenId> CTX_DELIMITERS;

    public static String encodeVariableName(String name) {
        String result = name;
        if (name != null) {
            result = name.replace(POST_OPERATION_TYPE_DELIMITER, POST_OPERATION_TYPE_DELIMITER_SUBS);
        }
        return result;
    }

    public static String extractTypeFroVariableBase(VariableBase varBase) {
        return VariousUtils.extractTypeFroVariableBase(varBase, Collections.emptyMap());
    }

    static String extractTypeFroVariableBase(VariableBase varBase, Map<String, AssignmentImpl> allAssignments) {
        ArrayDeque<VariableBase> stack = new ArrayDeque<VariableBase>();
        Object typeName = null;
        VariousUtils.createVariableBaseChain(varBase, stack);
        while (!stack.isEmpty() && stack.peek() != null) {
            varBase = stack.pop();
            String tmpType = VariousUtils.extractVariableTypeFromVariableBase(varBase, allAssignments);
            if (tmpType == null) {
                typeName = null;
                break;
            }
            if (typeName == null) {
                typeName = tmpType;
                continue;
            }
            typeName = (String)typeName + tmpType;
        }
        return typeName;
    }

    private VariousUtils() {
    }

    @CheckForNull
    public static String getReturnType(Program root, FunctionDeclaration functionDeclaration) {
        Expression returnType = functionDeclaration.getReturnType();
        if (returnType != null) {
            String typeFromPHPDoc;
            String typeName;
            if (returnType instanceof UnionType) {
                typeName = VariousUtils.getUnionType((UnionType)returnType);
            } else if (returnType instanceof IntersectionType) {
                typeName = VariousUtils.getIntersectionType((IntersectionType)returnType);
            } else {
                QualifiedName name = QualifiedName.create(returnType);
                assert (name != null) : returnType;
                typeName = name.toString();
            }
            if (("array".equals(typeName) || "self".equals(typeName)) && (typeFromPHPDoc = VariousUtils.getReturnTypeFromPHPDoc(root, functionDeclaration)) != null) {
                return typeFromPHPDoc;
            }
            if (returnType instanceof NullableType) {
                return "?" + typeName;
            }
            return typeName;
        }
        return VariousUtils.getReturnTypeFromPHPDoc(root, functionDeclaration);
    }

    public static String getUnionType(UnionType unionType) {
        StringBuilder sb = new StringBuilder();
        for (Expression type : unionType.getTypes()) {
            if (sb.length() > 0) {
                sb.append("|");
            }
            if (type instanceof IntersectionType) {
                IntersectionType intersectionType = (IntersectionType)type;
                sb.append("(").append(VariousUtils.getIntersectionType(intersectionType)).append(")");
                continue;
            }
            QualifiedName name = QualifiedName.create(type);
            assert (name != null) : type;
            sb.append(name.toString());
        }
        return sb.toString();
    }

    public static String getIntersectionType(IntersectionType intesectionType) {
        StringBuilder sb = new StringBuilder();
        for (Expression type : intesectionType.getTypes()) {
            QualifiedName name = QualifiedName.create(type);
            if (sb.length() > 0) {
                sb.append("&");
            }
            assert (name != null) : type;
            sb.append(name.toString());
        }
        return sb.toString();
    }

    @CheckForNull
    public static String getDeclaredType(Expression declaredType) {
        if (declaredType != null) {
            if (declaredType instanceof UnionType) {
                return VariousUtils.getUnionType((UnionType)declaredType);
            }
            if (declaredType instanceof IntersectionType) {
                return VariousUtils.getIntersectionType((IntersectionType)declaredType);
            }
            boolean isNullableType = declaredType instanceof NullableType;
            QualifiedName fieldTypeName = QualifiedName.create(declaredType);
            if (fieldTypeName != null) {
                return (isNullableType ? "?" : "") + fieldTypeName.toString();
            }
        }
        return null;
    }

    public static List<Pair<QualifiedName, Boolean>> getParamTypesFromUnionTypes(UnionType unionType) {
        ArrayList<Pair<QualifiedName, Boolean>> types = new ArrayList<Pair<QualifiedName, Boolean>>();
        for (QualifiedName type : QualifiedName.create(unionType)) {
            types.add((Pair<QualifiedName, Boolean>)Pair.of((Object)type, (Object)false));
        }
        return types;
    }

    public static List<Pair<QualifiedName, Boolean>> getParamTypesFromIntersectionTypes(IntersectionType intersectionType) {
        ArrayList<Pair<QualifiedName, Boolean>> types = new ArrayList<Pair<QualifiedName, Boolean>>();
        for (Expression type : intersectionType.getTypes()) {
            QualifiedName name = QualifiedName.create(type);
            if (name == null) continue;
            types.add((Pair<QualifiedName, Boolean>)Pair.of((Object)name, (Object)false));
        }
        return types;
    }

    public static String getReturnTypeFromPHPDoc(Program root, FunctionDeclaration functionDeclaration) {
        return VariousUtils.getTypeFromPHPDoc(root, functionDeclaration, PHPDocTag.Type.RETURN);
    }

    public static String getFieldTypeFromPHPDoc(Program root, SingleFieldDeclaration field) {
        return VariousUtils.getTypeFromPHPDoc(root, field, PHPDocTag.Type.VAR);
    }

    public static String getDeprecatedDescriptionFromPHPDoc(Program root, ASTNode node) {
        return VariousUtils.getDescriptionFromPHPDoc(root, node, PHPDocTag.Type.DEPRECATED);
    }

    public static boolean isDeprecatedFromPHPDoc(Program root, ASTNode node) {
        return VariousUtils.getDeprecatedDescriptionFromPHPDoc(root, node) != null;
    }

    public static boolean isDeprecatedFromAttribute(FileScope fileScope, Program root, ASTNode node) {
        if (node instanceof Attributed) {
            List<Attribute> attributes = ((Attributed)((Object)node)).getAttributes();
            for (Attribute attribute : attributes) {
                for (AttributeDeclaration attributeDeclaration : attribute.getAttributeDeclarations()) {
                    String attributeName = CodeUtils.extractQualifiedName(attributeDeclaration.getAttributeName());
                    if (!VariousUtils.isPredefinedAttributeName(PredefinedSymbols.Attributes.DEPRECATED, attributeName, fileScope, attributeDeclaration.getStartOffset())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isDeprecated(FileScope fileScope, Program root, ASTNode node) {
        if (VariousUtils.isDeprecatedFromAttribute(fileScope, root, node)) {
            return true;
        }
        return VariousUtils.isDeprecatedFromPHPDoc(root, node);
    }

    public static boolean isPredefinedAttributeName(PredefinedSymbols.Attributes attribute, String attributeName, FileScope fileScope, int offset) {
        if (attribute.getFqName().equals(attributeName)) {
            return true;
        }
        if (attribute.getName().equals(attributeName)) {
            ArrayList<? extends NamespaceScope> declaredNamespaces = new ArrayList<NamespaceScope>(fileScope.getDeclaredNamespaces());
            Collections.sort(declaredNamespaces, (n1, n2) -> -Integer.compare(n1.getOffset(), n2.getOffset()));
            NamespaceScope namespaceScope = null;
            for (NamespaceScope namespaceScope2 : declaredNamespaces) {
                int namespaceOffset = namespaceScope2.getOffset();
                if (namespaceOffset >= offset) continue;
                namespaceScope = namespaceScope2;
                break;
            }
            if (VariousUtils.isPredefinedAttributeName(attribute, attributeName, namespaceScope, offset)) {
                return true;
            }
        }
        return false;
    }

    private static boolean isPredefinedAttributeName(PredefinedSymbols.Attributes attribute, String attributeName, @NullAllowed NamespaceScope namespaceScope, int offset) {
        if (namespaceScope != null) {
            QualifiedName fullyQualifiedName = VariousUtils.getFullyQualifiedName(QualifiedName.create(attributeName), offset, namespaceScope);
            if (attribute.getFqName().equals(fullyQualifiedName.toString())) {
                return true;
            }
        }
        return false;
    }

    public static Map<String, Pair<String, List<Pair<QualifiedName, Boolean>>>> getParamTypesFromPHPDoc(Program root, ASTNode node) {
        HashMap<String, Pair<String, List<Pair<QualifiedName, Boolean>>>> retval = new HashMap<String, Pair<String, List<Pair<QualifiedName, Boolean>>>>();
        Comment comment = Utils.getCommentForNode(root, node);
        if (comment instanceof PHPDocBlock) {
            PHPDocBlock phpDoc = (PHPDocBlock)comment;
            for (PHPDocTag tag : phpDoc.getTags()) {
                if (!tag.getKind().equals((Object)PHPDocTag.Type.PARAM)) continue;
                ArrayList<Pair> allTypes = new ArrayList<Pair>();
                PHPDocVarTypeTag paramTag = (PHPDocVarTypeTag)tag;
                for (PHPDocTypeNode type : paramTag.getTypes()) {
                    String typeName = type.getValue();
                    boolean isNullableType = CodeUtils.isNullableType(typeName);
                    if (isNullableType) {
                        typeName = typeName.substring(1);
                    }
                    allTypes.add(Pair.of((Object)QualifiedName.create(typeName), (Object)isNullableType));
                }
                String value = paramTag.getValue().trim();
                String[] split = CodeUtils.WHITE_SPACES_PATTERN.split(value);
                String rawType = "";
                if (split.length > 0) {
                    rawType = split[0];
                }
                Pair types = Pair.of((Object)rawType, allTypes);
                retval.put(paramTag.getVariable().getValue(), (Pair<String, List<Pair<QualifiedName, Boolean>>>)types);
            }
        }
        return retval;
    }

    public static String getTypeFromPHPDoc(Program root, ASTNode node, PHPDocTag.Type tagType) {
        PHPVarComment varComment;
        PHPDocVarTypeTag tag;
        String[] parts;
        Comment comment = Utils.getCommentForNode(root, node);
        if (comment instanceof PHPDocBlock) {
            PHPDocBlock phpDoc = (PHPDocBlock)comment;
            for (PHPDocTag tag2 : phpDoc.getTags()) {
                if (!tag2.getKind().equals((Object)tagType)) continue;
                String[] parts2 = CodeUtils.WHITE_SPACES_PATTERN.split(tag2.getValue().trim(), 2);
                if (parts2.length > 0) {
                    String type = SEMICOLON_PATTERN.split(parts2[0], 2)[0];
                    return type;
                }
                break;
            }
        } else if (comment instanceof PHPVarComment && PHPDocTag.Type.VAR == tagType && (parts = CodeUtils.WHITE_SPACES_PATTERN.split((tag = (varComment = (PHPVarComment)comment).getVariable()).getValue().trim(), 3)).length > 1) {
            return parts[1];
        }
        return null;
    }

    public static String getDescriptionFromPHPDoc(Program root, ASTNode node, PHPDocTag.Type tagType) {
        Comment comment = Utils.getCommentForNode(root, node);
        if (comment instanceof PHPDocBlock) {
            PHPDocBlock phpDoc = (PHPDocBlock)comment;
            for (PHPDocTag tag : phpDoc.getTags()) {
                if (!tag.getKind().equals((Object)tagType)) continue;
                return tag.getValue().trim();
            }
        }
        return null;
    }

    @CheckForNull
    static String extractVariableTypeFromAssignment(Assignment assignment, Map<String, AssignmentImpl> allAssignments) {
        Expression expression = assignment.getRightHandSide();
        return VariousUtils.extractVariableTypeFromExpression(expression, allAssignments);
    }

    static String extractVariableTypeFromExpression(Expression expr, Map<String, AssignmentImpl> allAssignments) {
        Expression expression = expr;
        if (expression instanceof Assignment) {
            return VariousUtils.extractVariableTypeFromAssignment((Assignment)expression, allAssignments);
        }
        if (expression instanceof Reference) {
            Reference ref = (Reference)expression;
            expression = ref.getExpression();
        }
        if (expression instanceof ClassInstanceCreationVariable) {
            expression = ((ClassInstanceCreationVariable)expression).getName();
        }
        if (expression instanceof ClassInstanceCreation) {
            ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)expression;
            ClassName className = classInstanceCreation.getClassName();
            Expression name = className.getName();
            if (name instanceof NamespaceName) {
                QualifiedName qn = QualifiedName.create(name);
                assert (qn != null) : name;
                return qn.toString();
            }
            return CodeUtils.extractClassName(className);
        }
        if (expression instanceof ArrayCreation) {
            return "array";
        }
        if (expression instanceof VariableBase) {
            return VariousUtils.extractTypeFroVariableBase((VariableBase)expression, allAssignments);
        }
        if (expression instanceof Scalar) {
            Scalar scalar = (Scalar)expression;
            Scalar.Type scalarType = scalar.getScalarType();
            if (scalarType.equals((Object)Scalar.Type.STRING)) {
                String stringValue = scalar.getStringValue().toLowerCase();
                if (stringValue.equals("false") || stringValue.equals("true")) {
                    return "bool";
                }
                if (stringValue.equals("null")) {
                    return "null";
                }
            }
            return scalarType.toString().toLowerCase();
        }
        if (expression instanceof InfixExpression) {
            InfixExpression infixExpression = (InfixExpression)expression;
            InfixExpression.OperatorType operator = infixExpression.getOperator();
            if (operator.equals((Object)InfixExpression.OperatorType.CONCAT)) {
                return "string".toString().toLowerCase();
            }
        } else if (expression instanceof CloneExpression) {
            CloneExpression cloneExpression = (CloneExpression)expression;
            return VariousUtils.extractVariableTypeFromExpression(cloneExpression.getExpression(), allAssignments);
        }
        return null;
    }

    public static String replaceVarNames(String semiTypeName, Map<String, String> var2Type) {
        StringBuilder retval = new StringBuilder();
        String[] fragments = SEMI_TYPE_NAME_PATTERN.split(semiTypeName);
        for (int i = 0; i < fragments.length; ++i) {
            String frag = fragments[i];
            if (frag.trim().length() == 0) continue;
            if (VAR_TYPE_PREFIX.startsWith(frag)) {
                String varName;
                String type;
                if (i + 1 < fragments.length && (type = var2Type.get(varName = fragments[++i])) != null) {
                    retval.append(type);
                    continue;
                }
                return null;
            }
            Kind[] values = Kind.values();
            boolean isPrefix = false;
            for (Kind kind : values) {
                if (!kind.toString().startsWith(frag)) continue;
                isPrefix = true;
                break;
            }
            if (isPrefix) {
                retval.append(PRE_OPERATION_TYPE_DELIMITER);
                retval.append(frag);
                retval.append(POST_OPERATION_TYPE_DELIMITER);
                continue;
            }
            retval.append(frag);
        }
        return retval.toString();
    }

    public static Collection<? extends VariableName> getAllVariables(VariableScope varScope, String semiTypeName) {
        ArrayList<VariableName> retval = new ArrayList<VariableName>();
        String[] fragments = SEMI_TYPE_NAME_PATTERN.split(semiTypeName);
        for (int i = 0; i < fragments.length; ++i) {
            String varName;
            VariableName var;
            String frag = fragments[i];
            if (frag.trim().length() == 0 || !VAR_TYPE_PREFIX.startsWith(frag) || i + 1 >= fragments.length) continue;
            VariableName variableName = var = (varName = fragments[++i]) != null ? ModelUtils.getFirst(varScope.getDeclaredVariables(), varName) : null;
            if (var != null) {
                retval.add(var);
                continue;
            }
            return Collections.emptyList();
        }
        return retval;
    }

    public static Collection<? extends TypeScope> getType(VariableScope varScope, String semiTypeName, int offset, boolean justDispatcher) {
        if (varScope instanceof ArrowFunctionScope) {
            return VariousUtils.getArrowFunctionScopeType((ArrowFunctionScope)varScope, semiTypeName, offset, justDispatcher);
        }
        return VariousUtils.getType(varScope, semiTypeName, offset, justDispatcher, Collections.emptyList());
    }

    private static Collection<? extends TypeScope> getArrowFunctionScopeType(ArrowFunctionScope varScope, String semiTypeName, int offset, boolean justDispatcher) {
        assert (varScope instanceof ArrowFunctionScope);
        Collection<Object> types = Collections.emptyList();
        Scope inScope = varScope;
        while (types.isEmpty() && (inScope instanceof FunctionScopeImpl || inScope instanceof NamespaceScopeImpl)) {
            types = VariousUtils.getType(inScope, semiTypeName, offset, justDispatcher, Collections.emptyList());
            if ((inScope = inScope.getInScope()) != null) continue;
            break;
        }
        return types;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<? extends TypeScope> getType(VariableScope varScope, String semiTypeName, int offset, boolean justDispatcher, Collection<? extends TypeScope> callerTypes) {
        Collection<TypeScope> recentTypes = Collections.emptyList();
        Stack<VariableName> fldVarStack = new Stack<VariableName>();
        if (semiTypeName != null && semiTypeName.contains(PRE_OPERATION_TYPE_DELIMITER)) {
            String operation = null;
            String[] fragments = SEMI_TYPE_NAME_PATTERN.split(semiTypeName);
            int len = justDispatcher ? fragments.length - 1 : fragments.length;
            for (int i = 0; i < len; ++i) {
                Object clsName;
                Collection<TypeScope> types;
                String[] frgs;
                HashSet<TypeScope> newRecentTypes;
                String operationPrefix;
                List<TypeScope> oldRecentTypes = recentTypes;
                String frag = fragments[i].trim();
                if (frag.length() == 0) continue;
                String string = operationPrefix = frag.endsWith(POST_OPERATION_TYPE_DELIMITER) ? frag : String.format("%s%s", frag, POST_OPERATION_TYPE_DELIMITER);
                if (METHOD_TYPE_PREFIX.equalsIgnoreCase(operationPrefix)) {
                    operation = METHOD_TYPE_PREFIX;
                    continue;
                }
                if (FUNCTION_TYPE_PREFIX.equalsIgnoreCase(operationPrefix)) {
                    operation = FUNCTION_TYPE_PREFIX;
                    continue;
                }
                if (STATIC_METHOD_TYPE_PREFIX.equalsIgnoreCase(operationPrefix)) {
                    operation = STATIC_METHOD_TYPE_PREFIX;
                    continue;
                }
                if (STATIC_FIELD_TYPE_PREFIX.equalsIgnoreCase(operationPrefix)) {
                    operation = STATIC_FIELD_TYPE_PREFIX;
                    continue;
                }
                if (STATIC_CONSTANT_TYPE_PREFIX.equalsIgnoreCase(operationPrefix)) {
                    operation = STATIC_CONSTANT_TYPE_PREFIX;
                    continue;
                }
                if (VAR_TYPE_PREFIX.equalsIgnoreCase(operationPrefix)) {
                    operation = VAR_TYPE_PREFIX;
                    continue;
                }
                if (ARRAY_TYPE_PREFIX.equalsIgnoreCase(operationPrefix)) {
                    operation = ARRAY_TYPE_PREFIX;
                    continue;
                }
                if (FIELD_TYPE_PREFIX.equalsIgnoreCase(operationPrefix)) {
                    operation = FIELD_TYPE_PREFIX;
                    continue;
                }
                if (CONSTRUCTOR_TYPE_PREFIX.equalsIgnoreCase(operationPrefix)) {
                    operation = CONSTRUCTOR_TYPE_PREFIX;
                    continue;
                }
                if (TYPE_TYPE_PREFIX.equalsIgnoreCase(operationPrefix)) {
                    operation = TYPE_TYPE_PREFIX;
                    continue;
                }
                if (operation == null) {
                    assert (i == 0) : frag;
                    recentTypes = IndexScopeImpl.getTypes(QualifiedName.create(frag), varScope);
                    continue;
                }
                if (operation.startsWith(TYPE_TYPE_PREFIX)) {
                    recentTypes = IndexScopeImpl.getTypes(QualifiedName.create(frag), varScope);
                    varScope.getDeclaredVariables();
                    continue;
                }
                if (operation.startsWith(CONSTRUCTOR_TYPE_PREFIX)) {
                    newRecentTypes = new HashSet<TypeScope>();
                    QualifiedName fullyQualifiedName = VariousUtils.getFullyQualifiedName(VariousUtils.createQuery(frag, varScope), offset, varScope);
                    newRecentTypes.addAll(IndexScopeImpl.getClasses(fullyQualifiedName, varScope));
                    recentTypes = newRecentTypes;
                    operation = null;
                    continue;
                }
                if (operation.startsWith(METHOD_TYPE_PREFIX)) {
                    newRecentTypes = new HashSet();
                    for (TypeScope tScope : oldRecentTypes) {
                        Collection<? extends MethodScope> inheritedMethods = IndexScopeImpl.getMethods(tScope, frag, varScope, -1);
                        for (MethodScope methodScope : inheritedMethods) {
                            newRecentTypes.addAll(methodScope.getReturnTypes(true, Collections.singleton(tScope)));
                        }
                    }
                    recentTypes = VariousUtils.filterSuperTypes(newRecentTypes);
                    operation = null;
                    continue;
                }
                if (operation.startsWith(FUNCTION_TYPE_PREFIX)) {
                    newRecentTypes = new HashSet();
                    FunctionScope fnc = ModelUtils.getFirst(IndexScopeImpl.getFunctions(QualifiedName.create(frag), varScope));
                    if (fnc != null) {
                        newRecentTypes.addAll(fnc.getReturnTypes(true, recentTypes));
                    }
                    recentTypes = newRecentTypes;
                    operation = null;
                    continue;
                }
                if (operation.startsWith(STATIC_FIELD_TYPE_PREFIX)) {
                    String fieldName;
                    newRecentTypes = new HashSet();
                    frgs = DOT_PATTERN.split(frag);
                    if (frgs.length == 1) {
                        fieldName = frag;
                        types = oldRecentTypes;
                    } else {
                        assert (frgs.length == 2) : semiTypeName;
                        fieldName = frgs[1];
                        clsName = frgs[0];
                        assert (clsName != null) : frag;
                        QualifiedName qualifiedName = VariousUtils.getFullyQualifiedName(VariousUtils.createQuery(clsName, varScope), offset, varScope);
                        types = IndexScopeImpl.getTypes(qualifiedName, varScope);
                    }
                    for (TypeScope typeScope : types) {
                        Collection<? extends FieldElement> fields = IndexScopeImpl.getFields(typeScope, fieldName, varScope, -1);
                        for (FieldElement fieldElement : fields) {
                            newRecentTypes.addAll(fieldElement.getTypes(offset));
                        }
                    }
                    recentTypes = newRecentTypes;
                    operation = null;
                    continue;
                }
                if (operation.startsWith(STATIC_CONSTANT_TYPE_PREFIX)) {
                    String constantName;
                    newRecentTypes = new HashSet();
                    frgs = DOT_PATTERN.split(frag);
                    if (frgs.length == 1) {
                        constantName = frag;
                        types = oldRecentTypes;
                    } else {
                        assert (frgs.length == 2) : semiTypeName;
                        constantName = frgs[1];
                        clsName = frgs[0];
                        assert (clsName != null) : frag;
                        QualifiedName qualifiedName = VariousUtils.getFullyQualifiedName(VariousUtils.createQuery((String)clsName, varScope), offset, varScope);
                        types = IndexScopeImpl.getTypes(qualifiedName, varScope);
                    }
                    for (TypeScope typeScope : types) {
                        List<? extends CaseElement> enumCases = IndexScopeImpl.getEnumCases(QualifiedName.create(constantName), typeScope);
                        for (CaseElement caseElement : enumCases) {
                            Scope inScope = caseElement.getInScope();
                            if (!(inScope instanceof TypeScope)) continue;
                            newRecentTypes.add((TypeScope)inScope);
                        }
                    }
                    recentTypes = newRecentTypes;
                    operation = null;
                    continue;
                }
                if (operation.startsWith(STATIC_METHOD_TYPE_PREFIX)) {
                    String methodName;
                    newRecentTypes = new HashSet();
                    frgs = DOT_PATTERN.split(frag);
                    if (frgs.length == 1) {
                        methodName = frag;
                        types = oldRecentTypes;
                    } else {
                        assert (frgs.length == 2) : frag;
                        methodName = frgs[1];
                        String typeName = frgs[0];
                        assert (typeName != null) : frag;
                        QualifiedName qualifiedName = VariousUtils.getFullyQualifiedName(VariousUtils.createQuery(typeName, varScope), offset, varScope);
                        types = IndexScopeImpl.getTypes(qualifiedName, varScope);
                    }
                    for (TypeScope typeScope : types) {
                        Collection<? extends MethodScope> inheritedMethods = IndexScopeImpl.getMethods(typeScope, methodName, varScope, -1);
                        for (MethodScope methodScope : inheritedMethods) {
                            if (callerTypes.isEmpty()) {
                                newRecentTypes.addAll(methodScope.getReturnTypes(true, types));
                                continue;
                            }
                            newRecentTypes.addAll(methodScope.getReturnTypes(true, callerTypes));
                        }
                    }
                    recentTypes = newRecentTypes;
                    operation = null;
                    continue;
                }
                if (operation.startsWith(VAR_TYPE_PREFIX) || operation.startsWith(ARRAY_TYPE_PREFIX)) {
                    newRecentTypes = new HashSet();
                    String varName = frag;
                    VariableName var = VariousUtils.getVariableName(varScope, varName);
                    if (var != null) {
                        if (i + 2 < len && FIELD_TYPE_PREFIX.startsWith(fragments[i + 1])) {
                            fldVarStack.push(var);
                        }
                        String checkName = var.getName() + String.valueOf(offset);
                        boolean added = recursionDetection.add(checkName);
                        try {
                            if (added) {
                                boolean bl = operation.startsWith(ARRAY_TYPE_PREFIX);
                                if (bl) {
                                    newRecentTypes.addAll(var.getArrayAccessTypes(offset));
                                } else {
                                    newRecentTypes.addAll(var.getTypes(offset));
                                }
                            }
                        }
                        finally {
                            recursionDetection.remove(checkName);
                        }
                    }
                    if (newRecentTypes.isEmpty() && varScope instanceof MethodScope) {
                        MethodScope mScope = (MethodScope)varScope;
                        if (frag.equals("this") || frag.equals("$this")) {
                            Scope inScope = mScope.getInScope();
                            if (inScope instanceof ClassScope) {
                                String string2 = ((ClassScope)inScope).getName();
                                newRecentTypes.addAll(IndexScopeImpl.getClasses(QualifiedName.create(string2), varScope));
                            } else if (inScope instanceof EnumScope) {
                                String string3 = ((EnumScope)inScope).getName();
                                newRecentTypes.addAll(IndexScopeImpl.getEnums(QualifiedName.create(string3), varScope));
                            } else if (inScope instanceof TraitScope) {
                                String string4 = ((TraitScope)inScope).getName();
                                newRecentTypes.addAll(IndexScopeImpl.getTraits(QualifiedName.create(string4), varScope));
                            }
                        }
                    }
                    recentTypes = newRecentTypes;
                    operation = null;
                    continue;
                }
                if (operation.startsWith(FIELD_TYPE_PREFIX)) {
                    VariableName var = fldVarStack.isEmpty() ? null : (VariableName)fldVarStack.pop();
                    HashSet<? extends TypeScope> newRecentTypes2 = new HashSet<TypeScope>();
                    Object fldName = frag;
                    if (!((String)fldName).startsWith("$")) {
                        fldName = "$" + (String)fldName;
                    }
                    for (TypeScope type : oldRecentTypes) {
                        Collection<? extends FieldElement> collection = IndexScopeImpl.getFields(type, (String)fldName, varScope, -1);
                        for (FieldElement fieldElement : collection) {
                            Collection collection2 = fieldElement.getTypes(offset);
                            if (collection2.isEmpty() && var != null) {
                                Collection varFieldTypes = var.getFieldTypes(fieldElement, offset);
                                if (varFieldTypes.isEmpty() && fieldElement instanceof FieldElementImpl) {
                                    newRecentTypes2.addAll(((FieldElementImpl)fieldElement).getDefaultTypes());
                                    continue;
                                }
                                newRecentTypes2.addAll(varFieldTypes);
                                continue;
                            }
                            newRecentTypes2.addAll(collection2);
                        }
                    }
                    recentTypes = newRecentTypes2;
                    operation = null;
                    continue;
                }
                throw new UnsupportedOperationException(operation);
            }
        } else if (semiTypeName != null) {
            String typeName = CodeUtils.removeNullableTypePrefix(semiTypeName);
            List typeNames = StringUtils.explode((String)typeName, (String)"|");
            ArrayList<QualifiedName> qualifiedNames = new ArrayList<QualifiedName>();
            for (String name2 : typeNames) {
                QualifiedName qn = QualifiedName.create(name2);
                String translatedName = VariousUtils.translateSpecialClassName(varScope, qn.getName());
                QualifiedNameKind kind = QualifiedNameKind.resolveKind(translatedName);
                qn = kind == QualifiedNameKind.UNQUALIFIED ? qn.toNamespaceName().append(translatedName) : QualifiedName.create(translatedName);
                if (name2.startsWith("\\")) {
                    qn = qn.toFullyQualified();
                } else {
                    Collection<QualifiedName> possibleFQN;
                    NamespaceScope namespaceScope = ModelUtils.getNamespaceScope(varScope);
                    if (namespaceScope != null && !(possibleFQN = VariousUtils.getPossibleFQN(qn, offset, namespaceScope)).isEmpty()) {
                        qn = ModelUtils.getFirst(possibleFQN);
                    }
                }
                qualifiedNames.add(qn);
            }
            IndexScope indexScope = ModelUtils.getIndexScope(varScope);
            ArrayList typeScopes = new ArrayList();
            qualifiedNames.forEach(name -> typeScopes.addAll(indexScope.findTypes((QualifiedName)name)));
            return typeScopes;
        }
        return recentTypes;
    }

    @CheckForNull
    private static VariableName getVariableName(VariableScope varScope, String varName) {
        VariableName var = ModelUtils.getFirst(varScope.getDeclaredVariables(), varName);
        if (var == null && ModelUtils.isAnonymousFunction(varScope) && varName.equals("$this")) {
            Scope inScope = varScope.getInScope();
            while (ModelUtils.isAnonymousFunction(inScope)) {
                inScope = inScope.getInScope();
            }
            if (inScope instanceof VariableScope) {
                var = ModelUtils.getFirst(((VariableScope)inScope).getDeclaredVariables(), varName);
            }
        }
        return var;
    }

    private static Collection<TypeScope> filterSuperTypes(Collection<? extends TypeScope> typeScopes) {
        HashSet<TypeScope> result = new HashSet<TypeScope>();
        if (typeScopes.size() > 1) {
            result.addAll(VariousUtils.filterPossibleSuperTypes(typeScopes));
        } else {
            result.addAll(typeScopes);
        }
        return result;
    }

    private static Collection<TypeScope> filterPossibleSuperTypes(Collection<? extends TypeScope> typeScopes) {
        HashSet<TypeScope> result = new HashSet<TypeScope>();
        for (TypeScope typeScope : typeScopes) {
            if (VariousUtils.isSuperTypeOf(typeScope, typeScopes)) continue;
            result.add(typeScope);
        }
        return result;
    }

    private static boolean isSuperTypeOf(TypeScope superType, Collection<? extends TypeScope> typeScopes) {
        boolean result = false;
        for (TypeScope typeScope : typeScopes) {
            if (!superType.isSuperTypeOf(typeScope)) continue;
            result = true;
            break;
        }
        return result;
    }

    private static QualifiedName createQuery(String semiTypeName, Scope scope) {
        QualifiedName query = QualifiedName.create(semiTypeName);
        String translatedName = VariousUtils.translateSpecialClassName(scope, query.getName());
        QualifiedName result = translatedName != null ? (translatedName.startsWith("\\") ? QualifiedName.create(translatedName) : query.toNamespaceName(query.getKind().isFullyQualified()).append(translatedName)) : query.toNamespaceName(query.getKind().isFullyQualified());
        return result;
    }

    public static ArrayDeque<? extends ModelElement> getElements(FileScope topScope, VariableScope varScope, String semiTypeName, int offset) {
        ArrayDeque emptyStack = new ArrayDeque();
        ArrayDeque<ModelElement> retval = new ArrayDeque<ModelElement>();
        ArrayDeque<Collection> stack = new ArrayDeque<Collection>();
        if (semiTypeName != null && semiTypeName.contains(PRE_OPERATION_TYPE_DELIMITER)) {
            String operation = null;
            String[] fragments = SEMI_TYPE_NAME_PATTERN.split(semiTypeName);
            int len = fragments.length;
            for (int i = 0; i < len; ++i) {
                TypeScope type;
                MethodScope meth;
                TypeScope cls;
                Collection<? extends TypeScope> types;
                String operationPrefix;
                String frag = fragments[i];
                if (frag.trim().length() == 0) continue;
                String string = operationPrefix = frag.endsWith(POST_OPERATION_TYPE_DELIMITER) ? frag : String.format("%s%s", frag, POST_OPERATION_TYPE_DELIMITER);
                if (METHOD_TYPE_PREFIX.equalsIgnoreCase(operationPrefix)) {
                    operation = METHOD_TYPE_PREFIX;
                    continue;
                }
                if (FUNCTION_TYPE_PREFIX.equalsIgnoreCase(operationPrefix)) {
                    operation = FUNCTION_TYPE_PREFIX;
                    continue;
                }
                if (STATIC_METHOD_TYPE_PREFIX.equalsIgnoreCase(operationPrefix)) {
                    operation = STATIC_METHOD_TYPE_PREFIX;
                    continue;
                }
                if (VAR_TYPE_PREFIX.equalsIgnoreCase(operationPrefix)) {
                    operation = VAR_TYPE_PREFIX;
                    continue;
                }
                if (FIELD_TYPE_PREFIX.equalsIgnoreCase(operationPrefix)) {
                    operation = FIELD_TYPE_PREFIX;
                    continue;
                }
                if (CONSTRUCTOR_TYPE_PREFIX.equalsIgnoreCase(operationPrefix)) {
                    operation = CONSTRUCTOR_TYPE_PREFIX;
                    continue;
                }
                if (operation == null) {
                    assert (i == 0);
                    types = IndexScopeImpl.getTypes(QualifiedName.create(frag), topScope);
                    if (types.isEmpty()) continue;
                    stack.push(types);
                    continue;
                }
                if (operation.startsWith(METHOD_TYPE_PREFIX)) {
                    Collection<? extends TypeScope> collection = types = stack.isEmpty() ? null : (Collection<? extends TypeScope>)stack.pop();
                    if (types == null || types.isEmpty()) {
                        return emptyStack;
                    }
                    cls = ModelUtils.getFirst(types);
                    if (cls == null) {
                        return emptyStack;
                    }
                    Collection<? extends MethodScope> methods = IndexScopeImpl.getMethods(cls, frag, topScope, -1);
                    meth = ModelUtils.getFirst(methods);
                    if (methods.isEmpty()) {
                        return emptyStack;
                    }
                    retval.push(meth);
                    types = meth.getReturnTypes(true, types);
                    if (types == null || types.isEmpty()) break;
                    stack.push(types);
                    operation = null;
                    continue;
                }
                if (operation.startsWith(FUNCTION_TYPE_PREFIX)) {
                    FunctionScope fnc = ModelUtils.getFirst(IndexScopeImpl.getFunctions(QualifiedName.create(frag), topScope));
                    if (fnc == null) break;
                    retval.push(fnc);
                    List recentTypes = stack.isEmpty() ? Collections.emptyList() : (Collection)stack.peek();
                    Collection<? extends TypeScope> returnTypes = fnc.getReturnTypes(true, recentTypes);
                    type = ModelUtils.getFirst(returnTypes);
                    if (type == null) break;
                    stack.push(returnTypes);
                    operation = null;
                    continue;
                }
                if (operation.startsWith(CONSTRUCTOR_TYPE_PREFIX)) {
                    ClassScope cls2 = ModelUtils.getFirst(IndexScopeImpl.getClasses(QualifiedName.create(frag), topScope));
                    if (cls2 == null) break;
                    MethodScope meth2 = ModelUtils.getFirst(IndexScopeImpl.getMethods(cls2, "__construct", topScope, -1));
                    if (meth2 == null) {
                        return emptyStack;
                    }
                    retval.push(meth2);
                    stack.push(Collections.singletonList(cls2));
                    operation = null;
                    continue;
                }
                if (operation.startsWith(STATIC_METHOD_TYPE_PREFIX)) {
                    String[] frgs = DOT_PATTERN.split(frag);
                    assert (frgs.length == 2);
                    String clsName = frgs[0];
                    if (clsName == null) {
                        return emptyStack;
                    }
                    ClassScope cls3 = ModelUtils.getFirst(IndexScopeImpl.getClasses(QualifiedName.create(clsName), topScope));
                    if (cls3 == null) {
                        return emptyStack;
                    }
                    meth = ModelUtils.getFirst(IndexScopeImpl.getMethods(cls3, frgs[1], topScope, -1));
                    if (meth == null) {
                        return emptyStack;
                    }
                    retval.push(meth);
                    List recentTypes = stack.isEmpty() ? Collections.emptyList() : (Collection)stack.peek();
                    Collection<? extends TypeScope> returnTypes = meth.getReturnTypes(true, recentTypes);
                    type = ModelUtils.getFirst(returnTypes);
                    if (type == null) break;
                    stack.push(returnTypes);
                    operation = null;
                    continue;
                }
                if (operation.startsWith(VAR_TYPE_PREFIX)) {
                    List<? extends VariableName> variables;
                    Collection types2;
                    NamespaceScope nScope;
                    VariableName varName;
                    type = null;
                    if (varScope instanceof MethodScope) {
                        MethodScope mScope = (MethodScope)varScope;
                        if (frag.equals("this") || frag.equals("$this")) {
                            type = (ClassScope)mScope.getInScope();
                        }
                        if (type != null) {
                            stack.push(Collections.singletonList(type));
                            operation = null;
                        }
                    } else if (varScope instanceof NamespaceScope && (varName = ModelUtils.getFirst((nScope = (NamespaceScope)varScope).getDeclaredVariables(), frag)) != null && (type = (TypeScope)ModelUtils.getFirst(types2 = varName.getTypes(offset))) != null) {
                        stack.push(types2);
                        operation = null;
                    }
                    if (type != null || (variables = ModelUtils.filter(varScope.getDeclaredVariables(), frag)).isEmpty()) continue;
                    varName = ModelUtils.getFirst(variables);
                    types2 = varName != null ? varName.getTypes(offset) : null;
                    TypeScope typeScope = type = types2 != null ? (TypeScope)ModelUtils.getFirst(types2) : null;
                    if (varName != null) {
                        retval.push(varName);
                    }
                    if (type == null) break;
                    stack.push(types2);
                    operation = null;
                    continue;
                }
                if (operation.startsWith(FIELD_TYPE_PREFIX)) {
                    Collection<? extends TypeScope> collection = types = stack.isEmpty() ? null : (Collection<? extends TypeScope>)stack.pop();
                    if (types == null || types.isEmpty()) {
                        return emptyStack;
                    }
                    cls = ModelUtils.getFirst(types);
                    if (cls == null || !(cls instanceof ClassScope)) {
                        return emptyStack;
                    }
                    FieldElement fieldElement = ModelUtils.getFirst(IndexScopeImpl.getFields((ClassScope)cls, !frag.startsWith("$") ? String.format("%s%s", "$", frag) : frag, topScope, -1));
                    if (fieldElement == null) {
                        return emptyStack;
                    }
                    retval.push(fieldElement);
                    Collection fieldTypes = fieldElement.getTypes(offset);
                    type = (TypeScope)ModelUtils.getFirst(fieldTypes);
                    if (type == null) break;
                    stack.push(fieldTypes);
                    operation = null;
                    continue;
                }
                throw new UnsupportedOperationException(operation);
            }
        }
        return retval;
    }

    private static void createVariableBaseChain(VariableBase node, ArrayDeque<VariableBase> stack) {
        Expression dispatcher;
        stack.push(node);
        if (node instanceof MethodInvocation) {
            VariousUtils.createVariableBaseChain(((MethodInvocation)node).getDispatcher(), stack);
        } else if (node instanceof FieldAccess) {
            VariousUtils.createVariableBaseChain(((FieldAccess)node).getDispatcher(), stack);
        } else if (node instanceof StaticDispatch && (dispatcher = ((StaticDispatch)node).getDispatcher()) instanceof VariableBase) {
            VariousUtils.createVariableBaseChain((VariableBase)dispatcher, stack);
        }
    }

    @CheckForNull
    private static String extractVariableTypeFromVariableBase(VariableBase varBase, Map<String, AssignmentImpl> allAssignments) {
        if (varBase instanceof AnonymousObjectVariable) {
            CloneExpression ce;
            AnonymousObjectVariable aov = (AnonymousObjectVariable)varBase;
            Expression clsName = aov.getName();
            assert (clsName instanceof ClassInstanceCreation || clsName instanceof CloneExpression) : clsName.getClass().getName();
            if (clsName instanceof CloneExpression && (clsName = (ce = (CloneExpression)clsName).getExpression()) instanceof AnonymousObjectVariable) {
                clsName = ((AnonymousObjectVariable)clsName).getName();
            }
            if (clsName instanceof ClassInstanceCreation) {
                return VariousUtils.getVariableType((ClassInstanceCreation)clsName);
            }
        } else if (varBase instanceof ClassInstanceCreationVariable) {
            ClassInstanceCreationVariable classInstanceCreationVariable = (ClassInstanceCreationVariable)varBase;
            Expression clsName = classInstanceCreationVariable.getName();
            if (clsName instanceof ClassInstanceCreation) {
                return VariousUtils.getVariableType((ClassInstanceCreation)clsName);
            }
        } else {
            StaticConstantAccess constantAccess;
            if (varBase instanceof Variable) {
                String semiTypeName;
                String varName = CodeUtils.extractVariableName((Variable)varBase);
                AssignmentImpl assignmentImpl = allAssignments.get(varName);
                if (assignmentImpl != null && (semiTypeName = assignmentImpl.typeNameFromUnion()) != null) {
                    return semiTypeName;
                }
                return "@var-type:" + varName;
            }
            if (varBase instanceof FunctionInvocation) {
                FunctionInvocation functionInvocation = (FunctionInvocation)varBase;
                String fname = CodeUtils.extractFunctionName(functionInvocation);
                return "@fn-type:" + fname;
            }
            if (varBase instanceof StaticMethodInvocation) {
                String methodName;
                StaticMethodInvocation staticMethodInvocation = (StaticMethodInvocation)varBase;
                String className = null;
                Expression dispatcher = staticMethodInvocation.getDispatcher();
                if (dispatcher instanceof Identifier || dispatcher instanceof NamespaceName) {
                    className = CodeUtils.extractQualifiedName(dispatcher);
                }
                if ((methodName = CodeUtils.extractFunctionName(staticMethodInvocation.getMethod())) != null) {
                    if (className != null) {
                        return "@static.mtd-type:" + className + "." + methodName;
                    }
                    return "@static.mtd-type:" + methodName;
                }
            } else if (varBase instanceof MethodInvocation) {
                MethodInvocation methodInvocation = (MethodInvocation)varBase;
                String methodName = CodeUtils.extractFunctionName(methodInvocation.getMethod());
                if (methodName != null) {
                    return "@mtd-type:" + methodName;
                }
            } else if (varBase instanceof FieldAccess) {
                FieldAccess fieldAccess = (FieldAccess)varBase;
                String filedName = CodeUtils.extractVariableName(fieldAccess.getField());
                if (filedName != null) {
                    return "@fld-type:" + VariousUtils.encodeVariableName(filedName);
                }
            } else if (varBase instanceof StaticFieldAccess) {
                StaticFieldAccess fieldAccess = (StaticFieldAccess)varBase;
                String clsName = CodeUtils.extractUnqualifiedName(fieldAccess.getDispatcher());
                String fldName = CodeUtils.extractVariableName(fieldAccess.getField());
                if (fldName != null) {
                    if (clsName != null) {
                        return "@static.fld-type:" + clsName + "." + fldName;
                    }
                    return "@static.fld-type:" + fldName;
                }
            } else if (varBase instanceof StaticConstantAccess && !(constantAccess = (StaticConstantAccess)varBase).isDynamicName()) {
                String clsName = CodeUtils.extractUnqualifiedName(constantAccess.getDispatcher());
                String constName = CodeUtils.extractQualifiedName(constantAccess.getConstant());
                if (constName != null) {
                    if (clsName != null) {
                        return "@static.constant-type:" + clsName + "." + constName;
                    }
                    return "@static.constant-type:" + constName;
                }
            }
        }
        return null;
    }

    private static String getVariableType(ClassInstanceCreation classInstanceCreation) {
        String className = CodeUtils.extractClassName(classInstanceCreation.getClassName());
        return "@constuct-type:" + className;
    }

    public static String resolveFileName(Include include) {
        Scalar s;
        Expression e = include.getExpression();
        if (e instanceof ParenthesisExpression) {
            e = ((ParenthesisExpression)e).getExpression();
        }
        if (e instanceof Scalar && Scalar.Type.STRING == (s = (Scalar)e).getScalarType()) {
            String fileName = s.getStringValue();
            fileName = fileName.length() >= 2 ? fileName.substring(1, fileName.length() - 1) : fileName;
            return fileName;
        }
        return null;
    }

    public static FileObject resolveInclude(FileObject sourceFile, Include include) {
        Parameters.notNull((CharSequence)"sourceFile", (Object)sourceFile);
        if (sourceFile.isFolder()) {
            throw new IllegalArgumentException(FileUtil.getFileDisplayName((FileObject)sourceFile));
        }
        return VariousUtils.resolveInclude(sourceFile, VariousUtils.resolveFileName(include));
    }

    public static FileObject resolveInclude(FileObject sourceFile, String fileName) {
        FileObject retval = null;
        if (fileName != null) {
            File absoluteFile = new File(fileName);
            if (absoluteFile.exists()) {
                retval = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)absoluteFile));
            } else {
                FileObject parent = sourceFile.getParent();
                if (parent != null) {
                    retval = PhpSourcePath.resolveFile((FileObject)parent, (String)fileName);
                }
            }
        }
        return retval;
    }

    @SuppressWarnings(value={"SF_SWITCH_FALLTHROUGH"})
    public static String getSemiType(TokenSequence<PHPTokenId> tokenSequence, State state, VariableScope varScope, Model model) {
        String retval;
        int commasCount = 0;
        String possibleClassName = "";
        int anchor = -1;
        int leftBraces = 0;
        int rightBraces = State.PARAMS.equals((Object)state) ? 1 : 0;
        int arrayBrackets = 0;
        String className = null;
        String fieldName = null;
        CloneExpressionInfo cloneInfo = new CloneExpressionInfo();
        StringBuilder metaAll = new StringBuilder();
        block12: while (!state.equals((Object)State.INVALID) && !state.equals((Object)State.STOP) && tokenSequence.movePrevious() && VariousUtils.skipWhitespaces(tokenSequence)) {
            ClassScope anonymousClass;
            Token token = tokenSequence.token();
            if (!CTX_DELIMITERS.contains(token.id()) || VariousUtils.isVarTypeComment((Token<PHPTokenId>)token)) {
                switch (state) {
                    case METHOD: 
                    case START: {
                        State state2 = state = state.equals((Object)State.METHOD) ? State.STOP : State.INVALID;
                        if (VariousUtils.isReference((Token<PHPTokenId>)token)) {
                            metaAll.insert(0, "@mtd-type:");
                            state = State.REFERENCE;
                            cloneInfo.setReference(state);
                            continue block12;
                        }
                        if (VariousUtils.isStaticReference((Token<PHPTokenId>)token)) {
                            metaAll.insert(0, "@mtd-type:");
                            state = State.STATIC_REFERENCE;
                            cloneInfo.setReference(state);
                            continue block12;
                        }
                        if (!state.equals((Object)State.STOP)) continue block12;
                        metaAll.insert(0, "@fn-type:");
                        continue block12;
                    }
                    case IDX: {
                        if (VariousUtils.isLeftArryBracket((Token<PHPTokenId>)token)) {
                            if (--arrayBrackets != 0) continue block12;
                            state = State.ARRAYREFERENCE;
                            continue block12;
                        }
                        if (VariousUtils.isRightArryBracket((Token<PHPTokenId>)token)) {
                            ++arrayBrackets;
                            continue block12;
                        }
                        if (!CTX_DELIMITERS.contains(token.id())) continue block12;
                        state = State.INVALID;
                        continue block12;
                    }
                    case ARRAYREFERENCE: 
                    case REFERENCE: {
                        boolean isArray = state.equals((Object)State.ARRAYREFERENCE);
                        state = State.INVALID;
                        if (VariousUtils.isRightBracket((Token<PHPTokenId>)token)) {
                            ++rightBraces;
                            state = State.PARAMS;
                            cloneInfo.setEndOffset(tokenSequence.offset());
                            continue block12;
                        }
                        if (VariousUtils.isRightArryBracket((Token<PHPTokenId>)token)) {
                            ++arrayBrackets;
                            state = State.IDX;
                            continue block12;
                        }
                        if (VariousUtils.isString((Token<PHPTokenId>)token)) {
                            fieldName = token.text().toString();
                            state = isArray ? State.ARRAY_FIELD : State.FIELD;
                            continue block12;
                        }
                        if (!VariousUtils.isVariable((Token<PHPTokenId>)token)) continue block12;
                        metaAll.insert(0, token.text().toString());
                        state = isArray ? State.ARRAY_VARIABLE : State.VARBASE;
                        continue block12;
                    }
                    case STATIC_REFERENCE: {
                        state = State.INVALID;
                        if (VariousUtils.isString((Token<PHPTokenId>)token)) {
                            className = token.text().toString();
                            state = State.CLASSNAME;
                            continue block12;
                        }
                        if (VariousUtils.isSelf((Token<PHPTokenId>)token) || VariousUtils.isParent((Token<PHPTokenId>)token) || VariousUtils.isStatic((Token<PHPTokenId>)token)) {
                            className = VariousUtils.translateSpecialClassName(varScope, token.text().toString());
                            state = State.CLASSNAME;
                            continue block12;
                        }
                        if (VariousUtils.isRightBracket((Token<PHPTokenId>)token)) {
                            ++rightBraces;
                            state = State.PARAMS;
                            cloneInfo.setEndOffset(tokenSequence.offset());
                            continue block12;
                        }
                        if (VariousUtils.isRightArryBracket((Token<PHPTokenId>)token)) {
                            ++arrayBrackets;
                            state = State.IDX;
                            continue block12;
                        }
                        if (!VariousUtils.isVariable((Token<PHPTokenId>)token)) continue block12;
                        metaAll.insert(0, token.text().toString());
                        state = State.VARBASE;
                        continue block12;
                    }
                    case PARAMS: {
                        if (VariousUtils.isWhiteSpace((Token<PHPTokenId>)token)) {
                            state = State.PARAMS;
                        } else if (VariousUtils.isComma((Token<PHPTokenId>)token)) {
                            if (metaAll.length() == 0) {
                                ++commasCount;
                            }
                        } else if (CTX_DELIMITERS.contains(token.id())) {
                            state = State.INVALID;
                        } else if (VariousUtils.isLeftBracket((Token<PHPTokenId>)token)) {
                            ++leftBraces;
                        } else if (VariousUtils.isRightBracket((Token<PHPTokenId>)token)) {
                            ++rightBraces;
                        } else if (VariousUtils.isString((Token<PHPTokenId>)token)) {
                            possibleClassName = VariousUtils.fetchPossibleClassName(tokenSequence);
                        }
                        if (leftBraces == rightBraces) {
                            state = State.FUNCTION;
                        }
                        if (PHPTokenId.PHP_CLONE != token.id() || cloneInfo.getEndOffset() == -1 || cloneInfo.getReference() == null) continue block12;
                        tokenSequence.move(cloneInfo.getEndOffset());
                        tokenSequence.moveNext();
                        state = cloneInfo.getReference();
                        --rightBraces;
                        continue block12;
                    }
                    case FUNCTION: {
                        state = State.INVALID;
                        if (!VariousUtils.isString((Token<PHPTokenId>)token)) continue block12;
                        metaAll.insert(0, token.text().toString());
                        if (anchor == -1) {
                            anchor = tokenSequence.offset();
                        }
                        state = State.METHOD;
                        continue block12;
                    }
                    case ARRAY_FIELD: 
                    case FIELD: {
                        state = State.INVALID;
                        if (VariousUtils.isStaticReference((Token<PHPTokenId>)token)) {
                            state = State.STATIC_REFERENCE;
                            continue block12;
                        }
                        assert (fieldName != null);
                        metaAll.insert(0, fieldName);
                        fieldName = null;
                        if (!VariousUtils.isReference((Token<PHPTokenId>)token)) continue block12;
                        metaAll.insert(0, "@fld-type:");
                        state = State.REFERENCE;
                        continue block12;
                    }
                    case VARBASE: {
                        if (VariousUtils.isStaticReference((Token<PHPTokenId>)token)) {
                            metaAll.insert(0, "@fld-type:");
                            state = State.STATIC_REFERENCE;
                            continue block12;
                        }
                        state = State.VARIABLE;
                    }
                    case ARRAY_VARIABLE: 
                    case VARIABLE: {
                        if (state.equals((Object)State.ARRAY_VARIABLE)) {
                            metaAll.insert(0, "@array-type:");
                        } else {
                            metaAll.insert(0, "@var-type:");
                        }
                    }
                    case CLASSNAME: {
                        if (VariousUtils.isStaticReference((Token<PHPTokenId>)token)) {
                            state = State.STATIC_REFERENCE;
                            continue block12;
                        }
                        if (className != null) {
                            metaAll.insert(0, className);
                            className = null;
                        }
                        if (VariousUtils.isNamespaceSeparator((Token<PHPTokenId>)token)) {
                            if (tokenSequence.movePrevious()) {
                                metaAll.insert(0, token.text().toString());
                                token = tokenSequence.token();
                                if (VariousUtils.isString((Token<PHPTokenId>)token)) {
                                    metaAll.insert(0, token.text().toString());
                                    continue block12;
                                }
                                metaAll.insert(0, "@type-type:");
                            }
                        } else {
                            if (VariousUtils.isReference((Token<PHPTokenId>)token)) {
                                metaAll.insert(0, "@fld-type:");
                                state = State.REFERENCE;
                                continue block12;
                            }
                            metaAll = VariousUtils.transformToFullyQualifiedType(metaAll, tokenSequence, varScope);
                            metaAll.insert(0, "@type-type:");
                        }
                        state = State.STOP;
                        continue block12;
                    }
                }
                continue;
            }
            if (token.id() == PHPTokenId.PHP_CURLY_CLOSE && (state == State.REFERENCE || state == State.STATIC_REFERENCE) && (anonymousClass = VariousUtils.getAnonymousClass(tokenSequence.offset() + tokenSequence.token().length(), model)) != null) {
                state = State.STOP;
                metaAll.insert(0, "@constuct-type:" + anonymousClass.getName());
                break;
            }
            if (state.equals((Object)State.VARBASE)) {
                metaAll.insert(0, "@var-type:");
                state = State.STOP;
                break;
            }
            if (state.equals((Object)State.CLASSNAME)) {
                if (className != null) {
                    metaAll.insert(0, className);
                    className = null;
                }
                if (!metaAll.toString().startsWith("\\") && tokenSequence.moveNext()) {
                    metaAll = VariousUtils.transformToFullyQualifiedType(metaAll, tokenSequence, varScope);
                }
                metaAll.insert(0, "@type-type:");
                state = State.STOP;
                break;
            }
            if (state.equals((Object)State.METHOD)) {
                state = State.STOP;
                PHPTokenId id = (PHPTokenId)token.id();
                if (id != null && PHPTokenId.PHP_NEW.equals((Object)id)) {
                    metaAll.insert(0, "@constuct-type:");
                    break;
                }
                metaAll.insert(0, "@fn-type:");
                break;
            }
            if (!state.equals((Object)State.PARAMS) || possibleClassName.isEmpty() || token.id() == null || !PHPTokenId.PHP_NEW.equals(token.id()) || rightBraces - 1 != leftBraces || !VariousUtils.isPossibleAnonymousObjectCall(tokenSequence)) continue;
            state = State.STOP;
            metaAll.insert(0, "@constuct-type:" + possibleClassName);
            break;
        }
        if (state.equals((Object)State.STOP) && (retval = metaAll.toString()) != null) {
            return retval;
        }
        return null;
    }

    @CheckForNull
    private static ClassScope getAnonymousClass(int anonymousClassEndOffset, Model model) {
        Collection<? extends ClassScope> classScopes = ModelUtils.getDeclaredClasses(model.getFileScope());
        for (ClassScope classScope : classScopes) {
            if (!classScope.isAnonymous() || classScope.getBlockRange().getEnd() != anonymousClassEndOffset) continue;
            return classScope;
        }
        return null;
    }

    private static boolean isPossibleAnonymousObjectCall(TokenSequence<PHPTokenId> tokenSequence) {
        boolean result = true;
        boolean skippedOpenParenthesis = tokenSequence.movePrevious();
        if (skippedOpenParenthesis) {
            boolean posibleMethodTokenNameExists = tokenSequence.movePrevious();
            if (posibleMethodTokenNameExists) {
                Token token = tokenSequence.token();
                if (VariousUtils.isString((Token<PHPTokenId>)token) || VariousUtils.isComma((Token<PHPTokenId>)token)) {
                    result = false;
                }
                tokenSequence.moveNext();
            }
            tokenSequence.moveNext();
        }
        return result;
    }

    private static boolean isVarTypeComment(Token<PHPTokenId> token) {
        boolean result = false;
        if (token != null) {
            CharSequence tokenText = token.text();
            if (PHPTokenId.PHP_COMMENT.equals(token.id()) && tokenText != null && tokenText.toString().trim().startsWith(VAR_TYPE_COMMENT_PREFIX)) {
                result = true;
            }
        }
        return result;
    }

    private static String fetchPossibleClassName(TokenSequence<PHPTokenId> tokenSequence) {
        Object result;
        Object object = result = VariousUtils.isString((Token<PHPTokenId>)tokenSequence.token()) ? tokenSequence.token().text().toString() : "";
        while (tokenSequence.movePrevious() && (VariousUtils.isString((Token<PHPTokenId>)tokenSequence.token()) || VariousUtils.isNamespaceSeparator((Token<PHPTokenId>)tokenSequence.token()))) {
            result = tokenSequence.token().text().toString() + (String)result;
        }
        tokenSequence.moveNext();
        return result;
    }

    private static StringBuilder transformToFullyQualifiedType(StringBuilder metaAll, TokenSequence<PHPTokenId> tokenSequence, Scope varScope) {
        String lastType;
        StringBuilder result = metaAll;
        String currentMetaAll = metaAll.toString();
        int indexOfType = currentMetaAll.indexOf(PRE_OPERATION_TYPE_DELIMITER);
        if (indexOfType != -1 && !(lastType = currentMetaAll.substring(0, indexOfType)).trim().isEmpty()) {
            String qualifiedTypeName = VariousUtils.qualifyTypeNames(lastType, tokenSequence.offset(), varScope);
            result = new StringBuilder(qualifiedTypeName + currentMetaAll.substring(indexOfType));
        }
        return result;
    }

    public static String getVariableName(String semiType) {
        String prefix;
        if (semiType != null && semiType.startsWith(prefix = "@var-type:")) {
            return semiType.substring(prefix.length(), semiType.lastIndexOf(PRE_OPERATION_TYPE_DELIMITER));
        }
        return null;
    }

    private static boolean skipWhitespaces(TokenSequence<PHPTokenId> tokenSequence) {
        Token token = tokenSequence.token();
        while (token != null && VariousUtils.isWhiteSpace((Token<PHPTokenId>)token)) {
            boolean retval = tokenSequence.movePrevious();
            token = tokenSequence.token();
            if (retval) continue;
            return false;
        }
        return true;
    }

    private static String translateSpecialClassName(Scope scp, String clsName) {
        MethodScope msi;
        Scope inScope;
        TypeScope typeScope = null;
        if (scp instanceof ClassScope || scp instanceof TraitScope || scp instanceof EnumScope) {
            typeScope = (TypeScope)scp;
        } else if (scp instanceof MethodScope && ((inScope = (msi = (MethodScope)scp).getInScope()) instanceof ClassScope || inScope instanceof TraitScope || inScope instanceof EnumScope)) {
            typeScope = (TypeScope)inScope;
        }
        if (typeScope != null) {
            switch (clsName) {
                case "self": 
                case "this": 
                case "static": {
                    clsName = typeScope.getName();
                    break;
                }
                case "parent": {
                    if (!(typeScope instanceof ClassScope)) break;
                    ClassScope classScope = (ClassScope)typeScope;
                    QualifiedName fullyQualifiedName = (QualifiedName)ModelUtils.getFirst(classScope.getPossibleFQSuperClassNames());
                    if (fullyQualifiedName != null) {
                        clsName = fullyQualifiedName.toString();
                        break;
                    }
                    ClassScope clzScope = ModelUtils.getFirst(classScope.getSuperClasses());
                    if (clzScope == null) break;
                    clsName = clzScope.getName();
                    break;
                }
            }
        }
        return clsName;
    }

    private static boolean moveToOffset(TokenSequence<PHPTokenId> tokenSequence, int offset) {
        return tokenSequence == null || tokenSequence.move(offset) < 0;
    }

    private static boolean isDolar(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_TOKEN) && TokenUtilities.textEquals((CharSequence)token.text(), (CharSequence)"$");
    }

    private static boolean isLeftBracket(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_TOKEN) && TokenUtilities.textEquals((CharSequence)token.text(), (CharSequence)"(");
    }

    private static boolean isRightBracket(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_TOKEN) && TokenUtilities.textEquals((CharSequence)token.text(), (CharSequence)")");
    }

    private static boolean isRightArryBracket(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_TOKEN) && TokenUtilities.textEquals((CharSequence)token.text(), (CharSequence)"]");
    }

    private static boolean isLeftArryBracket(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_TOKEN) && TokenUtilities.textEquals((CharSequence)token.text(), (CharSequence)"[");
    }

    private static boolean isComma(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_TOKEN) && TokenUtilities.textEquals((CharSequence)token.text(), (CharSequence)",");
    }

    private static boolean isReference(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_OBJECT_OPERATOR) || ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_NULLSAFE_OBJECT_OPERATOR);
    }

    private static boolean isNamespaceSeparator(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_NS_SEPARATOR);
    }

    private static boolean isWhiteSpace(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.WHITESPACE);
    }

    private static boolean isStaticReference(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_PAAMAYIM_NEKUDOTAYIM);
    }

    private static boolean isVariable(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_VARIABLE);
    }

    private static boolean isSelf(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_SELF);
    }

    private static boolean isStatic(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_STATIC);
    }

    private static boolean isParent(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_PARENT);
    }

    private static boolean isString(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_STRING);
    }

    public static Collection<? extends TypeScope> getStaticTypeName(Scope inScope, String staticTypeName) {
        TypeScope csi = null;
        if (inScope instanceof MethodScope) {
            MethodScope msi = (MethodScope)inScope;
            Scope methodInScope = msi.getInScope();
            if (methodInScope instanceof ClassScope) {
                csi = (ClassScope)methodInScope;
            } else if (methodInScope instanceof TraitScope) {
                csi = (TraitScope)methodInScope;
            } else if (methodInScope instanceof EnumScope) {
                csi = (EnumScope)methodInScope;
            }
        }
        if (inScope instanceof TypeScope) {
            csi = (TypeScope)inScope;
        }
        if (csi != null) {
            if ("self".equalsIgnoreCase(staticTypeName) || "static".equalsIgnoreCase(staticTypeName)) {
                return Collections.singletonList(csi);
            }
            if ("parent".equalsIgnoreCase(staticTypeName) && csi instanceof ClassScope) {
                return ((ClassScope)csi).getSuperClasses();
            }
        }
        return IndexScopeImpl.getTypes(QualifiedName.create(staticTypeName), inScope);
    }

    public static QualifiedName getPreferredName(QualifiedName fullName, NamespaceScope contextNamespace) {
        Collection<QualifiedName> allNames = VariousUtils.getAllNames(fullName, contextNamespace);
        int segmentCount = Integer.MAX_VALUE;
        QualifiedName retval = null;
        for (QualifiedName qualifiedName : allNames) {
            int size = qualifiedName.getSegments().size();
            if (size >= segmentCount) continue;
            retval = qualifiedName;
            segmentCount = size;
        }
        return retval;
    }

    public static Collection<QualifiedName> getAllNames(QualifiedName fullName, NamespaceScope contextNamespace) {
        HashSet<QualifiedName> namesProposals = new HashSet<QualifiedName>();
        namesProposals.addAll(VariousUtils.getRelatives(contextNamespace, fullName));
        namesProposals.add(fullName.toFullyQualified());
        return namesProposals;
    }

    public static Collection<QualifiedName> getRelativesToUses(NamespaceScope contextNamespace, QualifiedName fullName) {
        HashSet<QualifiedName> namesProposals = new HashSet<QualifiedName>();
        Collection<? extends UseScope> declaredUses = contextNamespace.getAllDeclaredSingleUses();
        for (UseScope useScope : declaredUses) {
            QualifiedName proposedName = QualifiedName.getSuffix(fullName, QualifiedName.create(useScope.getName()), true);
            if (proposedName == null) continue;
            AliasedName aliasedName = useScope.getAliasedName();
            if (aliasedName != null) {
                String nameWithoutAlias = proposedName.toString();
                int indexOfNsSeparator = nameWithoutAlias.indexOf("\\");
                String newName = indexOfNsSeparator == -1 ? aliasedName.getAliasName() : aliasedName.getAliasName() + nameWithoutAlias.substring(indexOfNsSeparator);
                proposedName = QualifiedName.create(newName);
            }
            namesProposals.add(proposedName);
        }
        return namesProposals;
    }

    public static Collection<QualifiedName> getRelativesToNamespace(NamespaceScope contextNamespace, QualifiedName fullName) {
        HashSet<QualifiedName> namesProposals = new HashSet<QualifiedName>();
        QualifiedName proposedName = QualifiedName.getSuffix(fullName, QualifiedName.create(contextNamespace), false);
        if (proposedName != null) {
            namesProposals.add(proposedName);
        }
        return namesProposals;
    }

    public static Collection<QualifiedName> getRelatives(NamespaceScope contextNamespace, QualifiedName fullName) {
        HashSet<QualifiedName> namesProposals = new HashSet<QualifiedName>();
        namesProposals.addAll(VariousUtils.getRelativesToNamespace(contextNamespace, fullName));
        namesProposals.addAll(VariousUtils.getRelativesToUses(contextNamespace, fullName));
        return namesProposals;
    }

    public static Collection<QualifiedName> getComposedNames(QualifiedName name, NamespaceScope contextNamespace) {
        Collection<? extends UseScope> declaredUses = contextNamespace.getAllDeclaredSingleUses();
        HashSet<QualifiedName> namesProposals = new HashSet<QualifiedName>();
        if (!name.getKind().isFullyQualified()) {
            QualifiedName proposedName = QualifiedName.create(contextNamespace).append(name).toFullyQualified();
            if (proposedName != null) {
                namesProposals.add(proposedName);
            }
            for (UseScope useScope : declaredUses) {
                QualifiedName useQName = QualifiedName.create(useScope.getName());
                proposedName = useQName.toNamespaceName().append(name).toFullyQualified();
                if (proposedName != null) {
                    namesProposals.add(proposedName);
                }
                if (useQName.getName().equalsIgnoreCase(name.getName()) || (proposedName = useQName.append(name).toFullyQualified()) == null) continue;
                namesProposals.add(proposedName);
            }
        }
        namesProposals.add(name);
        return namesProposals;
    }

    public static Collection<QualifiedName> getPossibleFQN(QualifiedName name, int nameOffset, NamespaceScope contextNamespace) {
        HashSet<QualifiedName> namespaces = new HashSet<QualifiedName>();
        boolean resolved = false;
        if (name.getKind().isFullyQualified()) {
            namespaces.add(name);
            resolved = true;
        } else {
            Collection<? extends UseScope> uses = contextNamespace.getAllDeclaredSingleUses();
            if (uses.size() > 0) {
                for (UseScope useScope : contextNamespace.getAllDeclaredSingleUses()) {
                    QualifiedName returnName;
                    if (useScope.getOffset() >= nameOffset) continue;
                    String firstNameSegment = name.getSegments().getFirst();
                    if (useScope.getAliasedName() != null && firstNameSegment.equals(useScope.getAliasedName().getAliasName())) {
                        returnName = useScope.getAliasedName().getRealName();
                    } else {
                        returnName = QualifiedName.create(useScope.getName());
                        if (!firstNameSegment.equals(returnName.getSegments().getLast())) {
                            returnName = null;
                        }
                    }
                    if (returnName == null) continue;
                    for (int i = 1; i < name.getSegments().size(); ++i) {
                        returnName = returnName.append(name.getSegments().get(i));
                    }
                    namespaces.add(returnName.toFullyQualified());
                    resolved = true;
                }
            }
        }
        if (!resolved) {
            if (name.getKind().isUnqualified()) {
                namespaces.add(contextNamespace.getNamespaceName().append(name).toFullyQualified());
            } else {
                namespaces.add(QualifiedName.create(contextNamespace).append(name).toFullyQualified());
            }
        }
        return namespaces;
    }

    public static boolean isAliased(QualifiedName qualifiedName, int offset, Scope inScope) {
        boolean result = false;
        if (!qualifiedName.getKind().isFullyQualified() && !VariousUtils.isSpecialClassName(qualifiedName.getName())) {
            result = VariousUtils.isAliasedClassName(qualifiedName.getSegments().getFirst(), offset, inScope);
        }
        return result;
    }

    public static boolean isAlias(QualifiedName unqualifiedName, int offset, Scope inScope) {
        boolean result = false;
        if (unqualifiedName.getKind().isUnqualified() && !VariousUtils.isSpecialClassName(unqualifiedName.getName())) {
            result = VariousUtils.isAliasedClassName(unqualifiedName.getSegments().getFirst(), offset, inScope);
        }
        return result;
    }

    private static boolean isAliasedClassName(String className, int offset, Scope inScope) {
        Scope scope;
        boolean result = false;
        for (scope = inScope; scope != null && !(scope instanceof NamespaceScope); scope = scope.getInScope()) {
        }
        if (scope != null) {
            result = VariousUtils.isAlias(className, offset, (NamespaceScope)scope);
        }
        return result;
    }

    private static boolean isAlias(String name, int offset, NamespaceScope namespaceScope) {
        boolean result = false;
        for (UseScope useScope : namespaceScope.getAllDeclaredSingleUses()) {
            AliasedName aliasName;
            if (useScope.getOffset() >= offset || (aliasName = useScope.getAliasedName()) == null || !name.equals(aliasName.getAliasName())) continue;
            result = true;
            break;
        }
        return result;
    }

    @CheckForNull
    public static AliasedName getAliasedName(QualifiedName qualifiedName, int offset, Scope inScope) {
        AliasedName result = null;
        if (!qualifiedName.getKind().isFullyQualified() && !VariousUtils.isSpecialClassName(qualifiedName.getName())) {
            Scope scope;
            for (scope = inScope; scope != null && !(scope instanceof NamespaceScope); scope = scope.getInScope()) {
            }
            if (scope != null) {
                NamespaceScope namespaceScope = (NamespaceScope)scope;
                String firstSegmentName = qualifiedName.getSegments().getFirst();
                for (UseScope useScope : namespaceScope.getAllDeclaredSingleUses()) {
                    AliasedName aliasName;
                    if (useScope.getOffset() >= offset || (aliasName = useScope.getAliasedName()) == null || !firstSegmentName.equals(aliasName.getAliasName())) continue;
                    result = aliasName;
                    break;
                }
            }
        }
        return result;
    }

    public static QualifiedName getFullyQualifiedName(QualifiedName qualifiedName, int offset, Scope inScope) {
        return TypeNameResolverImpl.forFullyQualifiedName(inScope, offset).resolve(qualifiedName);
    }

    public static String qualifyTypeNames(String typeNames, int offset, Scope inScope) {
        StringBuilder sb = new StringBuilder();
        if (typeNames != null) {
            if (typeNames.contains("(")) {
                String[] split;
                for (String type : split = TYPE_SEPARATOR_PATTERN.split(typeNames)) {
                    String typeName;
                    boolean isIntersectionType;
                    if (sb.length() > 0) {
                        sb.append("|");
                    }
                    if (isIntersectionType = (typeName = type.replace("(", "").replace(")", "")).contains("&")) {
                        sb.append("(").append(VariousUtils.qualifyUnionOrIntersectionTypeNames(typeName, offset, inScope)).append(")");
                        continue;
                    }
                    sb.append(VariousUtils.qualifyUnionOrIntersectionTypeNames(typeName, offset, inScope));
                }
            } else {
                sb.append(VariousUtils.qualifyUnionOrIntersectionTypeNames(typeNames, offset, inScope));
            }
        }
        return sb.toString();
    }

    private static String qualifyUnionOrIntersectionTypeNames(String typeNames, int offset, Scope inScope) {
        StringBuilder retval = new StringBuilder();
        if (typeNames != null && !typeNames.matches(SPACES_AND_TYPE_DELIMITERS)) {
            String[] types;
            boolean isIntersection = typeNames.contains("&");
            for (String typeName : types = isIntersection ? TYPE_SEPARATOR_INTERSECTION_PATTERN.split(typeNames) : TYPE_SEPARATOR_PATTERN.split(typeNames)) {
                String typeRawPart = typeName;
                if (CodeUtils.isNullableType(typeRawPart)) {
                    retval.append("?");
                    typeRawPart = typeRawPart.substring(1);
                }
                String typeArrayPart = "";
                int indexOfArrayDelim = typeName.indexOf(91);
                if (indexOfArrayDelim != -1) {
                    typeRawPart = typeName.substring(0, indexOfArrayDelim);
                    typeArrayPart = typeName.substring(indexOfArrayDelim);
                }
                if ("$this".equals(typeName)) {
                    retval.append("\\this").append(Type.getTypeSeparator(isIntersection));
                    continue;
                }
                if (!typeRawPart.startsWith("\\") && !Type.isPrimitive(typeRawPart)) {
                    QualifiedName fullyQualifiedName = VariousUtils.getFullyQualifiedName(QualifiedName.create(typeRawPart), offset, inScope);
                    retval.append(fullyQualifiedName.toString().startsWith("\\") ? "" : "\\");
                    retval.append(fullyQualifiedName.toString()).append(typeArrayPart).append(Type.getTypeSeparator(isIntersection));
                    continue;
                }
                retval.append(typeRawPart).append(typeArrayPart).append(Type.getTypeSeparator(isIntersection));
            }
            assert (retval.length() - Type.getTypeSeparator(isIntersection).length() >= 0) : "retval:" + retval + "# typeNames:" + typeNames;
            retval = new StringBuilder(retval.toString().substring(0, retval.length() - Type.getTypeSeparator(isIntersection).length()));
        }
        return retval.toString();
    }

    public static boolean isSpecialClassName(String className) {
        return SPECIAL_CLASS_NAMES.contains(className.toLowerCase());
    }

    public static boolean isStaticClassName(String className) {
        return className != null && STATIC_CLASS_NAMES.contains(className.toLowerCase());
    }

    public static boolean isSemiType(String typeName) {
        return typeName != null && typeName.contains(PRE_OPERATION_TYPE_DELIMITER);
    }

    public static List<String> getAllTypeNames(String declaredTypes) {
        if (!StringUtils.hasText((String)declaredTypes)) {
            return Collections.emptyList();
        }
        ArrayList<String> typeNames = new ArrayList<String>();
        for (String typeName : CodeUtils.SPLIT_TYPES_PATTERN.split(declaredTypes.trim())) {
            if (typeName.isEmpty() || VariousUtils.isSemiType(typeName)) continue;
            typeNames.add(typeName);
        }
        return typeNames;
    }

    static {
        STATIC_CLASS_NAMES.add("self");
        STATIC_CLASS_NAMES.add("static");
        SPECIAL_CLASS_NAMES.add("parent");
        SPECIAL_CLASS_NAMES.addAll(STATIC_CLASS_NAMES);
        recursionDetection = new HashSet<String>();
        CTX_DELIMITERS = Arrays.asList(PHPTokenId.PHP_OPENTAG, PHPTokenId.PHP_SEMICOLON, PHPTokenId.PHP_CURLY_OPEN, PHPTokenId.PHP_CURLY_CLOSE, PHPTokenId.PHP_RETURN, PHPTokenId.PHP_OPERATOR, PHPTokenId.PHP_ECHO, PHPTokenId.PHP_EVAL, PHPTokenId.PHP_NEW, PHPTokenId.PHP_NOT, PHPTokenId.PHP_CASE, PHPTokenId.PHP_IF, PHPTokenId.PHP_ELSE, PHPTokenId.PHP_ELSEIF, PHPTokenId.PHP_PRINT, PHPTokenId.PHP_FOR, PHPTokenId.PHP_FOREACH, PHPTokenId.PHP_WHILE, PHPTokenId.PHPDOC_COMMENT_END, PHPTokenId.PHP_COMMENT_END, PHPTokenId.PHP_LINE_COMMENT, PHPTokenId.PHP_CONSTANT_ENCAPSED_STRING, PHPTokenId.PHP_ENCAPSED_AND_WHITESPACE, PHPTokenId.PHPDOC_COMMENT_START, PHPTokenId.PHP_COMMENT_START, PHPTokenId.PHPDOC_COMMENT, PHPTokenId.PHP_COMMENT, PHPTokenId.PHP_LINE_COMMENT);
    }

    public static enum Kind {
        CONSTRUCTOR,
        FUNCTION,
        METHOD,
        STATIC_METHOD,
        FIELD,
        STATIC_FIELD,
        VAR;


        public String toString() {
            return switch (this) {
                case CONSTRUCTOR -> VariousUtils.CONSTRUCTOR_TYPE_PREFIX;
                case FUNCTION -> VariousUtils.FUNCTION_TYPE_PREFIX;
                case METHOD -> VariousUtils.METHOD_TYPE_PREFIX;
                case STATIC_METHOD -> VariousUtils.STATIC_METHOD_TYPE_PREFIX;
                case FIELD -> VariousUtils.FIELD_TYPE_PREFIX;
                case STATIC_FIELD -> VariousUtils.STATIC_FIELD_TYPE_PREFIX;
                case VAR -> VariousUtils.VAR_TYPE_PREFIX;
                default -> super.toString();
            };
        }
    }

    public static enum State {
        START,
        METHOD,
        INVALID,
        VARBASE,
        DOLAR,
        PARAMS,
        ARRAYREFERENCE,
        REFERENCE,
        STATIC_REFERENCE,
        FUNCTION,
        FIELD,
        VARIABLE,
        ARRAY_FIELD,
        ARRAY_VARIABLE,
        CLASSNAME,
        STOP,
        IDX;

    }

    private static class CloneExpressionInfo {
        private int endOffset = -1;
        private State reference = null;

        private CloneExpressionInfo() {
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public void setEndOffset(int endOffset) {
            this.endOffset = endOffset;
        }

        public State getReference() {
            return this.reference;
        }

        public void setReference(State reference) {
            this.reference = reference;
        }
    }
}

