/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class InstanceShapeConfig
extends ExplicitlySetBmcModel {
    @JsonProperty(value="ocpus")
    private final Float ocpus;
    @JsonProperty(value="memoryInGBs")
    private final Float memoryInGBs;
    @JsonProperty(value="baselineOcpuUtilization")
    private final BaselineOcpuUtilization baselineOcpuUtilization;
    @JsonProperty(value="processorDescription")
    private final String processorDescription;
    @JsonProperty(value="networkingBandwidthInGbps")
    private final Float networkingBandwidthInGbps;
    @JsonProperty(value="maxVnicAttachments")
    private final Integer maxVnicAttachments;
    @JsonProperty(value="gpus")
    private final Integer gpus;
    @JsonProperty(value="gpuDescription")
    private final String gpuDescription;
    @JsonProperty(value="localDisks")
    private final Integer localDisks;
    @JsonProperty(value="localDisksTotalSizeInGBs")
    private final Float localDisksTotalSizeInGBs;
    @JsonProperty(value="localDiskDescription")
    private final String localDiskDescription;
    @JsonProperty(value="vcpus")
    private final Integer vcpus;

    @Deprecated
    @ConstructorProperties(value={"ocpus", "memoryInGBs", "baselineOcpuUtilization", "processorDescription", "networkingBandwidthInGbps", "maxVnicAttachments", "gpus", "gpuDescription", "localDisks", "localDisksTotalSizeInGBs", "localDiskDescription", "vcpus"})
    public InstanceShapeConfig(Float ocpus, Float memoryInGBs, BaselineOcpuUtilization baselineOcpuUtilization, String processorDescription, Float networkingBandwidthInGbps, Integer maxVnicAttachments, Integer gpus, String gpuDescription, Integer localDisks, Float localDisksTotalSizeInGBs, String localDiskDescription, Integer vcpus) {
        this.ocpus = ocpus;
        this.memoryInGBs = memoryInGBs;
        this.baselineOcpuUtilization = baselineOcpuUtilization;
        this.processorDescription = processorDescription;
        this.networkingBandwidthInGbps = networkingBandwidthInGbps;
        this.maxVnicAttachments = maxVnicAttachments;
        this.gpus = gpus;
        this.gpuDescription = gpuDescription;
        this.localDisks = localDisks;
        this.localDisksTotalSizeInGBs = localDisksTotalSizeInGBs;
        this.localDiskDescription = localDiskDescription;
        this.vcpus = vcpus;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Float getOcpus() {
        return this.ocpus;
    }

    public Float getMemoryInGBs() {
        return this.memoryInGBs;
    }

    public BaselineOcpuUtilization getBaselineOcpuUtilization() {
        return this.baselineOcpuUtilization;
    }

    public String getProcessorDescription() {
        return this.processorDescription;
    }

    public Float getNetworkingBandwidthInGbps() {
        return this.networkingBandwidthInGbps;
    }

    public Integer getMaxVnicAttachments() {
        return this.maxVnicAttachments;
    }

    public Integer getGpus() {
        return this.gpus;
    }

    public String getGpuDescription() {
        return this.gpuDescription;
    }

    public Integer getLocalDisks() {
        return this.localDisks;
    }

    public Float getLocalDisksTotalSizeInGBs() {
        return this.localDisksTotalSizeInGBs;
    }

    public String getLocalDiskDescription() {
        return this.localDiskDescription;
    }

    public Integer getVcpus() {
        return this.vcpus;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("InstanceShapeConfig(");
        sb.append("super=").append(super.toString());
        sb.append("ocpus=").append(String.valueOf(this.ocpus));
        sb.append(", memoryInGBs=").append(String.valueOf(this.memoryInGBs));
        sb.append(", baselineOcpuUtilization=").append(String.valueOf((Object)this.baselineOcpuUtilization));
        sb.append(", processorDescription=").append(String.valueOf(this.processorDescription));
        sb.append(", networkingBandwidthInGbps=").append(String.valueOf(this.networkingBandwidthInGbps));
        sb.append(", maxVnicAttachments=").append(String.valueOf(this.maxVnicAttachments));
        sb.append(", gpus=").append(String.valueOf(this.gpus));
        sb.append(", gpuDescription=").append(String.valueOf(this.gpuDescription));
        sb.append(", localDisks=").append(String.valueOf(this.localDisks));
        sb.append(", localDisksTotalSizeInGBs=").append(String.valueOf(this.localDisksTotalSizeInGBs));
        sb.append(", localDiskDescription=").append(String.valueOf(this.localDiskDescription));
        sb.append(", vcpus=").append(String.valueOf(this.vcpus));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InstanceShapeConfig)) {
            return false;
        }
        InstanceShapeConfig other = (InstanceShapeConfig)((Object)o);
        return Objects.equals(this.ocpus, other.ocpus) && Objects.equals(this.memoryInGBs, other.memoryInGBs) && Objects.equals((Object)this.baselineOcpuUtilization, (Object)other.baselineOcpuUtilization) && Objects.equals(this.processorDescription, other.processorDescription) && Objects.equals(this.networkingBandwidthInGbps, other.networkingBandwidthInGbps) && Objects.equals(this.maxVnicAttachments, other.maxVnicAttachments) && Objects.equals(this.gpus, other.gpus) && Objects.equals(this.gpuDescription, other.gpuDescription) && Objects.equals(this.localDisks, other.localDisks) && Objects.equals(this.localDisksTotalSizeInGBs, other.localDisksTotalSizeInGBs) && Objects.equals(this.localDiskDescription, other.localDiskDescription) && Objects.equals(this.vcpus, other.vcpus) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.ocpus == null ? 43 : this.ocpus.hashCode());
        result = result * 59 + (this.memoryInGBs == null ? 43 : this.memoryInGBs.hashCode());
        result = result * 59 + (this.baselineOcpuUtilization == null ? 43 : this.baselineOcpuUtilization.hashCode());
        result = result * 59 + (this.processorDescription == null ? 43 : this.processorDescription.hashCode());
        result = result * 59 + (this.networkingBandwidthInGbps == null ? 43 : this.networkingBandwidthInGbps.hashCode());
        result = result * 59 + (this.maxVnicAttachments == null ? 43 : this.maxVnicAttachments.hashCode());
        result = result * 59 + (this.gpus == null ? 43 : this.gpus.hashCode());
        result = result * 59 + (this.gpuDescription == null ? 43 : this.gpuDescription.hashCode());
        result = result * 59 + (this.localDisks == null ? 43 : this.localDisks.hashCode());
        result = result * 59 + (this.localDisksTotalSizeInGBs == null ? 43 : this.localDisksTotalSizeInGBs.hashCode());
        result = result * 59 + (this.localDiskDescription == null ? 43 : this.localDiskDescription.hashCode());
        result = result * 59 + (this.vcpus == null ? 43 : this.vcpus.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum BaselineOcpuUtilization implements BmcEnum
    {
        Baseline18("BASELINE_1_8"),
        Baseline12("BASELINE_1_2"),
        Baseline11("BASELINE_1_1"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, BaselineOcpuUtilization> map;

        private BaselineOcpuUtilization(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static BaselineOcpuUtilization create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'BaselineOcpuUtilization', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(BaselineOcpuUtilization.class);
            map = new HashMap<String, BaselineOcpuUtilization>();
            for (BaselineOcpuUtilization v : BaselineOcpuUtilization.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="ocpus")
        private Float ocpus;
        @JsonProperty(value="memoryInGBs")
        private Float memoryInGBs;
        @JsonProperty(value="baselineOcpuUtilization")
        private BaselineOcpuUtilization baselineOcpuUtilization;
        @JsonProperty(value="processorDescription")
        private String processorDescription;
        @JsonProperty(value="networkingBandwidthInGbps")
        private Float networkingBandwidthInGbps;
        @JsonProperty(value="maxVnicAttachments")
        private Integer maxVnicAttachments;
        @JsonProperty(value="gpus")
        private Integer gpus;
        @JsonProperty(value="gpuDescription")
        private String gpuDescription;
        @JsonProperty(value="localDisks")
        private Integer localDisks;
        @JsonProperty(value="localDisksTotalSizeInGBs")
        private Float localDisksTotalSizeInGBs;
        @JsonProperty(value="localDiskDescription")
        private String localDiskDescription;
        @JsonProperty(value="vcpus")
        private Integer vcpus;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder ocpus(Float ocpus) {
            this.ocpus = ocpus;
            this.__explicitlySet__.add("ocpus");
            return this;
        }

        public Builder memoryInGBs(Float memoryInGBs) {
            this.memoryInGBs = memoryInGBs;
            this.__explicitlySet__.add("memoryInGBs");
            return this;
        }

        public Builder baselineOcpuUtilization(BaselineOcpuUtilization baselineOcpuUtilization) {
            this.baselineOcpuUtilization = baselineOcpuUtilization;
            this.__explicitlySet__.add("baselineOcpuUtilization");
            return this;
        }

        public Builder processorDescription(String processorDescription) {
            this.processorDescription = processorDescription;
            this.__explicitlySet__.add("processorDescription");
            return this;
        }

        public Builder networkingBandwidthInGbps(Float networkingBandwidthInGbps) {
            this.networkingBandwidthInGbps = networkingBandwidthInGbps;
            this.__explicitlySet__.add("networkingBandwidthInGbps");
            return this;
        }

        public Builder maxVnicAttachments(Integer maxVnicAttachments) {
            this.maxVnicAttachments = maxVnicAttachments;
            this.__explicitlySet__.add("maxVnicAttachments");
            return this;
        }

        public Builder gpus(Integer gpus) {
            this.gpus = gpus;
            this.__explicitlySet__.add("gpus");
            return this;
        }

        public Builder gpuDescription(String gpuDescription) {
            this.gpuDescription = gpuDescription;
            this.__explicitlySet__.add("gpuDescription");
            return this;
        }

        public Builder localDisks(Integer localDisks) {
            this.localDisks = localDisks;
            this.__explicitlySet__.add("localDisks");
            return this;
        }

        public Builder localDisksTotalSizeInGBs(Float localDisksTotalSizeInGBs) {
            this.localDisksTotalSizeInGBs = localDisksTotalSizeInGBs;
            this.__explicitlySet__.add("localDisksTotalSizeInGBs");
            return this;
        }

        public Builder localDiskDescription(String localDiskDescription) {
            this.localDiskDescription = localDiskDescription;
            this.__explicitlySet__.add("localDiskDescription");
            return this;
        }

        public Builder vcpus(Integer vcpus) {
            this.vcpus = vcpus;
            this.__explicitlySet__.add("vcpus");
            return this;
        }

        public InstanceShapeConfig build() {
            InstanceShapeConfig model = new InstanceShapeConfig(this.ocpus, this.memoryInGBs, this.baselineOcpuUtilization, this.processorDescription, this.networkingBandwidthInGbps, this.maxVnicAttachments, this.gpus, this.gpuDescription, this.localDisks, this.localDisksTotalSizeInGBs, this.localDiskDescription, this.vcpus);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(InstanceShapeConfig model) {
            if (model.wasPropertyExplicitlySet("ocpus")) {
                this.ocpus(model.getOcpus());
            }
            if (model.wasPropertyExplicitlySet("memoryInGBs")) {
                this.memoryInGBs(model.getMemoryInGBs());
            }
            if (model.wasPropertyExplicitlySet("baselineOcpuUtilization")) {
                this.baselineOcpuUtilization(model.getBaselineOcpuUtilization());
            }
            if (model.wasPropertyExplicitlySet("processorDescription")) {
                this.processorDescription(model.getProcessorDescription());
            }
            if (model.wasPropertyExplicitlySet("networkingBandwidthInGbps")) {
                this.networkingBandwidthInGbps(model.getNetworkingBandwidthInGbps());
            }
            if (model.wasPropertyExplicitlySet("maxVnicAttachments")) {
                this.maxVnicAttachments(model.getMaxVnicAttachments());
            }
            if (model.wasPropertyExplicitlySet("gpus")) {
                this.gpus(model.getGpus());
            }
            if (model.wasPropertyExplicitlySet("gpuDescription")) {
                this.gpuDescription(model.getGpuDescription());
            }
            if (model.wasPropertyExplicitlySet("localDisks")) {
                this.localDisks(model.getLocalDisks());
            }
            if (model.wasPropertyExplicitlySet("localDisksTotalSizeInGBs")) {
                this.localDisksTotalSizeInGBs(model.getLocalDisksTotalSizeInGBs());
            }
            if (model.wasPropertyExplicitlySet("localDiskDescription")) {
                this.localDiskDescription(model.getLocalDiskDescription());
            }
            if (model.wasPropertyExplicitlySet("vcpus")) {
                this.vcpus(model.getVcpus());
            }
            return this;
        }
    }
}

