/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerengine.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateClusterKubeconfigContentDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="tokenVersion")
    private final String tokenVersion;
    @JsonProperty(value="expiration")
    private final Integer expiration;
    @JsonProperty(value="endpoint")
    private final Endpoint endpoint;

    @Deprecated
    @ConstructorProperties(value={"tokenVersion", "expiration", "endpoint"})
    public CreateClusterKubeconfigContentDetails(String tokenVersion, Integer expiration, Endpoint endpoint) {
        this.tokenVersion = tokenVersion;
        this.expiration = expiration;
        this.endpoint = endpoint;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getTokenVersion() {
        return this.tokenVersion;
    }

    public Integer getExpiration() {
        return this.expiration;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateClusterKubeconfigContentDetails(");
        sb.append("super=").append(super.toString());
        sb.append("tokenVersion=").append(String.valueOf(this.tokenVersion));
        sb.append(", expiration=").append(String.valueOf(this.expiration));
        sb.append(", endpoint=").append(String.valueOf((Object)this.endpoint));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateClusterKubeconfigContentDetails)) {
            return false;
        }
        CreateClusterKubeconfigContentDetails other = (CreateClusterKubeconfigContentDetails)((Object)o);
        return Objects.equals(this.tokenVersion, other.tokenVersion) && Objects.equals(this.expiration, other.expiration) && Objects.equals((Object)this.endpoint, (Object)other.endpoint) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.tokenVersion == null ? 43 : this.tokenVersion.hashCode());
        result = result * 59 + (this.expiration == null ? 43 : this.expiration.hashCode());
        result = result * 59 + (this.endpoint == null ? 43 : this.endpoint.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Endpoint implements BmcEnum
    {
        LegacyKubernetes("LEGACY_KUBERNETES"),
        PublicEndpoint("PUBLIC_ENDPOINT"),
        PrivateEndpoint("PRIVATE_ENDPOINT"),
        VcnHostname("VCN_HOSTNAME");

        private final String value;
        private static Map<String, Endpoint> map;

        private Endpoint(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Endpoint create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Endpoint: " + key);
        }

        static {
            map = new HashMap<String, Endpoint>();
            for (Endpoint v : Endpoint.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="tokenVersion")
        private String tokenVersion;
        @JsonProperty(value="expiration")
        private Integer expiration;
        @JsonProperty(value="endpoint")
        private Endpoint endpoint;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder tokenVersion(String tokenVersion) {
            this.tokenVersion = tokenVersion;
            this.__explicitlySet__.add("tokenVersion");
            return this;
        }

        public Builder expiration(Integer expiration) {
            this.expiration = expiration;
            this.__explicitlySet__.add("expiration");
            return this;
        }

        public Builder endpoint(Endpoint endpoint) {
            this.endpoint = endpoint;
            this.__explicitlySet__.add("endpoint");
            return this;
        }

        public CreateClusterKubeconfigContentDetails build() {
            CreateClusterKubeconfigContentDetails model = new CreateClusterKubeconfigContentDetails(this.tokenVersion, this.expiration, this.endpoint);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateClusterKubeconfigContentDetails model) {
            if (model.wasPropertyExplicitlySet("tokenVersion")) {
                this.tokenVersion(model.getTokenVersion());
            }
            if (model.wasPropertyExplicitlySet("expiration")) {
                this.expiration(model.getExpiration());
            }
            if (model.wasPropertyExplicitlySet("endpoint")) {
                this.endpoint(model.getEndpoint());
            }
            return this;
        }
    }
}

