/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.prep.ui.customizer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.css.prep.CssPreprocessorType;
import org.netbeans.modules.css.prep.options.CssPrepOptions;
import org.netbeans.modules.css.prep.preferences.CssPreprocessorPreferences;
import org.netbeans.modules.css.prep.ui.customizer.CustomizerOptionsPanel;
import org.netbeans.modules.css.prep.ui.customizer.OptionsPanel;
import org.netbeans.modules.css.prep.util.BaseCssPreprocessor;
import org.netbeans.modules.css.prep.util.CssPreprocessorUtils;
import org.netbeans.modules.css.prep.util.Warnings;
import org.netbeans.modules.web.common.api.ValidationResult;
import org.netbeans.modules.web.common.ui.spi.CssPreprocessorUIImplementation;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.Pair;

public final class CustomizerImpl
implements CssPreprocessorUIImplementation.Customizer,
PropertyChangeListener {
    private final BaseCssPreprocessor cssPreprocessor;
    private final Project project;
    private final CssPreprocessorType type;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private CustomizerOptionsPanel customizerPanel = null;
    private volatile OptionsPanel optionsPanel = null;

    public CustomizerImpl(BaseCssPreprocessor cssPreprocessor, Project project, CssPreprocessorType type) {
        assert (cssPreprocessor != null);
        assert (project != null);
        assert (type != null);
        this.cssPreprocessor = cssPreprocessor;
        this.project = project;
        this.type = type;
    }

    public String getDisplayName() {
        return this.type.getDisplayName();
    }

    public void addChangeListener(ChangeListener listener) {
        this.getOptionsPanel().addChangeListener(listener);
        this.changeSupport.addChangeListener(listener);
        CssPrepOptions.getInstance().addPropertyChangeListener(this);
    }

    public void removeChangeListener(ChangeListener listener) {
        CssPrepOptions.getInstance().removePropertyChangeListener(this);
        this.changeSupport.removeChangeListener(listener);
        this.getOptionsPanel().removeChangeListener(listener);
    }

    public JComponent getComponent() {
        if (this.customizerPanel == null) {
            this.customizerPanel = new CustomizerOptionsPanel(this.getOptionsPanel());
        }
        return this.customizerPanel;
    }

    public synchronized OptionsPanel getOptionsPanel() {
        if (this.optionsPanel == null) {
            CssPreprocessorPreferences preferences = this.type.getPreferences();
            this.optionsPanel = new OptionsPanel(this.type, this.project, preferences.isEnabled(this.project), preferences.getMappings(this.project), preferences.getCompilerOptions(this.project));
        }
        assert (this.optionsPanel != null);
        return this.optionsPanel;
    }

    public HelpCtx getHelp() {
        return new HelpCtx("org.netbeans.modules.css.prep.ui.customizer.CustomizerImpl." + this.type.name());
    }

    public boolean isValid() {
        return !this.getValidationResult().hasErrors();
    }

    public String getErrorMessage() {
        return this.getValidationResult().getFirstErrorMessage();
    }

    public String getWarningMessage() {
        return this.getValidationResult().getFirstWarningMessage();
    }

    public void save() throws IOException {
        Warnings.resetWarning(this.type);
        boolean fire = false;
        CssPreprocessorPreferences preferences = this.type.getPreferences();
        if (this.getOptionsPanel().isConfigured()) {
            preferences.setConfigured(this.project, true);
        }
        boolean originalEnabled = preferences.isEnabled(this.project);
        boolean enabled = this.getOptionsPanel().isCompilationEnabled();
        preferences.setEnabled(this.project, enabled);
        if (enabled != originalEnabled) {
            fire = true;
        }
        List<Pair<String, String>> originalMappings = preferences.getMappings(this.project);
        ArrayList<Pair<String, String>> mappings = new ArrayList<Pair<String, String>>(this.getOptionsPanel().getMappings());
        preferences.setMappings(this.project, mappings);
        mappings.removeAll(originalMappings);
        if (!fire && !mappings.isEmpty()) {
            fire = true;
        }
        String originalCompilerOptions = preferences.getCompilerOptions(this.project);
        String compilerOptions = this.getOptionsPanel().getCompilerOptions();
        preferences.setCompilerOptions(this.project, compilerOptions);
        if (!fire && !originalCompilerOptions.equals(compilerOptions)) {
            fire = true;
        }
        if (fire) {
            this.cssPreprocessor.fireCustomizerChanged(this.project);
        }
    }

    private ValidationResult getValidationResult() {
        boolean compilationEnabled = this.getOptionsPanel().isCompilationEnabled();
        return this.type.getPreferencesValidator().validateMappings(CssPreprocessorUtils.getWebRoot(this.project), compilationEnabled, this.getOptionsPanel().getMappings()).validateExecutable(compilationEnabled).getResult();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.type.getExecutablePathPropertyName().equals(evt.getPropertyName())) {
            this.changeSupport.fireChange();
        }
    }
}

