/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetCpeDeviceShapeRequest
extends BmcRequest<Void> {
    private String cpeDeviceShapeId;
    private String opcRequestId;

    public String getCpeDeviceShapeId() {
        return this.cpeDeviceShapeId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().cpeDeviceShapeId(this.cpeDeviceShapeId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",cpeDeviceShapeId=").append(String.valueOf(this.cpeDeviceShapeId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetCpeDeviceShapeRequest)) {
            return false;
        }
        GetCpeDeviceShapeRequest other = (GetCpeDeviceShapeRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.cpeDeviceShapeId, other.cpeDeviceShapeId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.cpeDeviceShapeId == null ? 43 : this.cpeDeviceShapeId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetCpeDeviceShapeRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String cpeDeviceShapeId = null;
        private String opcRequestId = null;

        public Builder cpeDeviceShapeId(String cpeDeviceShapeId) {
            this.cpeDeviceShapeId = cpeDeviceShapeId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetCpeDeviceShapeRequest o) {
            this.cpeDeviceShapeId(o.getCpeDeviceShapeId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetCpeDeviceShapeRequest build() {
            GetCpeDeviceShapeRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetCpeDeviceShapeRequest buildWithoutInvocationCallback() {
            GetCpeDeviceShapeRequest request = new GetCpeDeviceShapeRequest();
            request.cpeDeviceShapeId = this.cpeDeviceShapeId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

