/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.builder;

import com.sun.source.tree.Tree;
import com.sun.tools.javac.util.Context;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.api.java.source.Comment;
import org.netbeans.modules.java.source.builder.CommentSetImpl;
import org.netbeans.modules.java.source.query.CommentHandler;
import org.netbeans.modules.java.source.query.CommentSet;

public class CommentHandlerService
implements CommentHandler {
    private static final Context.Key<CommentHandlerService> commentHandlerKey = new Context.Key();
    private final Map<Tree, CommentSetImpl> map = new HashMap<Tree, CommentSetImpl>();
    private boolean frozen;

    public static CommentHandlerService instance(Context context) {
        CommentHandlerService instance = context.get(commentHandlerKey);
        if (instance == null) {
            instance = new CommentHandlerService(context);
            CommentHandlerService.setCommentHandler(context, instance);
        }
        return instance;
    }

    public static void setCommentHandler(Context context, CommentHandlerService instance) {
        assert (context.get(commentHandlerKey) == null);
        context.put(commentHandlerKey, instance);
    }

    private CommentHandlerService(Context context) {
    }

    Map<Tree, CommentSetImpl> getCommentMap() {
        HashMap<Tree, CommentSetImpl> m = new HashMap<Tree, CommentSetImpl>(this.map);
        Iterator it = m.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            if (((CommentSetImpl)e.getValue()).hasComments()) continue;
            it.remove();
        }
        return m;
    }

    public void freeze() {
        this.frozen = true;
        for (CommentSetImpl impl : this.map.values()) {
            impl.commentsFrozen(true);
        }
    }

    public void unFreeze() {
        this.frozen = false;
        for (CommentSetImpl impl : this.map.values()) {
            impl.commentsFrozen(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasComments(Tree tree) {
        Map<Tree, CommentSetImpl> map = this.map;
        synchronized (map) {
            return this.map.containsKey(tree);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommentSetImpl getComments(Tree tree) {
        Map<Tree, CommentSetImpl> map = this.map;
        synchronized (map) {
            CommentSetImpl cs = this.map.get(tree);
            if (cs == null) {
                cs = new CommentSetImpl();
                if (this.frozen) {
                    cs.commentsFrozen(this.frozen);
                }
                this.map.put(tree, cs);
            }
            return cs;
        }
    }

    @Override
    public void copyComments(Tree fromTree, Tree toTree) {
        this.copyComments(fromTree, toTree, null, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyComments(Tree fromTree, Tree toTree, CommentSet.RelativePosition copyToPos, Collection<Comment> copied, boolean nonEmpty) {
        if (fromTree == toTree) {
            return;
        }
        Map<Tree, CommentSetImpl> map = this.map;
        synchronized (map) {
            CommentSetImpl from = this.map.get(fromTree);
            if (from != null) {
                CommentSetImpl to = this.map.get(toTree);
                if (to == null) {
                    to = new CommentSetImpl();
                    this.map.put(toTree, to);
                    if (this.frozen) {
                        to.commentsFrozen(true);
                    }
                }
                for (CommentSet.RelativePosition pos : CommentSet.RelativePosition.values()) {
                    int index = 0;
                    int last = -1;
                    int first = 0;
                    List<Comment> l = from.getComments(pos);
                    if (nonEmpty) {
                        boolean nonWs = false;
                        for (Comment c : l) {
                            if (c.style() != Comment.Style.WHITESPACE) {
                                last = index;
                                if (!nonWs) {
                                    first = index;
                                    nonWs = true;
                                }
                            }
                            ++index;
                        }
                        if (!nonWs) continue;
                    }
                    if (last == -1) {
                        last = l.size() - 1;
                    }
                    CopyEntry en = new CopyEntry();
                    for (index = first; index <= last; ++index) {
                        Comment c = l.get(index);
                        if (copied != null && !copied.add(c)) continue;
                        to.addComment(copyToPos == null ? pos : copyToPos, c);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addComment(Tree tree, Comment c) {
        Map<Tree, CommentSetImpl> map = this.map;
        synchronized (map) {
            CommentSetImpl set = this.map.get(tree);
            if (set == null) {
                set = new CommentSetImpl();
                if (this.frozen) {
                    set.commentsFrozen(this.frozen);
                }
                this.map.put(tree, set);
            }
            set.addPrecedingComment(c);
        }
    }

    public String toString() {
        return "CommentHandlerService[map=" + this.map + "]";
    }

    private static class CopyEntry {
        private Tree target;
        private CommentSet.RelativePosition pos;
        private Collection<Comment> comments = new ArrayList<Comment>();

        private CopyEntry() {
        }
    }
}

