/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharConversionException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.apisupport.project.ui.ActionFilterNode;
import org.netbeans.modules.apisupport.project.ui.LibrariesSourceGroup;
import org.netbeans.modules.apisupport.project.ui.ShowJavadocAction;
import org.netbeans.modules.apisupport.project.ui.customizer.ModuleProperties;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.xml.XMLUtil;

final class PlatformNode
extends AbstractNode
implements ChangeListener {
    private static final String PLATFORM_ICON = "org/netbeans/modules/apisupport/project/ui/resources/platform.gif";
    private static final String ARCHIVE_ICON = "org/netbeans/modules/apisupport/project/ui/resources/jar.gif";
    private final PlatformProvider pp;
    private static final RequestProcessor RP = new RequestProcessor(PlatformNode.class);

    private PlatformNode(Project project, PlatformProvider pp) {
        super((Children)new PlatformContentChildren(), Lookups.fixed((Object[])new Object[]{new JavadocProvider(pp), project}));
        this.pp = pp;
        this.pp.addChangeListener(this);
        this.setIconBaseWithExtension(PLATFORM_ICON);
    }

    public String getName() {
        return this.getDisplayName();
    }

    public String getDisplayName() {
        String platformId;
        JavaPlatform plat = this.pp.getPlatform();
        String name = plat != null ? plat.getDisplayName() : ((platformId = this.pp.getPlatformID()) == null ? NbBundle.getMessage(PlatformNode.class, (String)"TXT_BrokenPlatform") : MessageFormat.format(NbBundle.getMessage(PlatformNode.class, (String)"FMT_BrokenPlatform"), platformId));
        return name;
    }

    public String getHtmlDisplayName() {
        if (this.pp.getPlatform() == null) {
            String displayName = this.getDisplayName();
            try {
                displayName = XMLUtil.toElementContent((String)displayName);
            }
            catch (CharConversionException ex) {
                return null;
            }
            return "<font color=\"#A40000\">" + displayName + "</font>";
        }
        return null;
    }

    public boolean canCopy() {
        return false;
    }

    public Action[] getActions(boolean context) {
        return new Action[]{SystemAction.get(ShowJavadocAction.class)};
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        RP.post(new Runnable(){

            @Override
            public void run() {
                PlatformNode.this.fireNameChange(null, null);
                PlatformNode.this.fireDisplayNameChange(null, null);
                ((PlatformContentChildren)PlatformNode.this.getChildren()).addNotify();
            }
        });
    }

    static PlatformNode create(Project project, PropertyEvaluator eval, String platformPropName) {
        PlatformProvider pp = new PlatformProvider(eval, platformPropName);
        return new PlatformNode(project, pp);
    }

    private static class PlatformContentChildren
    extends Children.Keys<SourceGroup> {
        PlatformContentChildren() {
        }

        protected void addNotify() {
            this.setKeys(this.getKeys());
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptySet());
        }

        protected Node[] createNodes(SourceGroup sg) {
            return new Node[]{ActionFilterNode.create(PackageView.createPackageView((SourceGroup)sg))};
        }

        private List<SourceGroup> getKeys() {
            JavaPlatform platform = ((PlatformNode)this.getNode()).pp.getPlatform();
            if (platform == null) {
                return Collections.emptyList();
            }
            FileObject[] roots = platform.getBootstrapLibraries().getRoots();
            ArrayList<SourceGroup> result = new ArrayList<SourceGroup>(roots.length);
            for (int i = 0; i < roots.length; ++i) {
                ImageIcon icon;
                FileObject file;
                if ("jar".equals(roots[i].toURL().getProtocol())) {
                    file = FileUtil.getArchiveFile((FileObject)roots[i]);
                    icon = ImageUtilities.loadImageIcon((String)PlatformNode.ARCHIVE_ICON, (boolean)false);
                } else {
                    file = roots[i];
                    icon = null;
                }
                if (!file.isValid()) continue;
                result.add(new LibrariesSourceGroup(roots[i], file.getNameExt(), icon, icon));
            }
            return result;
        }
    }

    private static class JavadocProvider
    implements ShowJavadocAction.JavadocProvider {
        PlatformProvider platformProvider;

        private JavadocProvider(PlatformProvider platformProvider) {
            this.platformProvider = platformProvider;
        }

        @Override
        public boolean hasJavadoc() {
            JavaPlatform platform = this.platformProvider.getPlatform();
            if (platform == null) {
                return false;
            }
            URL[] javadocRoots = JavadocProvider.getJavadocRoots(platform);
            return javadocRoots.length > 0;
        }

        @Override
        public void showJavadoc() {
            JavaPlatform platform = this.platformProvider.getPlatform();
            if (platform != null) {
                URL[] javadocRoots = JavadocProvider.getJavadocRoots(platform);
                URL pageURL = ShowJavadocAction.findJavadoc("overview-summary.html", javadocRoots);
                if (pageURL == null) {
                    pageURL = ShowJavadocAction.findJavadoc("index.html", javadocRoots);
                }
                ShowJavadocAction.showJavaDoc(pageURL, platform.getDisplayName());
            }
        }

        private static URL[] getJavadocRoots(JavaPlatform platform) {
            HashSet<URL> result = new HashSet<URL>();
            List l = platform.getBootstrapLibraries().entries();
            for (ClassPath.Entry e : l) {
                result.addAll(Arrays.asList(JavadocForBinaryQuery.findJavadoc((URL)e.getURL()).getRoots()));
            }
            return result.toArray(new URL[0]);
        }
    }

    private static class PlatformProvider
    implements PropertyChangeListener {
        private final PropertyEvaluator evaluator;
        private final String platformPropName;
        private JavaPlatform platformCache;
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);

        public PlatformProvider(PropertyEvaluator evaluator, String platformPropName) {
            this.evaluator = evaluator;
            this.platformPropName = platformPropName;
            this.evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)evaluator));
        }

        public String getPlatformID() {
            return this.evaluator.getProperty(this.platformPropName);
        }

        public JavaPlatform getPlatform() {
            if (this.platformCache == null) {
                String platformPropName = this.getPlatformID();
                this.platformCache = ModuleProperties.findJavaPlatformByLocation(platformPropName);
                if (this.platformCache != null && this.platformCache.getInstallFolders().size() == 0) {
                    this.platformCache = null;
                }
                if (ErrorManager.getDefault().isLoggable(1) && this.platformCache == null) {
                    StringBuilder message = new StringBuilder("RequestedPlatform: " + platformPropName + " not found.\nInstalled Platforms:\n");
                    JavaPlatform[] platforms = JavaPlatformManager.getDefault().getInstalledPlatforms();
                    for (int i = 0; i < platforms.length; ++i) {
                        message.append("Name: " + (String)platforms[i].getProperties().get("platform.ant.name") + " Broken: " + (platforms[i].getInstallFolders().size() == 0) + "\n");
                    }
                    ErrorManager.getDefault().log(1, message.toString());
                }
            }
            return this.platformCache;
        }

        public void addChangeListener(ChangeListener l) {
            this.changeSupport.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.changeSupport.removeChangeListener(l);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (this.platformPropName.equals(evt.getPropertyName())) {
                this.platformCache = null;
                this.changeSupport.fireChange();
            }
        }
    }
}

