/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.el;

import com.sun.el.parser.Node;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.el.ELException;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.web.el.ELElement;
import org.netbeans.modules.web.el.ELPreprocessor;
import org.openide.filesystems.FileObject;

public final class ELParserResult
extends ParserResult {
    private final List<ELElement> elements = new ArrayList<ELElement>();
    private final FileObject file;

    public ELParserResult(Snapshot snapshot) {
        super(snapshot);
        this.file = snapshot.getSource().getFileObject();
    }

    public ELParserResult(FileObject fo) {
        super(null);
        this.file = fo;
    }

    public ELElement addValidElement(Node node, ELPreprocessor expression, OffsetRange embeddedOffset) {
        ELElement element = ELElement.valid(node, expression, embeddedOffset, this.getSnapshot());
        this.add(element);
        return element;
    }

    public ELElement addErrorElement(ELException error, ELPreprocessor expression, OffsetRange embeddedOffset) {
        ELElement element = ELElement.error(error, expression, embeddedOffset, this.getSnapshot());
        this.add(element);
        return element;
    }

    public List<ELElement> getElements() {
        return Collections.unmodifiableList(this.elements);
    }

    public ELElement getElementAt(int offset) {
        for (ELElement each : this.elements) {
            if (!each.getOriginalOffset().containsInclusive(offset)) continue;
            return each;
        }
        return null;
    }

    public List<ELElement> getElementsTo(int offset) {
        ArrayList<ELElement> result = new ArrayList<ELElement>();
        for (ELElement each : this.elements) {
            if (each.getOriginalOffset().getStart() >= offset) continue;
            result.add(each);
        }
        return result;
    }

    private boolean add(ELElement element) {
        return this.elements.add(element);
    }

    public FileObject getFileObject() {
        return this.file;
    }

    public boolean hasElements() {
        return !this.elements.isEmpty();
    }

    public boolean isValid() {
        for (ELElement each : this.elements) {
            if (each.isValid()) continue;
            return false;
        }
        return true;
    }

    protected void invalidate() {
    }

    public String toString() {
        return "ELParserResult{fileObject=" + this.getFileObject() + "elements=" + this.elements + '}';
    }

    public List<? extends Error> getDiagnostics() {
        ArrayList<ELError> result = new ArrayList<ELError>();
        for (ELElement each : this.elements) {
            if (each.isValid()) continue;
            result.add(new ELError(each, this.file));
        }
        return result;
    }

    private static class ELError
    implements Error.Badging {
        private final ELElement errorElement;
        private final FileObject file;

        public ELError(ELElement errorElement, FileObject file) {
            this.errorElement = errorElement;
            this.file = file;
        }

        public String getDisplayName() {
            return this.errorElement.getError().getLocalizedMessage();
        }

        public String getDescription() {
            return this.errorElement.getError().getLocalizedMessage();
        }

        public String getKey() {
            return null;
        }

        public FileObject getFile() {
            return this.file;
        }

        public int getStartPosition() {
            return this.errorElement.getEmbeddedOffset().getStart();
        }

        public int getEndPosition() {
            return this.errorElement.getEmbeddedOffset().getEnd();
        }

        public boolean isLineError() {
            return false;
        }

        public Severity getSeverity() {
            return Severity.ERROR;
        }

        public Object[] getParameters() {
            return new Object[0];
        }

        public boolean showExplorerBadge() {
            return true;
        }
    }
}

