/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.notifications.center;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.notifications.Utils;
import org.openide.util.ImageUtilities;

public class SearchField
extends JPanel {
    private JLabel leftIcon;
    private JPanel panel;
    private SearchTextField txtSearch;
    private JSeparator separator;

    public SearchField() {
        this.initComponents();
    }

    private void initComponents() {
        this.panel = new JPanel();
        this.leftIcon = new JLabel();
        this.txtSearch = new SearchTextField();
        this.txtSearch.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (e.getSource() == SearchField.this.txtSearch) {
                    int n = SearchField.this.txtSearch.getText().length();
                    SearchField.this.txtSearch.select(n, n);
                }
            }
        });
        this.separator = new JSeparator();
        this.setLayout(new GridBagLayout());
        this.panel.setBackground(Utils.getTextBackground());
        this.panel.setBorder(BorderFactory.createLineBorder(Utils.getComboBorderColor()));
        this.panel.setLayout(new GridBagLayout());
        this.leftIcon.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/notifications/resources/find.png", (boolean)true));
        this.leftIcon.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 2, 1, 1);
        this.panel.add((Component)this.leftIcon, gridBagConstraints);
        this.txtSearch.setBorder(null);
        this.txtSearch.setMinimumSize(new Dimension(100, 18));
        this.txtSearch.setPreferredSize(new Dimension(150, 18));
        this.separator.setOrientation(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 3, 3);
        this.panel.add((Component)this.separator, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        this.panel.add((Component)this.txtSearch, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.panel, gridBagConstraints);
    }

    @Override
    public void requestFocus() {
        this.txtSearch.requestFocus();
    }

    public String getText() {
        return this.txtSearch.getText().trim();
    }

    public void setText(String text) {
        this.txtSearch.setText(text);
    }

    public boolean isEmpty() {
        return this.txtSearch.getText().trim().isEmpty();
    }

    public void clear() {
        this.txtSearch.setText("");
    }

    void setCaretPosition(int position) {
        this.txtSearch.setCaretPosition(position);
    }

    void processSearchKeyEvent(KeyEvent e) {
        this.txtSearch.processKeyEvent(e);
    }

    public void addDocumentListener(DocumentListener listener) {
        this.txtSearch.getDocument().addDocumentListener(listener);
    }

    public void removeDocumentListener(DocumentListener listener) {
        this.txtSearch.getDocument().removeDocumentListener(listener);
    }

    public void addSearchKeyListener(KeyListener listener) {
        this.txtSearch.addKeyListener(listener);
    }

    public void removeSearchKeyListener(KeyListener listener) {
        this.txtSearch.removeKeyListener(listener);
    }

    private static class SearchTextField
    extends JTextField {
        private SearchTextField() {
        }

        @Override
        protected void processKeyEvent(KeyEvent e) {
            super.processKeyEvent(e);
        }
    }
}

