/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.indexer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.spi.ResultImplementation;
import org.netbeans.modules.maven.indexer.spi.impl.Redo;
import org.netbeans.modules.project.spi.intern.ProjectIDEServices;

public class ResultImpl<T>
implements ResultImplementation<T> {
    private final List<RepositoryInfo> skipped = new ArrayList<RepositoryInfo>();
    private final List<T> results = new ArrayList<T>();
    private final Redo<T> redoAction;
    private int totalResults = 0;
    private int returnedResults = 0;

    public ResultImpl(Redo<T> redo) {
        this.redoAction = redo;
    }

    @Override
    public synchronized boolean isPartial() {
        return !this.skipped.isEmpty();
    }

    synchronized void addSkipped(RepositoryInfo info) {
        this.skipped.add(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForSkipped() {
        assert (!ProjectIDEServices.isEventDispatchThread());
        this.redoAction.run(this);
        ResultImpl resultImpl = this;
        synchronized (resultImpl) {
            this.skipped.clear();
        }
    }

    synchronized void setResults(Collection<T> newResults) {
        this.results.clear();
        this.results.addAll(newResults);
    }

    @Override
    public synchronized List<T> getResults() {
        return Collections.unmodifiableList(this.results);
    }

    synchronized void addSkipped(Collection<RepositoryInfo> infos) {
        this.skipped.addAll(infos);
    }

    synchronized List<RepositoryInfo> getSkipped() {
        return Collections.unmodifiableList(this.skipped);
    }

    @Override
    public int getTotalResultCount() {
        return this.totalResults;
    }

    void addTotalResultCount(int moreTotalResults) {
        this.totalResults += moreTotalResults;
    }

    @Override
    public int getReturnedResultCount() {
        return this.returnedResults;
    }

    void addReturnedResultCount(int moreReturnedResults) {
        this.returnedResults = moreReturnedResults + this.returnedResults;
    }
}

