/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.nodes;

import com.github.weisj.jsvg.attributes.UnitType;
import com.github.weisj.jsvg.attributes.paint.PaintParser;
import com.github.weisj.jsvg.geometry.size.Length;
import com.github.weisj.jsvg.geometry.size.Unit;
import com.github.weisj.jsvg.geometry.util.GeometryUtil;
import com.github.weisj.jsvg.nodes.Anchor;
import com.github.weisj.jsvg.nodes.ClipPath;
import com.github.weisj.jsvg.nodes.Image;
import com.github.weisj.jsvg.nodes.Marker;
import com.github.weisj.jsvg.nodes.Pattern;
import com.github.weisj.jsvg.nodes.SVGNode;
import com.github.weisj.jsvg.nodes.Style;
import com.github.weisj.jsvg.nodes.View;
import com.github.weisj.jsvg.nodes.container.CommonRenderableContainerNode;
import com.github.weisj.jsvg.nodes.filter.Filter;
import com.github.weisj.jsvg.nodes.prototype.Instantiator;
import com.github.weisj.jsvg.nodes.prototype.spec.Category;
import com.github.weisj.jsvg.nodes.prototype.spec.ElementCategories;
import com.github.weisj.jsvg.nodes.prototype.spec.PermittedContent;
import com.github.weisj.jsvg.nodes.text.Text;
import com.github.weisj.jsvg.parser.AttributeNode;
import com.github.weisj.jsvg.renderer.ElementBounds;
import com.github.weisj.jsvg.renderer.MaskedPaint;
import com.github.weisj.jsvg.renderer.Output;
import com.github.weisj.jsvg.renderer.RenderContext;
import com.github.weisj.jsvg.util.BlittableImage;
import com.github.weisj.jsvg.util.CachedSurfaceSupplier;
import com.github.weisj.jsvg.util.ImageUtil;
import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;

@ElementCategories(value={Category.Container})
@PermittedContent(categories={Category.Animation, Category.Descriptive, Category.Shape, Category.Structural, Category.Gradient}, anyOf={Anchor.class, ClipPath.class, Filter.class, Image.class, Marker.class, Mask.class, Pattern.class, Style.class, Text.class, View.class})
public final class Mask
extends CommonRenderableContainerNode
implements Instantiator {
    private static final boolean DEBUG = false;
    public static final String TAG = "mask";
    private final CachedSurfaceSupplier surfaceSupplier = new CachedSurfaceSupplier(ImageUtil::createLuminosityBuffer);
    private Length x;
    private Length y;
    private Length width;
    private Length height;
    private UnitType maskContentUnits;
    private UnitType maskUnits;

    @Override
    @NotNull
    public String tagName() {
        return TAG;
    }

    @Override
    public void build(@NotNull AttributeNode attributeNode) {
        super.build(attributeNode);
        this.maskContentUnits = attributeNode.getEnum("maskContentUnits", UnitType.UserSpaceOnUse);
        this.maskUnits = attributeNode.getEnum("maskUnits", UnitType.ObjectBoundingBox);
        this.x = attributeNode.getLength("x", Unit.PERCENTAGE.valueOf(-10.0f)).coercePercentageToCorrectUnit(this.maskUnits);
        this.y = attributeNode.getLength("y", Unit.PERCENTAGE.valueOf(-10.0f)).coercePercentageToCorrectUnit(this.maskUnits);
        this.width = attributeNode.getLength("width", Unit.PERCENTAGE.valueOf(120.0f)).coercePercentageToCorrectUnit(this.maskUnits);
        this.height = attributeNode.getLength("height", Unit.PERCENTAGE.valueOf(120.0f)).coercePercentageToCorrectUnit(this.maskUnits);
    }

    @NotNull
    public Paint createMaskPaint(@NotNull Output output, @NotNull RenderContext context, @NotNull ElementBounds elementBounds) {
        Rectangle2D.Double maskBounds = this.maskUnits.computeViewBounds(context.measureContext(), elementBounds.boundingBox(), this.x, this.y, this.width, this.height);
        boolean useCache = this.surfaceSupplier.useCache(output, context);
        BlittableImage blitImage = BlittableImage.create(this.surfaceSupplier.surfaceSupplier(useCache), context, output.clipBounds(), maskBounds.createIntersection(elementBounds.geometryBox()), elementBounds.boundingBox(), this.maskContentUnits);
        if (blitImage == null) {
            return PaintParser.DEFAULT_COLOR;
        }
        blitImage.clearBackground(Color.BLACK);
        blitImage.renderNode(output, this, this);
        Point2D offset = GeometryUtil.getLocation(blitImage.imageBoundsInDeviceSpace());
        return new MaskedPaint(PaintParser.DEFAULT_COLOR, blitImage.image().getRaster(), offset, this.surfaceSupplier.resourceCleaner(output, useCache));
    }

    @Override
    public boolean requiresInstantiation() {
        return true;
    }

    @Override
    public boolean canInstantiate(@NotNull SVGNode node) {
        return node == this;
    }
}

