/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nodes.input;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.regex.tregex.nodes.input.InputIndexOfStringNodeGen;
import com.oracle.truffle.regex.tregex.string.Encodings;

@GenerateInline
public abstract class InputIndexOfStringNode
extends Node {
    public abstract int execute(Node var1, TruffleString var2, int var3, int var4, TruffleString var5, TruffleString.WithMask var6, Encodings.Encoding var7);

    @Specialization(guards={"mask == null"})
    public int doTString(TruffleString input, int fromIndex, int maxIndex, TruffleString match, TruffleString.WithMask mask, Encodings.Encoding encoding, @Cached(inline=false) @Cached.Shared TruffleString.ByteIndexOfStringNode indexOfStringNode) {
        int fromByteIndex = fromIndex << encoding.getStride();
        if (fromByteIndex >= input.byteLength(encoding.getTStringEncoding())) {
            return -1;
        }
        return indexOfStringNode.execute((AbstractTruffleString)input, (AbstractTruffleString)match, fromByteIndex, maxIndex << encoding.getStride(), encoding.getTStringEncoding()) >> encoding.getStride();
    }

    @Fallback
    public int doTStringMask(TruffleString input, int fromIndex, int maxIndex, TruffleString match, TruffleString.WithMask mask, Encodings.Encoding encoding, @Cached(inline=false) @Cached.Shared TruffleString.ByteIndexOfStringNode indexOfStringNode) {
        int fromByteIndex = fromIndex << encoding.getStride();
        if (fromByteIndex >= input.byteLength(encoding.getTStringEncoding())) {
            return -1;
        }
        return indexOfStringNode.execute((AbstractTruffleString)input, mask, fromByteIndex, maxIndex << encoding.getStride(), encoding.getTStringEncoding()) >> encoding.getStride();
    }

    @NeverDefault
    public static InputIndexOfStringNode create() {
        return InputIndexOfStringNodeGen.create();
    }
}

