/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.parser;

import com.github.weisj.jsvg.parser.LoaderContext;
import com.github.weisj.jsvg.parser.ParsedElement;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParsedDocument {
    private final Map<String, Object> namedElements = new HashMap<String, Object>();
    @Nullable
    private final URI rootURI;
    @NotNull
    private final LoaderContext loaderContext;

    public ParsedDocument(@Nullable URI rootURI, @NotNull LoaderContext loaderContext) {
        this.rootURI = rootURI;
        this.loaderContext = loaderContext;
    }

    @NotNull
    public LoaderContext loaderContext() {
        return this.loaderContext;
    }

    public void registerNamedElement(@NotNull String name, @Nullable Object element) {
        this.namedElements.put(name, element);
    }

    @Nullable
    public <T> T getElementById(@NotNull Class<T> type, @Nullable String id) {
        if (id == null) {
            return null;
        }
        Object node = this.namedElements.get(id);
        if (node instanceof ParsedElement) {
            node = ((ParsedElement)node).nodeEnsuringBuildStatus();
            this.namedElements.put(id, node);
        }
        return type.isInstance(node) ? (T)type.cast(node) : null;
    }

    public boolean hasElementWithId(@NotNull String id) {
        return this.namedElements.containsKey(id);
    }

    @Nullable
    public URI rootURI() {
        return this.rootURI;
    }
}

