/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.parser;

import com.github.weisj.jsvg.parser.DefaultElementLoader;
import com.github.weisj.jsvg.parser.ElementLoader;
import com.github.weisj.jsvg.parser.ParsedDocument;
import com.github.weisj.jsvg.parser.SVGDocumentBuilder;
import com.github.weisj.jsvg.parser.SVGLoader;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
class ExternalDocumentLoader
implements DefaultElementLoader.DocumentLoader {
    private static final Logger LOGGER = Logger.getLogger(ExternalDocumentLoader.class.getName());
    @NotNull
    private final Map<URI, CachedDocument> cache = new HashMap<URI, CachedDocument>();
    @NotNull
    private final ElementLoader.ExternalDocumentPolicy policy;

    ExternalDocumentLoader(@NotNull ElementLoader.ExternalDocumentPolicy policy) {
        this.policy = policy;
    }

    @Override
    @Nullable
    public ParsedDocument resolveDocument(@NotNull ParsedDocument document, @NotNull String name) {
        if (name.isEmpty()) {
            return document;
        }
        return this.locateDocument(document, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private ParsedDocument locateDocument(@NotNull ParsedDocument document, @NotNull String name) {
        URI root = document.rootURI();
        if (root == null) {
            return null;
        }
        try {
            Object cachedDocument;
            URI documentUri = this.policy.resolveDocumentURI(root, name);
            if (documentUri == null) {
                return null;
            }
            URL documentUrl = documentUri.toURL();
            Map<URI, CachedDocument> map = this.cache;
            synchronized (map) {
                cachedDocument = this.cache.get(documentUri);
                if (cachedDocument != null) {
                    ParsedDocument cached = ((CachedDocument)cachedDocument).document;
                    if (cached == null) {
                        throw new IllegalStateException("Reference cycle containing external document: " + documentUri);
                    }
                    return cached;
                }
            }
            CachedDocument cachedDocument2 = new CachedDocument();
            cachedDocument = this.cache;
            synchronized (cachedDocument) {
                this.cache.put(documentUri, cachedDocument2);
            }
            SVGDocumentBuilder builder = new SVGLoader().loader().parse(SVGLoader.createDocumentInputStream(documentUrl.openStream()), documentUri, document.loaderContext());
            if (builder == null) {
                return null;
            }
            builder.preProcess(documentUri);
            ParsedDocument parsedDocument = builder.parsedDocument();
            Map<URI, CachedDocument> map2 = this.cache;
            synchronized (map2) {
                cachedDocument2.document = parsedDocument;
            }
            return parsedDocument;
        }
        catch (Exception e) {
            LOGGER.warning(String.format("Failed to load external document: %s from %s - %s", name, root, e.getMessage()));
            return null;
        }
    }

    private static final class CachedDocument {
        @Nullable
        private ParsedDocument document;

        private CachedDocument() {
        }
    }
}

