/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.css.editor.ParsingErrorsFilter;
import org.netbeans.modules.css.editor.csl.CssErrorFactory;
import org.netbeans.modules.css.lib.api.CssParserResult;
import org.netbeans.modules.css.lib.api.ErrorsProvider;
import org.netbeans.modules.css.lib.api.FilterableError;
import org.netbeans.modules.css.lib.api.ProblemDescription;
import org.openide.filesystems.FileObject;

public class DefaultErrorsProvider
implements ErrorsProvider {
    public List<? extends FilterableError> getExtendedDiagnostics(CssParserResult parserResult) {
        return DefaultErrorsProvider.getCslErrorForCss3ProblemDescription(parserResult.getSnapshot().getSource().getFileObject(), parserResult.getParserDiagnostics());
    }

    public static List<FilterableError> getCslErrorForCss3ProblemDescription(FileObject file, List<ProblemDescription> pds) {
        ArrayList<FilterableError> errors = new ArrayList<FilterableError>();
        for (ProblemDescription pd : pds) {
            errors.add(DefaultErrorsProvider.getCslErrorForCss3ProblemDescription(file, pd));
        }
        return errors;
    }

    private static FilterableError getCslErrorForCss3ProblemDescription(FileObject file, ProblemDescription pd) {
        return CssErrorFactory.createError(pd.getKey(), pd.getDescription(), pd.getDescription(), file, pd.getFrom(), pd.getTo(), false, DefaultErrorsProvider.getCslSeverityForCss3ProblemType(pd.getType()), ParsingErrorsFilter.getEnableFilterAction(file, pd.getDescription()), ParsingErrorsFilter.getDisableFilterAction(file, pd.getDescription()));
    }

    private static Severity getCslSeverityForCss3ProblemType(ProblemDescription.Type problemType) {
        switch (problemType) {
            case ERROR: {
                return Severity.ERROR;
            }
            case FATAL: {
                return Severity.FATAL;
            }
            case INFO: {
                return Severity.INFO;
            }
            case WARNING: {
                return Severity.WARNING;
            }
        }
        return Severity.ERROR;
    }
}

