/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.puma;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.puma.Http11Parser;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class Http11
extends RubyObject {
    public static final int MAX_FIELD_NAME_LENGTH = 256;
    public static final String MAX_FIELD_NAME_LENGTH_ERR = "HTTP element FIELD_NAME is longer than the 256 allowed length.";
    public static final int MAX_FIELD_VALUE_LENGTH = 81920;
    public static final String MAX_FIELD_VALUE_LENGTH_ERR = "HTTP element FIELD_VALUE is longer than the 81920 allowed length.";
    public static final int MAX_REQUEST_URI_LENGTH = Http11.getConstLength("PUMA_REQUEST_URI_MAX_LENGTH", 12288);
    public static final String MAX_REQUEST_URI_LENGTH_ERR = "HTTP element REQUEST_URI is longer than the " + MAX_REQUEST_URI_LENGTH + " allowed length.";
    public static final int MAX_FRAGMENT_LENGTH = 1024;
    public static final String MAX_FRAGMENT_LENGTH_ERR = "HTTP element REQUEST_PATH is longer than the 1024 allowed length.";
    public static final int MAX_REQUEST_PATH_LENGTH = Http11.getConstLength("PUMA_REQUEST_PATH_MAX_LENGTH", 8192);
    public static final String MAX_REQUEST_PATH_LENGTH_ERR = "HTTP element REQUEST_PATH is longer than the " + MAX_REQUEST_PATH_LENGTH + " allowed length.";
    public static final int MAX_QUERY_STRING_LENGTH = Http11.getConstLength("PUMA_QUERY_STRING_MAX_LENGTH", 10240);
    public static final String MAX_QUERY_STRING_LENGTH_ERR = "HTTP element QUERY_STRING is longer than the " + MAX_QUERY_STRING_LENGTH + " allowed length.";
    public static final int MAX_HEADER_LENGTH = 114688;
    public static final String MAX_HEADER_LENGTH_ERR = "HTTP element HEADER is longer than the 114688 allowed length.";
    public static final ByteList CONTENT_TYPE_BYTELIST = new ByteList(ByteList.plain((CharSequence)"CONTENT_TYPE"));
    public static final ByteList CONTENT_LENGTH_BYTELIST = new ByteList(ByteList.plain((CharSequence)"CONTENT_LENGTH"));
    public static final ByteList HTTP_PREFIX_BYTELIST = new ByteList(ByteList.plain((CharSequence)"HTTP_"));
    public static final ByteList COMMA_SPACE_BYTELIST = new ByteList(ByteList.plain((CharSequence)", "));
    public static final ByteList REQUEST_METHOD_BYTELIST = new ByteList(ByteList.plain((CharSequence)"REQUEST_METHOD"));
    public static final ByteList REQUEST_URI_BYTELIST = new ByteList(ByteList.plain((CharSequence)"REQUEST_URI"));
    public static final ByteList FRAGMENT_BYTELIST = new ByteList(ByteList.plain((CharSequence)"FRAGMENT"));
    public static final ByteList REQUEST_PATH_BYTELIST = new ByteList(ByteList.plain((CharSequence)"REQUEST_PATH"));
    public static final ByteList QUERY_STRING_BYTELIST = new ByteList(ByteList.plain((CharSequence)"QUERY_STRING"));
    public static final ByteList SERVER_PROTOCOL_BYTELIST = new ByteList(ByteList.plain((CharSequence)"SERVER_PROTOCOL"));
    private static ObjectAllocator ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new Http11(ruby, rubyClass);
        }
    };
    private Ruby runtime;
    private Http11Parser hp;
    private RubyString body;

    public static String getEnvOrProperty(String string) {
        String string2 = System.getenv(string);
        return string2 != null ? string2 : System.getProperty(string);
    }

    public static int getConstLength(String string, Integer n) {
        String string2 = Http11.getEnvOrProperty(string);
        if (string2 == null || string2.isEmpty()) {
            return n;
        }
        try {
            int n2 = Integer.parseUnsignedInt(string2);
            if (n2 <= 0) {
                throw new NumberFormatException("The number is not positive.");
            }
            return n2;
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println(String.format("The value %s for %s is invalid. Using default value %d instead.", string2, string, n));
            return n;
        }
    }

    public static void createHttp11(Ruby ruby) {
        RubyModule rubyModule = ruby.defineModule("Puma");
        rubyModule.defineClassUnder("HttpParserError", ruby.getClass("IOError"), ruby.getClass("IOError").getAllocator());
        RubyClass rubyClass = rubyModule.defineClassUnder("HttpParser", ruby.getObject(), ALLOCATOR);
        rubyClass.defineAnnotatedMethods(Http11.class);
    }

    public Http11(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
        this.runtime = ruby;
        this.hp = new Http11Parser();
        this.hp.parser.init();
    }

    public static void validateMaxLength(Ruby ruby, int n, int n2, String string) {
        if (n > n2) {
            throw Http11.newHTTPParserError(ruby, string);
        }
    }

    private static RaiseException newHTTPParserError(Ruby ruby, String string) {
        return ruby.newRaiseException(Http11.getHTTPParserError(ruby), string);
    }

    private static RubyClass getHTTPParserError(Ruby ruby) {
        return (RubyClass)ruby.getModule("Puma").getConstant("HttpParserError");
    }

    public static void http_field(Ruby ruby, RubyHash rubyHash, ByteList byteList, int n, int n2, int n3, int n4) {
        RubyString rubyString;
        Http11.validateMaxLength(ruby, n2, 256, MAX_FIELD_NAME_LENGTH_ERR);
        Http11.validateMaxLength(ruby, n4, 81920, MAX_FIELD_VALUE_LENGTH_ERR);
        ByteList byteList2 = new ByteList(byteList, n, n2);
        int n5 = byteList2.length();
        for (int i = 0; i < n5; ++i) {
            int n6 = byteList2.get(i) & 0xFF;
            if (n6 == 45) {
                byteList2.set(i, 95);
                continue;
            }
            if (n6 == 95) {
                byteList2.set(i, 44);
                continue;
            }
            byteList2.set(i, (int)((byte)Character.toUpperCase(n6)));
        }
        while (n4 > 0 && Character.isWhitespace(byteList.get(n3 + n4 - 1))) {
            --n4;
        }
        if (byteList2.equals((Object)CONTENT_LENGTH_BYTELIST) || byteList2.equals((Object)CONTENT_TYPE_BYTELIST)) {
            rubyString = RubyString.newString((Ruby)ruby, (ByteList)byteList2);
        } else {
            rubyString = RubyString.newStringShared((Ruby)ruby, (ByteList)HTTP_PREFIX_BYTELIST);
            rubyString.cat(byteList2);
        }
        byteList2 = new ByteList(byteList, n3, n4);
        IRubyObject iRubyObject = rubyHash.fastARef((IRubyObject)rubyString);
        if (iRubyObject == null || iRubyObject.isNil()) {
            rubyHash.fastASet((IRubyObject)rubyString, (IRubyObject)RubyString.newString((Ruby)ruby, (ByteList)byteList2));
        } else {
            RubyString rubyString2 = iRubyObject.convertToString();
            rubyString2.cat(COMMA_SPACE_BYTELIST);
            rubyString2.cat(byteList2);
        }
    }

    public static void request_method(Ruby ruby, RubyHash rubyHash, ByteList byteList, int n, int n2) {
        RubyString rubyString = RubyString.newString((Ruby)ruby, (ByteList)new ByteList(byteList, n, n2));
        rubyHash.fastASet((IRubyObject)RubyString.newStringShared((Ruby)ruby, (ByteList)REQUEST_METHOD_BYTELIST), (IRubyObject)rubyString);
    }

    public static void request_uri(Ruby ruby, RubyHash rubyHash, ByteList byteList, int n, int n2) {
        Http11.validateMaxLength(ruby, n2, MAX_REQUEST_URI_LENGTH, MAX_REQUEST_URI_LENGTH_ERR);
        RubyString rubyString = RubyString.newString((Ruby)ruby, (ByteList)new ByteList(byteList, n, n2));
        rubyHash.fastASet((IRubyObject)RubyString.newStringShared((Ruby)ruby, (ByteList)REQUEST_URI_BYTELIST), (IRubyObject)rubyString);
    }

    public static void fragment(Ruby ruby, RubyHash rubyHash, ByteList byteList, int n, int n2) {
        Http11.validateMaxLength(ruby, n2, 1024, MAX_FRAGMENT_LENGTH_ERR);
        RubyString rubyString = RubyString.newString((Ruby)ruby, (ByteList)new ByteList(byteList, n, n2));
        rubyHash.fastASet((IRubyObject)RubyString.newStringShared((Ruby)ruby, (ByteList)FRAGMENT_BYTELIST), (IRubyObject)rubyString);
    }

    public static void request_path(Ruby ruby, RubyHash rubyHash, ByteList byteList, int n, int n2) {
        Http11.validateMaxLength(ruby, n2, MAX_REQUEST_PATH_LENGTH, MAX_REQUEST_PATH_LENGTH_ERR);
        RubyString rubyString = RubyString.newString((Ruby)ruby, (ByteList)new ByteList(byteList, n, n2));
        rubyHash.fastASet((IRubyObject)RubyString.newStringShared((Ruby)ruby, (ByteList)REQUEST_PATH_BYTELIST), (IRubyObject)rubyString);
    }

    public static void query_string(Ruby ruby, RubyHash rubyHash, ByteList byteList, int n, int n2) {
        Http11.validateMaxLength(ruby, n2, MAX_QUERY_STRING_LENGTH, MAX_QUERY_STRING_LENGTH_ERR);
        RubyString rubyString = RubyString.newString((Ruby)ruby, (ByteList)new ByteList(byteList, n, n2));
        rubyHash.fastASet((IRubyObject)RubyString.newStringShared((Ruby)ruby, (ByteList)QUERY_STRING_BYTELIST), (IRubyObject)rubyString);
    }

    public static void server_protocol(Ruby ruby, RubyHash rubyHash, ByteList byteList, int n, int n2) {
        RubyString rubyString = RubyString.newString((Ruby)ruby, (ByteList)new ByteList(byteList, n, n2));
        rubyHash.fastASet((IRubyObject)RubyString.newStringShared((Ruby)ruby, (ByteList)SERVER_PROTOCOL_BYTELIST), (IRubyObject)rubyString);
    }

    public void header_done(Ruby ruby, RubyHash rubyHash, ByteList byteList, int n, int n2) {
        this.body = RubyString.newStringShared((Ruby)ruby, (ByteList)new ByteList(byteList, n, n2));
    }

    @JRubyMethod
    public IRubyObject initialize() {
        this.hp.parser.init();
        return this;
    }

    @JRubyMethod
    public IRubyObject reset() {
        this.hp.parser.init();
        return this.runtime.getNil();
    }

    @JRubyMethod
    public IRubyObject finish() {
        this.hp.finish();
        return this.hp.is_finished() ? this.runtime.getTrue() : this.runtime.getFalse();
    }

    @JRubyMethod
    public IRubyObject execute(IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        ByteList byteList;
        int n = RubyNumeric.fix2int((IRubyObject)iRubyObject3);
        if (n >= (byteList = ((RubyString)iRubyObject2).getByteList()).length()) {
            throw Http11.newHTTPParserError(this.runtime, "Requested start is after data buffer end.");
        }
        Http11Parser http11Parser = this.hp;
        Http11Parser.HttpParser httpParser = http11Parser.parser;
        httpParser.data = (RubyHash)iRubyObject;
        http11Parser.execute(this.runtime, this, byteList, n);
        Http11.validateMaxLength(this.runtime, httpParser.nread, 114688, MAX_HEADER_LENGTH_ERR);
        if (http11Parser.has_error()) {
            throw Http11.newHTTPParserError(this.runtime, "Invalid HTTP format, parsing fails. Are you trying to open an SSL connection to a non-SSL Puma?");
        }
        return this.runtime.newFixnum(httpParser.nread);
    }

    @JRubyMethod(name={"error?"})
    public IRubyObject has_error() {
        return this.hp.has_error() ? this.runtime.getTrue() : this.runtime.getFalse();
    }

    @JRubyMethod(name={"finished?"})
    public IRubyObject is_finished() {
        return this.hp.is_finished() ? this.runtime.getTrue() : this.runtime.getFalse();
    }

    @JRubyMethod
    public IRubyObject nread() {
        return this.runtime.newFixnum(this.hp.parser.nread);
    }

    @JRubyMethod
    public IRubyObject body() {
        return this.body;
    }
}

