/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.rts;

import java.util.Vector;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.sql.execute.ResultSetStatistics;
import org.apache.derby.iapi.sql.execute.xplain.XPLAINVisitor;
import org.apache.derby.impl.sql.catalog.XPLAINResultSetTimingsDescriptor;
import org.apache.derby.impl.sql.execute.rts.RealNoPutResultSetStatistics;
import org.apache.derby.impl.sql.execute.xplain.XPLAINUtil;
import org.apache.derby.shared.common.i18n.MessageService;
import org.apache.derby.shared.common.util.ArrayUtil;

public class RealProjectRestrictStatistics
extends RealNoPutResultSetStatistics {
    public boolean doesProjection;
    public boolean restriction;
    public long restrictionTime;
    public long projectionTime;
    public ResultSetStatistics childResultSetStatistics;
    public ResultSetStatistics[] subqueryTrackingArray;

    public RealProjectRestrictStatistics(int numOpens, int rowsSeen, int rowsFiltered, long constructorTime, long openTime, long nextTime, long closeTime, int resultSetNumber, long restrictionTime, long projectionTime, ResultSetStatistics[] subqueryTrackingArray, boolean restriction, boolean doesProjection, double optimizerEstimatedRowCount, double optimizerEstimatedCost, ResultSetStatistics childResultSetStatistics) {
        super(numOpens, rowsSeen, rowsFiltered, constructorTime, openTime, nextTime, closeTime, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.restriction = restriction;
        this.doesProjection = doesProjection;
        this.restrictionTime = restrictionTime;
        this.projectionTime = projectionTime;
        this.subqueryTrackingArray = (ResultSetStatistics[])ArrayUtil.copy((Object[])subqueryTrackingArray);
        this.childResultSetStatistics = childResultSetStatistics;
    }

    @Override
    public String getStatementExecutionPlanText(int depth) {
        Object subqueryInfo = "";
        this.initFormatInfo(depth);
        if (this.subqueryTrackingArray != null) {
            boolean foundAttached = false;
            for (int index = 0; index < this.subqueryTrackingArray.length; ++index) {
                if (this.subqueryTrackingArray[index] == null) continue;
                if (!foundAttached) {
                    subqueryInfo = this.indent + MessageService.getTextMessage((String)"43X56.U", (Object[])new Object[0]) + ":\n";
                    foundAttached = true;
                }
                subqueryInfo = (String)subqueryInfo + this.subqueryTrackingArray[index].getStatementExecutionPlanText(this.sourceDepth);
            }
        }
        return (String)subqueryInfo + this.indent + MessageService.getTextMessage((String)"43X93.U", (Object[])new Object[0]) + " (" + this.resultSetNumber + "):\n" + this.indent + MessageService.getTextMessage((String)"43X03.U", (Object[])new Object[0]) + " = " + this.numOpens + "\n" + this.indent + MessageService.getTextMessage((String)"43X04.U", (Object[])new Object[0]) + " = " + this.rowsSeen + "\n" + this.indent + MessageService.getTextMessage((String)"43X32.U", (Object[])new Object[0]) + " = " + this.rowsFiltered + "\n" + this.indent + MessageService.getTextMessage((String)"43X94.U", (Object[])new Object[0]) + " = " + this.restriction + "\n" + this.indent + MessageService.getTextMessage((String)"43X95.U", (Object[])new Object[0]) + " = " + this.doesProjection + "\n" + this.dumpTimeStats(this.indent, this.subIndent) + "\n" + this.subIndent + MessageService.getTextMessage((String)"43X96.U", (Object[])new Object[0]) + " = " + this.restrictionTime + "\n" + this.subIndent + MessageService.getTextMessage((String)"43X97.U", (Object[])new Object[0]) + " = " + this.projectionTime + "\n" + this.dumpEstimatedCosts(this.subIndent) + "\n" + this.indent + MessageService.getTextMessage((String)"43X05.U", (Object[])new Object[0]) + ":\n" + this.childResultSetStatistics.getStatementExecutionPlanText(this.sourceDepth);
    }

    @Override
    public String getScanStatisticsText(String tableName, int depth) {
        Object subqueryInfo = "";
        if (this.subqueryTrackingArray != null) {
            for (int index = 0; index < this.subqueryTrackingArray.length; ++index) {
                if (this.subqueryTrackingArray[index] == null) continue;
                subqueryInfo = (String)subqueryInfo + "\n" + MessageService.getTextMessage((String)"43X01.U", (Object[])new Object[0]) + " " + index + "\n" + this.subqueryTrackingArray[index].getScanStatisticsText(tableName, depth) + MessageService.getTextMessage((String)"43X06.U", (Object[])new Object[0]) + " " + index + "\n\n";
            }
        }
        return (String)subqueryInfo + this.childResultSetStatistics.getScanStatisticsText(tableName, depth);
    }

    public String toString() {
        return this.getStatementExecutionPlanText(0);
    }

    @Override
    public Vector<ResultSetStatistics> getChildren() {
        Vector<ResultSetStatistics> children = new Vector<ResultSetStatistics>();
        children.addElement(this.childResultSetStatistics);
        if (this.subqueryTrackingArray != null) {
            for (int index = 0; index < this.subqueryTrackingArray.length; ++index) {
                if (this.subqueryTrackingArray[index] == null) continue;
                children.addElement(this.subqueryTrackingArray[index]);
            }
        }
        return children;
    }

    @Override
    public String getNodeName() {
        return MessageService.getTextMessage((String)"43X98.U", (Object[])new Object[0]);
    }

    @Override
    public void accept(XPLAINVisitor visitor) {
        int noChildren = 0;
        if (this.childResultSetStatistics != null) {
            ++noChildren;
        }
        if (this.subqueryTrackingArray != null) {
            noChildren += this.subqueryTrackingArray.length;
        }
        visitor.setNumberOfChildren(noChildren);
        visitor.visit(this);
        if (this.childResultSetStatistics != null) {
            this.childResultSetStatistics.accept(visitor);
        }
        if (this.subqueryTrackingArray != null) {
            boolean foundAttached = false;
            for (int index = 0; index < this.subqueryTrackingArray.length; ++index) {
                if (this.subqueryTrackingArray[index] == null) continue;
                this.subqueryTrackingArray[index].accept(visitor);
            }
        }
    }

    @Override
    public String getRSXplainType() {
        if (this.restriction && this.doesProjection) {
            return "PROJECT-FILTER";
        }
        if (this.doesProjection) {
            return "PROJECTION";
        }
        if (this.restriction) {
            return "FILTER";
        }
        return "PROJECT-FILTER";
    }

    @Override
    public String getRSXplainDetails() {
        return this.resultSetNumber + ";";
    }

    @Override
    public Object getResultSetTimingsDescriptor(Object timingID) {
        return new XPLAINResultSetTimingsDescriptor((UUID)timingID, this.constructorTime, this.openTime, this.nextTime, this.closeTime, this.getNodeTime(), XPLAINUtil.getAVGNextTime(this.nextTime, this.rowsSeen), this.projectionTime, this.restrictionTime, null, null);
    }
}

