/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.util;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import org.jfree.report.DataRow;
import org.jfree.report.DataSourceException;
import org.jfree.report.util.CSVTokenizer;
import org.jfree.report.util.PropertyLookupParser;

public class MessageFormatSupport
implements Serializable,
Cloneable {
    private String[] fields;
    private MessageFormat format;
    private String formatString;
    private String compiledFormat;
    private String nullString;

    public String getFormatString() {
        return this.formatString;
    }

    public void setFormatString(String string) {
        MessageCompiler messageCompiler = new MessageCompiler();
        if (string == null) {
            throw new NullPointerException("Format must not be null");
        }
        this.compiledFormat = messageCompiler.translateAndLookup(string);
        this.fields = messageCompiler.getFields();
        this.format = new MessageFormat(this.compiledFormat);
        this.formatString = string;
    }

    public String performFormat(DataRow dataRow) throws DataSourceException {
        return MessageFormatSupport.formatWithReplace(dataRow, this.format, this.fields, this.nullString);
    }

    public Locale getLocale() {
        return this.format.getLocale();
    }

    public String getCompiledFormat() {
        return this.compiledFormat;
    }

    public void setLocale(Locale locale) {
        this.format.setLocale(locale);
        this.format.applyPattern(this.compiledFormat);
    }

    public String getNullString() {
        return this.nullString;
    }

    public void setNullString(String string) {
        this.nullString = string;
    }

    public Object clone() throws CloneNotSupportedException {
        MessageFormatSupport messageFormatSupport = (MessageFormatSupport)super.clone();
        if (this.format != null) {
            messageFormatSupport.format = (MessageFormat)this.format.clone();
        }
        return messageFormatSupport;
    }

    public String[] getFields() {
        return (String[])this.fields.clone();
    }

    public static String formatWithReplace(DataRow dataRow, MessageFormat messageFormat, String[] stringArray, String string) throws DataSourceException {
        if (stringArray == null || messageFormat == null) {
            return null;
        }
        boolean bl = string == null;
        Format[] formatArray = messageFormat.getFormats();
        boolean bl2 = true;
        Object[] objectArray = new Object[stringArray.length];
        boolean[] blArray = new boolean[stringArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = dataRow.get(stringArray[i]);
            Format format = formatArray[i];
            if (object == null) {
                objectArray[i] = string;
                blArray[i] = format != null;
                bl2 = bl2 && bl && !blArray[i];
                continue;
            }
            if (format instanceof DateFormat) {
                if (object instanceof Date) {
                    objectArray[i] = object;
                    blArray[i] = false;
                    continue;
                }
                objectArray[i] = string;
                blArray[i] = true;
                bl2 = bl2 && bl && !blArray[i];
                continue;
            }
            if (format instanceof NumberFormat) {
                if (object instanceof Number) {
                    objectArray[i] = object;
                    blArray[i] = false;
                    continue;
                }
                objectArray[i] = string;
                blArray[i] = true;
                bl2 = bl2 && bl && !blArray[i];
                continue;
            }
            objectArray[i] = object;
            blArray[i] = false;
        }
        if (bl2) {
            return messageFormat.format(objectArray);
        }
        MessageFormat messageFormat2 = (MessageFormat)messageFormat.clone();
        for (int i = 0; i < blArray.length; ++i) {
            boolean bl3 = blArray[i];
            if (!bl3) continue;
            messageFormat2.setFormat(i, null);
        }
        return messageFormat2.format(objectArray);
    }

    public static String formatWithReplace(MessageFormat messageFormat, Object[] objectArray, String string) {
        if (objectArray == null || messageFormat == null) {
            return null;
        }
        Object[] objectArray2 = (Object[])objectArray.clone();
        boolean bl = string == null;
        Format[] formatArray = messageFormat.getFormats();
        boolean bl2 = true;
        boolean[] blArray = new boolean[objectArray2.length];
        for (int i = 0; i < objectArray2.length; ++i) {
            Object object = objectArray2[i];
            Format format = formatArray[i];
            if (object == null) {
                objectArray2[i] = string;
                blArray[i] = format != null;
                bl2 = bl2 && bl && !blArray[i];
                continue;
            }
            if (format instanceof DateFormat) {
                if (object instanceof Date) {
                    objectArray2[i] = object;
                    blArray[i] = false;
                    continue;
                }
                objectArray2[i] = string;
                blArray[i] = true;
                bl2 = bl2 && bl && !blArray[i];
                continue;
            }
            if (format instanceof NumberFormat) {
                if (object instanceof Number) {
                    objectArray2[i] = object;
                    blArray[i] = false;
                    continue;
                }
                objectArray2[i] = string;
                blArray[i] = true;
                bl2 = bl2 && bl && !blArray[i];
                continue;
            }
            objectArray2[i] = object;
            blArray[i] = false;
        }
        if (bl2) {
            return messageFormat.format(objectArray2);
        }
        MessageFormat messageFormat2 = (MessageFormat)messageFormat.clone();
        for (int i = 0; i < blArray.length; ++i) {
            boolean bl3 = blArray[i];
            if (!bl3) continue;
            messageFormat2.setFormat(i, null);
        }
        return messageFormat2.format(objectArray2);
    }

    protected static class MessageCompiler
    extends PropertyLookupParser {
        private ArrayList fields = new ArrayList();
        private ArrayList completeFormatString = new ArrayList();

        public MessageCompiler() {
            this.setMarkerChar('$');
            this.setOpeningBraceChar('(');
            this.setClosingBraceChar(')');
        }

        @Override
        protected String lookupVariable(String string) {
            CSVTokenizer cSVTokenizer = new CSVTokenizer(string, ",", "\"");
            if (!cSVTokenizer.hasMoreTokens()) {
                return null;
            }
            String string2 = cSVTokenizer.nextToken();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{");
            stringBuffer.append(String.valueOf(this.fields.size()));
            while (cSVTokenizer.hasMoreTokens()) {
                stringBuffer.append(",");
                stringBuffer.append(cSVTokenizer.nextToken());
            }
            stringBuffer.append("}");
            String string3 = stringBuffer.toString();
            this.completeFormatString.add(string3);
            this.fields.add(string2);
            return string3;
        }

        public String[] getFields() {
            return this.fields.toArray(new String[this.fields.size()]);
        }
    }
}

