/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.modules.output.html;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import org.jfree.layouting.DocumentContextUtility;
import org.jfree.layouting.LibLayoutBoot;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.StyleKeyRegistry;
import org.jfree.layouting.input.style.keys.border.BorderStyle;
import org.jfree.layouting.input.style.keys.border.BorderStyleKeys;
import org.jfree.layouting.input.style.keys.box.BoxStyleKeys;
import org.jfree.layouting.input.style.keys.box.DisplayRole;
import org.jfree.layouting.input.style.keys.color.ColorStyleKeys;
import org.jfree.layouting.input.style.keys.color.HtmlColors;
import org.jfree.layouting.input.style.keys.font.FontStyleKeys;
import org.jfree.layouting.input.style.keys.line.LineStyleKeys;
import org.jfree.layouting.input.style.keys.text.TextStyleKeys;
import org.jfree.layouting.input.style.values.CSSColorValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.DocumentContext;
import org.jfree.layouting.layouter.context.FontSpecification;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.context.LayoutStyle;
import org.jfree.layouting.modules.output.html.FileSystemURLRewriter;
import org.jfree.layouting.modules.output.html.StyleBuilder;
import org.jfree.layouting.modules.output.html.URLRewriteException;
import org.jfree.layouting.modules.output.html.URLRewriter;
import org.jfree.layouting.renderer.model.BlockRenderBox;
import org.jfree.layouting.renderer.model.ComputedLayoutProperties;
import org.jfree.layouting.renderer.model.InlineRenderBox;
import org.jfree.layouting.renderer.model.MarkerRenderBox;
import org.jfree.layouting.renderer.model.NodeLayoutProperties;
import org.jfree.layouting.renderer.model.ParagraphRenderBox;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.model.RenderableReplacedContent;
import org.jfree.layouting.renderer.model.RenderableText;
import org.jfree.layouting.renderer.model.SpacerRenderNode;
import org.jfree.layouting.renderer.model.page.LogicalPageBox;
import org.jfree.layouting.renderer.model.table.TableCellRenderBox;
import org.jfree.layouting.renderer.model.table.TableRenderBox;
import org.jfree.layouting.renderer.model.table.TableRowRenderBox;
import org.jfree.layouting.renderer.model.table.TableSectionRenderBox;
import org.jfree.layouting.renderer.model.table.cols.TableColumn;
import org.jfree.layouting.renderer.model.table.cols.TableColumnModel;
import org.jfree.layouting.renderer.process.IterateStructuralProcessStep;
import org.jfree.layouting.util.ImageUtils;
import org.jfree.layouting.util.geom.StrictGeomUtility;
import org.pentaho.reporting.libraries.base.util.FastStack;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.base.util.PngEncoder;
import org.pentaho.reporting.libraries.base.util.StackableRuntimeException;
import org.pentaho.reporting.libraries.base.util.WaitingImageObserver;
import org.pentaho.reporting.libraries.repository.ContentEntity;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentItem;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.NameGenerator;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.factory.drawable.DrawableWrapper;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.DefaultTagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.HtmlCharacterEntities;
import org.pentaho.reporting.libraries.xmlns.writer.TagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class HtmlPrinter
extends IterateStructuralProcessStep {
    private static final String[] XHTML_HEADER = new String[]{"<!DOCTYPE html", "     PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"", "     \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">"};
    public static final String TAG_DEF_PREFIX = "org.jfree.layouting.modules.output.html.";
    public static final float CORRECTION_FACTOR_PX_TO_POINT = 0.75f;
    public static final float CORRECTION_FACTOR_POINT_TO_PX = 1.3333334f;
    private XmlWriter xmlWriter;
    private FastStack contexts;
    private DecimalFormat pointConverter;
    private NumberFormat pointIntConverter;
    private boolean assumeZeroMargins;
    private boolean assumeZeroBorders;
    private boolean assumeZeroPaddings;
    private ContentLocation contentLocation;
    private NameGenerator contentNameGenerator;
    private ContentLocation dataLocation;
    private NameGenerator dataNameGenerator;
    private ResourceManager resourceManager;
    private HashMap knownResources = new HashMap();
    private HashSet validRawTypes = new HashSet();
    private String encoding = "ASCII";
    private URLRewriter urlRewriter;
    private ContentItem documentContentItem;
    private boolean generateFragment;

    public HtmlPrinter() {
        this.validRawTypes.add("image/gif");
        this.validRawTypes.add("image/x-xbitmap");
        this.validRawTypes.add("image/gi_");
        this.validRawTypes.add("image/jpeg");
        this.validRawTypes.add("image/jpg");
        this.validRawTypes.add("image/jp_");
        this.validRawTypes.add("application/jpg");
        this.validRawTypes.add("application/x-jpg");
        this.validRawTypes.add("image/pjpeg");
        this.validRawTypes.add("image/pipeg");
        this.validRawTypes.add("image/vnd.swiftview-jpeg");
        this.validRawTypes.add("image/x-xbitmap");
        this.validRawTypes.add("image/png");
        this.validRawTypes.add("application/png");
        this.validRawTypes.add("application/x-png");
        this.contexts = new FastStack();
        this.pointConverter = new DecimalFormat("0.####", new DecimalFormatSymbols(Locale.US));
        this.pointIntConverter = new DecimalFormat("0", new DecimalFormatSymbols(Locale.US));
        this.assumeZeroMargins = true;
        this.assumeZeroBorders = true;
        this.assumeZeroPaddings = true;
        this.urlRewriter = new FileSystemURLRewriter();
        this.generateFragment = false;
    }

    public URLRewriter getUrlRewriter() {
        return this.urlRewriter;
    }

    public void setUrlRewriter(URLRewriter uRLRewriter) {
        this.urlRewriter = uRLRewriter;
    }

    public NameGenerator getDataNameGenerator() {
        return this.dataNameGenerator;
    }

    public ContentLocation getDataLocation() {
        return this.dataLocation;
    }

    public NameGenerator getContentNameGenerator() {
        return this.contentNameGenerator;
    }

    public ContentLocation getContentLocation() {
        return this.contentLocation;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void generate(LogicalPageBox logicalPageBox, DocumentContext documentContext) throws IOException, ContentIOException {
        LayoutStyle layoutStyle;
        this.resourceManager = documentContext.getResourceManager();
        DefaultTagDescription defaultTagDescription = new DefaultTagDescription();
        defaultTagDescription.configure(LibLayoutBoot.getInstance().getGlobalConfig(), TAG_DEF_PREFIX);
        this.documentContentItem = this.contentLocation.createItem(this.contentNameGenerator.generateName(null, "text/html"));
        OutputStream outputStream = this.documentContentItem.getOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, this.encoding);
        this.xmlWriter = new XmlWriter((Writer)outputStreamWriter, (TagDescription)defaultTagDescription);
        this.xmlWriter.setAlwaysAddNamespace(false);
        this.xmlWriter.setAssumeDefaultNamespace(true);
        if (!this.generateFragment) {
            this.xmlWriter.writeXmlDeclaration(this.encoding);
            for (int i = 0; i < XHTML_HEADER.length; ++i) {
                this.xmlWriter.writeText(XHTML_HEADER[i]);
                this.xmlWriter.writeNewLine();
            }
            layoutStyle = new AttributeList();
            layoutStyle.addNamespaceDeclaration("", "http://www.w3.org/1999/xhtml");
            this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", "html", false);
            this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", "head", false);
            this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", "title", false);
            this.xmlWriter.writeText("Yeah, sure, I *should* grab a sensible title from somewhere");
            this.xmlWriter.writeCloseTag();
            this.xmlWriter.writeCloseTag();
            this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", "body", false);
        } else {
            this.xmlWriter.addImpliedNamespace("http://www.w3.org/1999/xhtml", "");
        }
        this.contexts.clear();
        layoutStyle = DocumentContextUtility.getInitialStyle(documentContext);
        StyleBuilder styleBuilder = new StyleBuilder(false);
        StyleKey[] styleKeyArray = StyleKeyRegistry.getRegistry().getKeys();
        for (int i = 0; i < styleKeyArray.length; ++i) {
            StyleKey styleKey = styleKeyArray[i];
            if (!styleKey.isInherited()) continue;
            styleBuilder.append(styleKey, layoutStyle.getValue(styleKey));
        }
        this.contexts.push((Object)new ContextElement(styleBuilder));
        this.startBlockBox(logicalPageBox);
        this.processBoxChilds(logicalPageBox);
        this.finishBlockBox(logicalPageBox);
        if (!this.generateFragment) {
            this.xmlWriter.writeCloseTag();
            this.xmlWriter.writeCloseTag();
        }
        this.xmlWriter.close();
        this.xmlWriter = null;
    }

    public boolean isGenerateFragment() {
        return this.generateFragment;
    }

    public void setGenerateFragment(boolean bl) {
        this.generateFragment = bl;
    }

    @Override
    protected boolean startInlineBox(InlineRenderBox inlineRenderBox) {
        try {
            StyleBuilder styleBuilder = this.createStyleBuilder();
            ContextElement contextElement = new ContextElement(styleBuilder);
            this.contexts.push((Object)contextElement);
            this.buildStyle(inlineRenderBox, styleBuilder);
            AttributeList attributeList = new AttributeList();
            if (!styleBuilder.isEmpty()) {
                attributeList.setAttribute("http://www.w3.org/1999/xhtml", "style", styleBuilder.toString());
            }
            if (!attributeList.isEmpty()) {
                this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", "span", attributeList, false);
            } else {
                contextElement.setOmitted(true);
            }
            return true;
        }
        catch (IOException iOException) {
            throw new StackableRuntimeException("Failed", (Exception)iOException);
        }
    }

    private void buildStyle(RenderBox renderBox, StyleBuilder styleBuilder) {
        String string;
        String string2;
        LayoutContext layoutContext = renderBox.getLayoutContext();
        if (layoutContext == null) {
            return;
        }
        FontSpecification fontSpecification = layoutContext.getFontSpecification();
        double d = fontSpecification.getFontSize();
        styleBuilder.append(FontStyleKeys.FONT_SIZE, this.toPointString(d), "pt");
        styleBuilder.append(FontStyleKeys.FONT_FAMILY, fontSpecification.getFontFamily());
        styleBuilder.append(FontStyleKeys.FONT_WEIGHT, layoutContext.getValue(FontStyleKeys.FONT_WEIGHT));
        styleBuilder.append(FontStyleKeys.FONT_STYLE, layoutContext.getValue(FontStyleKeys.FONT_STYLE));
        styleBuilder.append(TextStyleKeys.TEXT_ALIGN, layoutContext.getValue(TextStyleKeys.TEXT_ALIGN));
        styleBuilder.append(TextStyleKeys.TEXT_ALIGN_LAST, layoutContext.getValue(TextStyleKeys.TEXT_ALIGN_LAST));
        NodeLayoutProperties nodeLayoutProperties = renderBox.getNodeLayoutProperties();
        ComputedLayoutProperties computedLayoutProperties = renderBox.getComputedLayoutProperties();
        styleBuilder.append(LineStyleKeys.VERTICAL_ALIGN, nodeLayoutProperties.getVerticalAlignment());
        if (computedLayoutProperties.getPaddingTop() > 0L || computedLayoutProperties.getPaddingLeft() > 0L || computedLayoutProperties.getPaddingBottom() > 0L || computedLayoutProperties.getPaddingRight() > 0L) {
            if (computedLayoutProperties.getPaddingTop() > 0L || !this.assumeZeroPaddings) {
                styleBuilder.append(BoxStyleKeys.PADDING_TOP, this.toPointString(computedLayoutProperties.getPaddingTop()), "pt");
            }
            if (computedLayoutProperties.getPaddingLeft() > 0L || !this.assumeZeroPaddings) {
                styleBuilder.append(BoxStyleKeys.PADDING_LEFT, this.toPointString(computedLayoutProperties.getPaddingLeft()), "pt");
            }
            if (computedLayoutProperties.getPaddingBottom() > 0L || !this.assumeZeroPaddings) {
                styleBuilder.append(BoxStyleKeys.PADDING_BOTTOM, this.toPointString(computedLayoutProperties.getPaddingBottom()), "pt");
            }
            if (computedLayoutProperties.getPaddingRight() > 0L || !this.assumeZeroPaddings) {
                styleBuilder.append(BoxStyleKeys.PADDING_RIGHT, this.toPointString(computedLayoutProperties.getPaddingRight()), "pt");
            }
        } else if (!this.assumeZeroPaddings) {
            styleBuilder.append("padding", false, "0");
        }
        if (computedLayoutProperties.getMarginLeft() != 0L || computedLayoutProperties.getMarginRight() != 0L || computedLayoutProperties.getMarginTop() != 0L || computedLayoutProperties.getMarginBottom() != 0L) {
            if (computedLayoutProperties.getMarginLeft() > 0L || !this.assumeZeroMargins) {
                styleBuilder.append(BoxStyleKeys.MARGIN_LEFT, this.toPointString(computedLayoutProperties.getMarginLeft()), "pt");
            }
            if (computedLayoutProperties.getMarginRight() > 0L || !this.assumeZeroMargins) {
                styleBuilder.append(BoxStyleKeys.MARGIN_RIGHT, this.toPointString(computedLayoutProperties.getMarginRight()), "pt");
            }
            if (computedLayoutProperties.getMarginTop() > 0L || !this.assumeZeroMargins) {
                styleBuilder.append(BoxStyleKeys.MARGIN_TOP, this.toPointString(computedLayoutProperties.getMarginTop()), "pt");
            }
            if (computedLayoutProperties.getMarginBottom() > 0L || !this.assumeZeroMargins) {
                styleBuilder.append(BoxStyleKeys.MARGIN_BOTTOM, this.toPointString(computedLayoutProperties.getMarginBottom()), "pt");
            }
        } else if (!this.assumeZeroMargins) {
            styleBuilder.append("margin", false, "0");
        }
        if ((string2 = this.toColorString(layoutContext.getValue(BorderStyleKeys.BACKGROUND_COLOR))) != null) {
            styleBuilder.append(BorderStyleKeys.BACKGROUND_COLOR, string2);
        }
        if ((string = this.toColorString(layoutContext.getValue(ColorStyleKeys.COLOR))) != null) {
            styleBuilder.append(ColorStyleKeys.COLOR, string);
        }
        if (computedLayoutProperties.getBorderTop() > 0L || computedLayoutProperties.getBorderLeft() > 0L || computedLayoutProperties.getBorderBottom() > 0L || computedLayoutProperties.getBorderRight() > 0L) {
            if (computedLayoutProperties.getBorderTop() > 0L) {
                styleBuilder.append(BorderStyleKeys.BORDER_TOP_COLOR, layoutContext.getValue(BorderStyleKeys.BORDER_TOP_COLOR));
                styleBuilder.append(BorderStyleKeys.BORDER_TOP_STYLE, layoutContext.getValue(BorderStyleKeys.BORDER_TOP_STYLE));
                styleBuilder.append(BorderStyleKeys.BORDER_TOP_WIDTH, this.toPointString(computedLayoutProperties.getBorderTop()), "pt");
            } else if (!this.assumeZeroBorders) {
                styleBuilder.append(BorderStyleKeys.BORDER_TOP_STYLE, BorderStyle.NONE);
            }
            if (computedLayoutProperties.getBorderLeft() > 0L) {
                styleBuilder.append(BorderStyleKeys.BORDER_LEFT_COLOR, layoutContext.getValue(BorderStyleKeys.BORDER_LEFT_COLOR));
                styleBuilder.append(BorderStyleKeys.BORDER_LEFT_STYLE, layoutContext.getValue(BorderStyleKeys.BORDER_LEFT_STYLE));
                styleBuilder.append(BorderStyleKeys.BORDER_LEFT_WIDTH, this.toPointString(computedLayoutProperties.getBorderLeft()), "pt");
            } else if (!this.assumeZeroBorders) {
                styleBuilder.append(BorderStyleKeys.BORDER_LEFT_STYLE, BorderStyle.NONE);
            }
            if (computedLayoutProperties.getBorderBottom() > 0L) {
                styleBuilder.append(BorderStyleKeys.BORDER_BOTTOM_COLOR, layoutContext.getValue(BorderStyleKeys.BORDER_BOTTOM_COLOR));
                styleBuilder.append(BorderStyleKeys.BORDER_BOTTOM_STYLE, layoutContext.getValue(BorderStyleKeys.BORDER_BOTTOM_STYLE));
                styleBuilder.append(BorderStyleKeys.BORDER_BOTTOM_WIDTH, this.toPointString(computedLayoutProperties.getBorderBottom()), "pt");
            } else if (!this.assumeZeroBorders) {
                styleBuilder.append(BorderStyleKeys.BORDER_BOTTOM_STYLE, BorderStyle.NONE);
            }
            if (computedLayoutProperties.getBorderRight() > 0L) {
                styleBuilder.append(BorderStyleKeys.BORDER_RIGHT_COLOR, layoutContext.getValue(BorderStyleKeys.BORDER_RIGHT_COLOR));
                styleBuilder.append(BorderStyleKeys.BORDER_RIGHT_STYLE, layoutContext.getValue(BorderStyleKeys.BORDER_RIGHT_STYLE));
                styleBuilder.append(BorderStyleKeys.BORDER_RIGHT_WIDTH, this.toPointString(computedLayoutProperties.getBorderRight()), "pt");
            } else if (!this.assumeZeroBorders) {
                styleBuilder.append(BorderStyleKeys.BORDER_RIGHT_STYLE, BorderStyle.NONE);
            }
        } else if (!this.assumeZeroBorders) {
            styleBuilder.append("border-style", true, "none");
        }
    }

    private StyleBuilder createStyleBuilder() {
        StyleBuilder styleBuilder;
        if (this.contexts.isEmpty()) {
            styleBuilder = new StyleBuilder(true);
        } else {
            ContextElement contextElement = (ContextElement)this.contexts.peek();
            styleBuilder = new StyleBuilder(true, contextElement.getBuilder());
        }
        return styleBuilder;
    }

    private String toColorString(CSSValue cSSValue) {
        if (cSSValue == null) {
            return null;
        }
        if (!(cSSValue instanceof CSSColorValue)) {
            return cSSValue.getCSSText();
        }
        CSSColorValue cSSColorValue = (CSSColorValue)cSSValue;
        if (cSSColorValue.getAlpha() == 0) {
            return null;
        }
        try {
            Field[] fieldArray = HtmlColors.class.getFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                Field field = fieldArray[i];
                if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers()) || !Modifier.isStatic(field.getModifiers())) continue;
                String string = field.getName();
                Object object = field.get(null);
                if (!(object instanceof Color) || !cSSValue.equals(object)) continue;
                return string.toLowerCase();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cSSColorValue.getCSSText();
    }

    private String toPointString(double d) {
        if (Math.floor(d) == d) {
            return this.pointIntConverter.format(d);
        }
        return this.pointConverter.format(d);
    }

    private String toPointString(long l) {
        int n = (int)l % 1000;
        if (n == 0) {
            double d = StrictGeomUtility.toExternalValue(l);
            return this.pointIntConverter.format(d);
        }
        double d = StrictGeomUtility.toExternalValue(l);
        return this.pointConverter.format(d);
    }

    @Override
    protected void finishInlineBox(InlineRenderBox inlineRenderBox) {
        try {
            ContextElement contextElement = (ContextElement)this.contexts.pop();
            if (!contextElement.isOmitted()) {
                this.xmlWriter.writeCloseTag();
            }
        }
        catch (IOException iOException) {
            throw new StackableRuntimeException("Failed", (Exception)iOException);
        }
    }

    @Override
    protected boolean startBlockBox(BlockRenderBox blockRenderBox) {
        try {
            StyleBuilder styleBuilder = this.createStyleBuilder();
            this.contexts.push((Object)new ContextElement(styleBuilder));
            if (blockRenderBox instanceof TableRenderBox) {
                return this.startTable((TableRenderBox)blockRenderBox, styleBuilder);
            }
            if (blockRenderBox instanceof TableSectionRenderBox) {
                TableSectionRenderBox tableSectionRenderBox = (TableSectionRenderBox)blockRenderBox;
                CSSValue cSSValue = tableSectionRenderBox.getDisplayRole();
                if (DisplayRole.TABLE_HEADER_GROUP.equals(cSSValue)) {
                    return this.startTableHeader((TableSectionRenderBox)blockRenderBox, styleBuilder);
                }
                if (DisplayRole.TABLE_FOOTER_GROUP.equals(cSSValue)) {
                    return this.startTableFooter((TableSectionRenderBox)blockRenderBox, styleBuilder);
                }
                return this.startTableBody((TableSectionRenderBox)blockRenderBox, styleBuilder);
            }
            if (blockRenderBox instanceof TableRowRenderBox) {
                return this.startTableRow((TableRowRenderBox)blockRenderBox, styleBuilder);
            }
            if (blockRenderBox instanceof TableCellRenderBox) {
                return this.startTableCell((TableCellRenderBox)blockRenderBox, styleBuilder);
            }
            if (blockRenderBox instanceof ParagraphRenderBox) {
                return this.startParagraph((ParagraphRenderBox)blockRenderBox, styleBuilder);
            }
            if (blockRenderBox instanceof LogicalPageBox) {
                return this.startPageBox(blockRenderBox, styleBuilder);
            }
            if (blockRenderBox instanceof MarkerRenderBox) {
                return this.startMarkerContents(blockRenderBox, styleBuilder);
            }
            return this.startOtherBlockBox(blockRenderBox, styleBuilder);
        }
        catch (IOException iOException) {
            throw new StackableRuntimeException("Failed", (Exception)iOException);
        }
    }

    @Override
    protected void finishBlockBox(BlockRenderBox blockRenderBox) {
        try {
            if (blockRenderBox instanceof TableRenderBox) {
                this.finishTable((TableRenderBox)blockRenderBox);
            } else if (blockRenderBox instanceof TableSectionRenderBox) {
                TableSectionRenderBox tableSectionRenderBox = (TableSectionRenderBox)blockRenderBox;
                CSSValue cSSValue = tableSectionRenderBox.getDisplayRole();
                if (DisplayRole.TABLE_HEADER_GROUP.equals(cSSValue)) {
                    this.finishTableHeader((TableSectionRenderBox)blockRenderBox);
                } else if (DisplayRole.TABLE_FOOTER_GROUP.equals(cSSValue)) {
                    this.finishTableFooter((TableSectionRenderBox)blockRenderBox);
                } else {
                    this.finishTableBody((TableSectionRenderBox)blockRenderBox);
                }
            } else if (blockRenderBox instanceof TableRowRenderBox) {
                this.finishTableRow((TableRowRenderBox)blockRenderBox);
            } else if (blockRenderBox instanceof TableCellRenderBox) {
                this.finishTableCell((TableCellRenderBox)blockRenderBox);
            } else if (blockRenderBox instanceof ParagraphRenderBox) {
                this.finishParagraph((ParagraphRenderBox)blockRenderBox);
            } else if (blockRenderBox instanceof LogicalPageBox) {
                this.finishPageBox(blockRenderBox);
            } else if (blockRenderBox instanceof MarkerRenderBox) {
                this.finishMarkerBox(blockRenderBox);
            } else {
                this.finishOtherBlockBox(blockRenderBox);
            }
            this.contexts.pop();
        }
        catch (IOException iOException) {
            throw new StackableRuntimeException("Failed", (Exception)iOException);
        }
    }

    private void finishMarkerBox(RenderBox renderBox) throws IOException {
        this.xmlWriter.writeCloseTag();
    }

    protected boolean startMarkerContents(RenderBox renderBox, StyleBuilder styleBuilder) throws IOException {
        this.buildStyle(renderBox, styleBuilder);
        styleBuilder.append("white-space", false, "nowrap");
        AttributeList attributeList = new AttributeList();
        if (!styleBuilder.isEmpty()) {
            attributeList.setAttribute("http://www.w3.org/1999/xhtml", "style", styleBuilder.toString());
        }
        this.xmlWriter.writeComment("Marker-Box");
        this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", "span", attributeList, false);
        RenderNode renderNode = renderBox.getFirstChild();
        while (renderNode != null) {
            if (renderNode instanceof ParagraphRenderBox) {
                this.processParagraphChilds((ParagraphRenderBox)renderNode);
            } else if (renderNode instanceof RenderBox) {
                this.processBoxChilds((RenderBox)renderNode);
            } else {
                this.startProcessing(renderNode);
            }
            RenderNode renderNode2 = renderNode.getNext();
            if (renderNode2 == null) break;
            if (!renderNode2.isIgnorableForRendering()) {
                this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", "br", true);
            }
            renderNode = renderNode2;
        }
        return false;
    }

    protected boolean startPageBox(RenderBox renderBox, StyleBuilder styleBuilder) throws IOException {
        this.buildStyle(renderBox, styleBuilder);
        styleBuilder.append(BoxStyleKeys.WIDTH, this.toPointString(renderBox.getWidth()), "pt");
        AttributeList attributeList = new AttributeList();
        attributeList.setAttribute("http://www.w3.org/1999/xhtml", "style", styleBuilder.toString());
        this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", "div", attributeList, false);
        return true;
    }

    protected void finishPageBox(RenderBox renderBox) throws IOException {
        this.xmlWriter.writeCloseTag();
    }

    protected boolean startOtherBlockBox(BlockRenderBox blockRenderBox, StyleBuilder styleBuilder) throws IOException {
        this.buildStyle(blockRenderBox, styleBuilder);
        AttributeList attributeList = new AttributeList();
        if (!styleBuilder.isEmpty()) {
            attributeList.setAttribute("http://www.w3.org/1999/xhtml", "style", styleBuilder.toString());
        }
        this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", "div", attributeList, false);
        return true;
    }

    protected void finishOtherBlockBox(BlockRenderBox blockRenderBox) throws IOException {
        this.xmlWriter.writeCloseTag();
    }

    protected boolean startParagraph(ParagraphRenderBox paragraphRenderBox, StyleBuilder styleBuilder) throws IOException {
        this.buildStyle(paragraphRenderBox, styleBuilder);
        AttributeList attributeList = new AttributeList();
        if (!styleBuilder.isEmpty()) {
            attributeList.setAttribute("http://www.w3.org/1999/xhtml", "style", styleBuilder.toString());
        }
        this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", "div", attributeList, false);
        return true;
    }

    protected void finishParagraph(ParagraphRenderBox paragraphRenderBox) throws IOException {
        this.xmlWriter.writeCloseTag();
    }

    protected boolean startTableCell(TableCellRenderBox tableCellRenderBox, StyleBuilder styleBuilder) throws IOException {
        int n = tableCellRenderBox.getColSpan();
        int n2 = tableCellRenderBox.getRowSpan();
        AttributeList attributeList = new AttributeList();
        if (n != 0) {
            attributeList.setAttribute("http://www.w3.org/1999/xhtml", "colspan", String.valueOf(n));
        }
        if (n2 != 0) {
            attributeList.setAttribute("http://www.w3.org/1999/xhtml", "rowspan", String.valueOf(n2));
        }
        this.buildStyle(tableCellRenderBox, styleBuilder);
        if (!styleBuilder.isEmpty()) {
            attributeList.setAttribute("http://www.w3.org/1999/xhtml", "style", styleBuilder.toString());
        }
        this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", "td", attributeList, false);
        return true;
    }

    protected void finishTableCell(TableCellRenderBox tableCellRenderBox) throws IOException {
        this.xmlWriter.writeCloseTag();
    }

    protected boolean startTableRow(TableRowRenderBox tableRowRenderBox, StyleBuilder styleBuilder) throws IOException {
        this.buildStyle(tableRowRenderBox, styleBuilder);
        AttributeList attributeList = new AttributeList();
        if (!styleBuilder.isEmpty()) {
            attributeList.setAttribute("http://www.w3.org/1999/xhtml", "style", styleBuilder.toString());
        }
        this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", "tr", attributeList, false);
        return true;
    }

    protected void finishTableRow(TableRowRenderBox tableRowRenderBox) throws IOException {
        this.xmlWriter.writeCloseTag();
    }

    protected boolean startTableHeader(TableSectionRenderBox tableSectionRenderBox, StyleBuilder styleBuilder) throws IOException {
        this.buildStyle(tableSectionRenderBox, styleBuilder);
        AttributeList attributeList = new AttributeList();
        if (!styleBuilder.isEmpty()) {
            attributeList.setAttribute("http://www.w3.org/1999/xhtml", "style", styleBuilder.toString());
        }
        this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", "thead", attributeList, false);
        return true;
    }

    protected void finishTableHeader(TableSectionRenderBox tableSectionRenderBox) throws IOException {
        this.xmlWriter.writeCloseTag();
    }

    protected boolean startTableBody(TableSectionRenderBox tableSectionRenderBox, StyleBuilder styleBuilder) throws IOException {
        this.buildStyle(tableSectionRenderBox, styleBuilder);
        AttributeList attributeList = new AttributeList();
        if (!styleBuilder.isEmpty()) {
            attributeList.setAttribute("http://www.w3.org/1999/xhtml", "style", styleBuilder.toString());
        }
        this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", "tbody", attributeList, false);
        return true;
    }

    protected void finishTableBody(TableSectionRenderBox tableSectionRenderBox) throws IOException {
        this.xmlWriter.writeCloseTag();
    }

    protected boolean startTableFooter(TableSectionRenderBox tableSectionRenderBox, StyleBuilder styleBuilder) throws IOException {
        this.buildStyle(tableSectionRenderBox, styleBuilder);
        AttributeList attributeList = new AttributeList();
        if (!styleBuilder.isEmpty()) {
            attributeList.setAttribute("http://www.w3.org/1999/xhtml", "style", styleBuilder.toString());
        }
        this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", "tfoot", attributeList, false);
        return true;
    }

    protected void finishTableFooter(TableSectionRenderBox tableSectionRenderBox) throws IOException {
        this.xmlWriter.writeCloseTag();
    }

    protected boolean startTable(TableRenderBox tableRenderBox, StyleBuilder styleBuilder) throws IOException {
        this.buildStyle(tableRenderBox, styleBuilder);
        AttributeList attributeList = new AttributeList();
        attributeList.setAttribute("http://www.w3.org/1999/xhtml", "cellspacing", "0");
        attributeList.setAttribute("http://www.w3.org/1999/xhtml", "cellpadding", "0");
        if (!styleBuilder.isEmpty()) {
            attributeList.setAttribute("http://www.w3.org/1999/xhtml", "style", styleBuilder.toString());
        }
        this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", "table", attributeList, false);
        this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", "colgroup", false);
        TableColumnModel tableColumnModel = tableRenderBox.getColumnModel();
        int n = tableColumnModel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            long l = tableColumn.getEffectiveSize();
            StyleBuilder styleBuilder2 = new StyleBuilder(true);
            styleBuilder2.append(BoxStyleKeys.WIDTH, this.toPointString(l), "pt");
            this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", "col", "style", styleBuilder2.toString(), true);
        }
        this.xmlWriter.writeCloseTag();
        return true;
    }

    protected void finishTable(TableRenderBox tableRenderBox) throws IOException {
        this.xmlWriter.writeCloseTag();
    }

    @Override
    protected void startOtherNode(RenderNode renderNode) {
        try {
            if (renderNode instanceof RenderableText) {
                RenderableText renderableText = (RenderableText)renderNode;
                String string = renderableText.getRawText();
                String string2 = HtmlCharacterEntities.getEntityParser().encodeEntities(string);
                this.xmlWriter.writeText(string2);
            } else if (renderNode instanceof SpacerRenderNode) {
                this.xmlWriter.writeText(" ");
            } else if (renderNode instanceof RenderableReplacedContent) {
                Object object;
                RenderableReplacedContent renderableReplacedContent = (RenderableReplacedContent)renderNode;
                ResourceKey resourceKey = renderableReplacedContent.getSource();
                if (resourceKey != null && !this.knownResources.containsKey(resourceKey) && (object = this.writeRaw(resourceKey)) != null) {
                    AttributeList attributeList = new AttributeList();
                    attributeList.setAttribute("http://www.w3.org/1999/xhtml", "src", (String)object);
                    this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", "img", attributeList, true);
                    this.knownResources.put(resourceKey, object);
                    return;
                }
                object = renderableReplacedContent.getRawObject();
                if (object instanceof Image) {
                    this.xmlWriter.writeComment("Image content:" + resourceKey);
                    String string = this.writeImage((Image)object);
                    if (string != null) {
                        AttributeList attributeList = new AttributeList();
                        attributeList.setAttribute("http://www.w3.org/1999/xhtml", "src", string);
                        this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", "img", attributeList, true);
                    }
                } else if (object instanceof DrawableWrapper) {
                    this.xmlWriter.writeComment("Drawable content:" + resourceKey);
                    Image image = this.generateImage(renderNode, (DrawableWrapper)object);
                    String string = this.writeImage(image);
                    if (string != null) {
                        AttributeList attributeList = new AttributeList();
                        attributeList.setAttribute("http://www.w3.org/1999/xhtml", "src", string);
                        this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", "img", attributeList, true);
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw new StackableRuntimeException("Failed", (Exception)iOException);
        }
        catch (ContentIOException contentIOException) {
            throw new StackableRuntimeException("Failed", (Exception)((Object)contentIOException));
        }
        catch (URLRewriteException uRLRewriteException) {
            throw new StackableRuntimeException("Rewriting the URL failed", (Exception)((Object)uRLRewriteException));
        }
    }

    private String writeRaw(ResourceKey resourceKey) throws IOException {
        try {
            ContentItem contentItem;
            ResourceData resourceData = this.resourceManager.load(resourceKey);
            String string = this.queryMimeType(resourceData);
            if (this.isValidImage(string) && (contentItem = this.dataLocation.createItem(this.dataNameGenerator.generateName(this.extractFilename(resourceData), string))).isWriteable()) {
                contentItem.setAttribute("org.jfree.repository", "content-type", (Object)string);
                InputStream inputStream = resourceData.getResourceAsStream(this.resourceManager);
                OutputStream outputStream = contentItem.getOutputStream();
                IOUtils.getInstance().copyStreams(inputStream, outputStream);
                outputStream.close();
                inputStream.close();
                return this.urlRewriter.rewrite((ContentEntity)this.documentContentItem, (ContentEntity)contentItem);
            }
        }
        catch (ResourceLoadingException resourceLoadingException) {
        }
        catch (ContentIOException contentIOException) {
        }
        catch (URLRewriteException uRLRewriteException) {
            throw new StackableRuntimeException("Rewriting the URL failed.", (Exception)((Object)uRLRewriteException));
        }
        return null;
    }

    private String writeImage(Image image) throws ContentIOException, IOException, URLRewriteException {
        WaitingImageObserver waitingImageObserver = new WaitingImageObserver(image);
        waitingImageObserver.waitImageLoaded();
        PngEncoder pngEncoder = new PngEncoder(image, true, 0, 5);
        byte[] byArray = pngEncoder.pngEncode();
        ContentItem contentItem = this.dataLocation.createItem(this.dataNameGenerator.generateName("picture", "image/png"));
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(contentItem.getOutputStream());
        ((OutputStream)bufferedOutputStream).write(byArray);
        ((OutputStream)bufferedOutputStream).flush();
        ((OutputStream)bufferedOutputStream).close();
        return this.urlRewriter.rewrite((ContentEntity)this.documentContentItem, (ContentEntity)contentItem);
    }

    private Image generateImage(RenderNode renderNode, DrawableWrapper drawableWrapper) {
        int n = (int)StrictGeomUtility.toExternalValue(renderNode.getWidth());
        int n2 = (int)StrictGeomUtility.toExternalValue(renderNode.getHeight());
        if (n == 0 || n2 == 0) {
            return null;
        }
        BufferedImage bufferedImage = ImageUtils.createTransparentImage((int)((double)n * 1.3333333730697632), (int)((double)n2 * 1.3333333730697632));
        Graphics2D graphics2D = (Graphics2D)((Image)bufferedImage).getGraphics();
        graphics2D.scale(1.3333333730697632, 1.3333333730697632);
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, n, n2);
        graphics2D.clip(double_);
        drawableWrapper.draw(graphics2D, (Rectangle2D)double_);
        graphics2D.dispose();
        return bufferedImage;
    }

    private String extractFilename(ResourceData resourceData) {
        String string = (String)resourceData.getAttribute("filename");
        if (string == null) {
            return "image";
        }
        return IOUtils.getInstance().stripFileExtension(string);
    }

    private String queryMimeType(ResourceData resourceData) throws ResourceLoadingException, IOException {
        Object object = resourceData.getAttribute("content-type");
        if (object instanceof String) {
            return (String)object;
        }
        byte[] byArray = new byte[12];
        resourceData.getResource(this.resourceManager, byArray, 0L, byArray.length);
        if (this.isGIF(new ByteArrayInputStream(byArray))) {
            return "image/gif";
        }
        if (this.isJPEG(new ByteArrayInputStream(byArray))) {
            return "image/jpeg";
        }
        if (this.isPNG(new ByteArrayInputStream(byArray))) {
            return "image/png";
        }
        return null;
    }

    private boolean isPNG(ByteArrayInputStream byteArrayInputStream) {
        int[] nArray = new int[]{137, 80, 78, 71, 13, 10, 26, 10};
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == byteArrayInputStream.read()) continue;
            return false;
        }
        return true;
    }

    private boolean isJPEG(InputStream inputStream) throws IOException {
        int[] nArray = new int[]{255, 216, 255, 224};
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == inputStream.read()) continue;
            return false;
        }
        if (inputStream.read() == -1) {
            return false;
        }
        if (inputStream.read() == -1) {
            return false;
        }
        int[] nArray2 = new int[]{74, 70, 73, 70, 0};
        for (int i = 0; i < nArray2.length; ++i) {
            if (nArray2[i] == inputStream.read()) continue;
            return false;
        }
        return true;
    }

    private boolean isGIF(InputStream inputStream) throws IOException {
        int[] nArray = new int[]{71, 73, 70, 56};
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == inputStream.read()) continue;
            return false;
        }
        return true;
    }

    private boolean isValidImage(String string) {
        return this.validRawTypes.contains(string);
    }

    @Override
    protected boolean startOtherBox(RenderBox renderBox) {
        return true;
    }

    @Override
    protected void processParagraphChilds(ParagraphRenderBox paragraphRenderBox) {
        for (RenderNode renderNode = paragraphRenderBox.getFirstChild(); renderNode != null; renderNode = renderNode.getNext()) {
            this.processBoxChilds((RenderBox)renderNode);
            RenderNode renderNode2 = renderNode.getNext();
            if (renderNode2 == null) break;
            try {
                this.xmlWriter.writeText(" ");
                continue;
            }
            catch (IOException iOException) {
                throw new StackableRuntimeException("Failed", (Exception)iOException);
            }
        }
    }

    public void setDataWriter(ContentLocation contentLocation, NameGenerator nameGenerator) {
        this.dataNameGenerator = nameGenerator;
        this.dataLocation = contentLocation;
    }

    public void setContentWriter(ContentLocation contentLocation, NameGenerator nameGenerator) {
        this.contentNameGenerator = nameGenerator;
        this.contentLocation = contentLocation;
    }

    private static class ContextElement {
        private StyleBuilder builder;
        private boolean omitted;

        protected ContextElement(StyleBuilder styleBuilder) {
            this.builder = styleBuilder;
        }

        public StyleBuilder getBuilder() {
            return this.builder;
        }

        public boolean isOmitted() {
            return this.omitted;
        }

        public void setOmitted(boolean bl) {
            this.omitted = bl;
        }
    }
}

