/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.style.parser.stylehandler.line;

import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.line.LineHeight;
import org.jfree.layouting.input.style.parser.CSSValueFactory;
import org.jfree.layouting.input.style.parser.CSSValueReadHandler;
import org.jfree.layouting.input.style.values.CSSNumericType;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.w3c.css.sac.LexicalUnit;

public class LineHeightReadHandler
implements CSSValueReadHandler {
    @Override
    public CSSValue createValue(StyleKey styleKey, LexicalUnit lexicalUnit) {
        if (lexicalUnit.getLexicalUnitType() == 35) {
            if ("none".equalsIgnoreCase(lexicalUnit.getStringValue())) {
                return LineHeight.NONE;
            }
            if ("normal".equalsIgnoreCase(lexicalUnit.getStringValue())) {
                return LineHeight.NORMAL;
            }
            return null;
        }
        if (lexicalUnit.getLexicalUnitType() == 23) {
            return CSSNumericValue.createValue(CSSNumericType.PERCENTAGE, lexicalUnit.getFloatValue());
        }
        CSSNumericValue cSSNumericValue = CSSValueFactory.createNumericValue(lexicalUnit);
        if (cSSNumericValue != null) {
            return cSSNumericValue;
        }
        return CSSValueFactory.createLengthValue(lexicalUnit);
    }
}

