/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.ConfigSourceContext;
import io.smallrye.config.SecretKeysHandler;
import java.util.concurrent.atomic.AtomicReference;

public interface SecretKeysHandlerFactory {
    public SecretKeysHandler getSecretKeysHandler(ConfigSourceContext var1);

    public String getName();

    public static class LazySecretKeysHandler
    implements SecretKeysHandler {
        private final SecretKeysHandlerFactory factory;
        private final AtomicReference<SecretKeysHandler> handler = new AtomicReference();

        public LazySecretKeysHandler(SecretKeysHandlerFactory factory) {
            this.factory = factory;
        }

        public SecretKeysHandler get(ConfigSourceContext configSourceContext) {
            if (this.handler.get() == null) {
                this.handler.compareAndSet(null, this.factory.getSecretKeysHandler(configSourceContext));
            }
            return this.handler.get();
        }

        @Override
        public String decode(String secret) {
            if (this.handler.get() == null) {
                throw new IllegalStateException();
            }
            return this.handler.get().decode(secret);
        }

        @Override
        public String getName() {
            return this.factory.getName();
        }
    }
}

