/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage;

import java.io.Serializable;
import java.util.Objects;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.UserModel;

public class StorageId
implements Serializable {
    private final String providerId;
    private final String externalId;

    public StorageId(String id) {
        if (!id.startsWith("f:")) {
            this.providerId = null;
            this.externalId = id;
        } else {
            int providerIndex = id.indexOf(58, 2);
            this.providerId = id.substring(2, providerIndex);
            this.externalId = id.substring(providerIndex + 1);
        }
    }

    public StorageId(String providerId, String externalId) {
        if (providerId != null && providerId.contains(":")) {
            throw new IllegalArgumentException("Provider must not contain a colon (:) character");
        }
        this.providerId = providerId;
        this.externalId = externalId;
    }

    public boolean isLocal() {
        return this.getProviderId() == null;
    }

    public String getId() {
        return this.providerId == null ? this.externalId : "f:" + this.providerId + ":" + this.externalId;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public static String keycloakId(ComponentModel model, String externalId) {
        return new StorageId(model.getId(), externalId).getId();
    }

    public static String externalId(String keycloakId) {
        return new StorageId(keycloakId).getExternalId();
    }

    public static String providerId(String keycloakId) {
        return new StorageId(keycloakId).getProviderId();
    }

    public static boolean isLocalStorage(String id) {
        return new StorageId(id).getProviderId() == null;
    }

    public static String resolveProviderId(UserModel user) {
        return StorageId.providerId(user.getId());
    }

    public static boolean isLocalStorage(UserModel user) {
        return StorageId.isLocalStorage(user.getId());
    }

    public static String resolveProviderId(ClientModel client) {
        return StorageId.providerId(client.getId());
    }

    public static boolean isLocalStorage(ClientModel client) {
        return StorageId.isLocalStorage(client.getId());
    }

    public int hashCode() {
        return Objects.hash(this.providerId, this.externalId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StorageId other = (StorageId)obj;
        if (!Objects.equals(this.providerId, other.providerId)) {
            return false;
        }
        return Objects.equals(this.externalId, other.externalId);
    }

    public String toString() {
        return this.getId();
    }
}

