/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance.signing;

import java.security.Key;
import org.keycloak.common.VerificationException;
import org.keycloak.crypto.KeyUse;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.crypto.SignatureProvider;
import org.keycloak.crypto.SignatureVerifierContext;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.jose.jwk.JWKParser;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oid4vc.issuance.signing.VerifiableCredentialsSigningService;

public abstract class SigningService<T>
implements VerifiableCredentialsSigningService<T> {
    protected final KeycloakSession keycloakSession;
    protected final String keyId;
    protected final String type;
    protected final String format;

    protected SigningService(KeycloakSession keycloakSession, String keyId, String format, String type) {
        this.keycloakSession = keycloakSession;
        this.keyId = keyId;
        this.format = format;
        this.type = type;
    }

    @Override
    public String locator() {
        return VerifiableCredentialsSigningService.locator(this.format, null, null);
    }

    protected KeyWrapper getKey(String kid, String algorithm) {
        if (this.keyId == null) {
            return this.keycloakSession.keys().getActiveKey(this.keycloakSession.getContext().getRealm(), KeyUse.SIG, algorithm);
        }
        return this.keycloakSession.keys().getKey(this.keycloakSession.getContext().getRealm(), kid, KeyUse.SIG, algorithm);
    }

    protected SignatureVerifierContext getVerifier(JWK jwk, String jwsAlgorithm) throws VerificationException {
        SignatureProvider signatureProvider = (SignatureProvider)this.keycloakSession.getProvider(SignatureProvider.class, jwsAlgorithm);
        return signatureProvider.verifier(this.getKeyWrapper(jwk, jwsAlgorithm, KeyUse.SIG));
    }

    private KeyWrapper getKeyWrapper(JWK jwk, String algorithm, KeyUse keyUse) {
        KeyWrapper keyWrapper = new KeyWrapper();
        keyWrapper.setType(jwk.getKeyType());
        keyWrapper.setAlgorithm(algorithm);
        if (jwk.getOtherClaims().get("crv") != null) {
            keyWrapper.setCurve((String)jwk.getOtherClaims().get("crv"));
        }
        keyWrapper.setUse(keyUse);
        JWKParser parser = JWKParser.create((JWK)jwk);
        keyWrapper.setPublicKey((Key)parser.toPublicKey());
        return keyWrapper;
    }

    public void close() {
    }
}

