/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.openstreetmap.josm.data.preferences.sources.SourceEntry;
import org.openstreetmap.josm.data.preferences.sources.SourceType;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.Logging;

public class FileWatcher {
    private WatchService watcher;
    private Thread thread;
    private static final Map<SourceType, Consumer<SourceEntry>> loaderMap = new EnumMap<SourceType, Consumer<SourceEntry>>(SourceType.class);
    private final Map<Path, SourceEntry> sourceMap = new HashMap<Path, SourceEntry>();

    public static FileWatcher getDefaultInstance() {
        return InstanceHolder.INSTANCE;
    }

    public FileWatcher() {
        try {
            this.watcher = FileSystems.getDefault().newWatchService();
            this.thread = new Thread(this::processEvents, "File Watcher");
        }
        catch (IOException e) {
            Logging.error(e);
        }
    }

    public final void start() {
        if (this.thread != null && !this.thread.isAlive()) {
            this.thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSource(SourceEntry src) throws IOException {
        CheckParameterUtil.ensureParameterNotNull(src, "src");
        if (this.watcher == null) {
            throw new IllegalStateException("File watcher is not available");
        }
        File file = new File(src.url);
        File dir = file.getParentFile();
        if (dir == null) {
            throw new IllegalArgumentException("Resource " + src + " does not have a parent directory");
        }
        FileWatcher fileWatcher = this;
        synchronized (fileWatcher) {
            dir.toPath().register(this.watcher, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE);
            this.sourceMap.put(file.toPath(), src);
        }
    }

    public static Consumer<SourceEntry> registerLoader(SourceType type, Consumer<SourceEntry> loader) {
        return loaderMap.put(Objects.requireNonNull(type, "type"), Objects.requireNonNull(loader, "loader"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEvents() {
        WatchKey key;
        Logging.debug("File watcher thread started");
        do {
            try {
                key = this.watcher.take();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                return;
            }
            for (WatchEvent<?> event : key.pollEvents()) {
                Path fullPath;
                WatchEvent.Kind<?> kind;
                block15: {
                    WatchEvent<?> ev;
                    Path filename;
                    kind = event.kind();
                    if (StandardWatchEventKinds.OVERFLOW.equals(kind) || (filename = (Path)(ev = event).context()) == null) continue;
                    fullPath = ((Path)key.watchable()).resolve(filename);
                    try {
                        if (Files.size(fullPath) == 0L) {
                        }
                        break block15;
                    }
                    catch (IOException ex) {
                        Logging.trace(ex);
                    }
                    continue;
                }
                FileWatcher fileWatcher = this;
                synchronized (fileWatcher) {
                    SourceEntry source = this.sourceMap.get(fullPath);
                    if (source != null) {
                        Consumer<SourceEntry> loader = loaderMap.get((Object)source.type);
                        if (loader != null) {
                            Logging.info("Source " + source.getDisplayString() + " has been modified. Reloading it...");
                            loader.accept(source);
                        } else {
                            Logging.warn("Received {0} event for unregistered source type: {1}", new Object[]{kind.name(), source.type});
                        }
                    } else if (Logging.isDebugEnabled()) {
                        Logging.debug("Received {0} event for unregistered file: {1}", kind.name(), fullPath);
                    }
                }
            }
        } while (key.reset());
    }

    private static class InstanceHolder {
        static final FileWatcher INSTANCE = new FileWatcher();

        private InstanceHolder() {
        }
    }
}

