/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.utils.fileswatcher;

import jadx.core.utils.Utils;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesWatcher {
    private static final Logger LOG = LoggerFactory.getLogger(FilesWatcher.class);
    private final WatchService watcher = FileSystems.getDefault().newWatchService();
    private final Map<WatchKey, Path> keys = new HashMap<WatchKey, Path>();
    private final Map<Path, Set<Path>> files = new HashMap<Path, Set<Path>>();
    private final AtomicBoolean cancel = new AtomicBoolean(false);
    private final BiConsumer<Path, WatchEvent.Kind<Path>> listener;

    public FilesWatcher(List<Path> paths, BiConsumer<Path, WatchEvent.Kind<Path>> listener) throws IOException {
        this.listener = listener;
        for (Path path : paths) {
            if (Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS)) {
                this.registerDirs(path);
                continue;
            }
            Path parentDir = path.toAbsolutePath().getParent();
            this.register(parentDir);
            this.files.merge(parentDir, Collections.singleton(path), Utils::mergeSets);
        }
    }

    public void cancel() {
        this.cancel.set(true);
    }

    public void watch() {
        this.cancel.set(false);
        LOG.debug("File watcher started for {} dirs", (Object)this.keys.size());
        while (!this.cancel.get()) {
            WatchKey key;
            try {
                key = this.watcher.take();
            }
            catch (InterruptedException e) {
                LOG.debug("File watcher interrupted");
                return;
            }
            Path dir = this.keys.get(key);
            if (dir == null) {
                LOG.warn("Unknown directory key: {}", (Object)key);
                continue;
            }
            for (WatchEvent<?> event : key.pollEvents()) {
                if (this.cancel.get() || Thread.interrupted()) {
                    return;
                }
                WatchEvent.Kind<?> kind = event.kind();
                if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                Path fileName = (Path)event.context();
                Path path = dir.resolve(fileName);
                Set<Path> files = this.files.get(dir);
                if (files == null || files.contains(path)) {
                    this.listener.accept(path, kind);
                }
                if (kind != StandardWatchEventKinds.ENTRY_CREATE) continue;
                try {
                    if (!Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS)) continue;
                    this.registerDirs(path);
                }
                catch (Exception e) {
                    LOG.warn("Failed to update directory watch: {}", (Object)path, (Object)e);
                }
            }
            boolean valid = key.reset();
            if (valid) continue;
            this.keys.remove(key);
            if (!this.keys.isEmpty()) continue;
            LOG.debug("File watcher stopped: all watch keys removed");
            return;
        }
    }

    private void registerDirs(Path start) throws IOException {
        Files.walkFileTree(start, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                FilesWatcher.this.register(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private void register(Path dir) throws IOException {
        WatchKey key = dir.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        this.keys.put(key, dir);
    }
}

