/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal.configurations.renderer;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.diagnostics.internal.configurations.model.ConfigurationReportModel;
import org.gradle.api.tasks.diagnostics.internal.configurations.model.ReportArtifact;
import org.gradle.api.tasks.diagnostics.internal.configurations.model.ReportAttribute;
import org.gradle.api.tasks.diagnostics.internal.configurations.model.ReportCapability;
import org.gradle.api.tasks.diagnostics.internal.configurations.model.ReportConfiguration;
import org.gradle.api.tasks.diagnostics.internal.configurations.model.ReportSecondaryVariant;
import org.gradle.api.tasks.diagnostics.internal.configurations.renderer.AbstractConfigurationReportRenderer;
import org.gradle.api.tasks.diagnostics.internal.configurations.spec.AbstractConfigurationReportSpec;
import org.gradle.internal.logging.text.StyledTextOutput;

public final class ConsoleConfigurationReportRenderer
extends AbstractConfigurationReportRenderer<StyledTextOutput> {
    @Nullable
    private StyledTextOutput output;
    private int depth;
    private boolean recursiveExtensionsPrinted;

    public ConsoleConfigurationReportRenderer(AbstractConfigurationReportSpec spec) {
        super(spec);
    }

    public void render(ConfigurationReportModel data, StyledTextOutput output) {
        this.depth = 0;
        this.output = output;
        this.recursiveExtensionsPrinted = false;
        boolean hasAnyRelevantConfigs = data.getAllConfigs().stream().anyMatch(c -> this.spec.isPurelyCorrectType((ReportConfiguration)c) || c.isLegacy());
        if (hasAnyRelevantConfigs) {
            if (this.spec.isSearchForSpecificVariant()) {
                this.writeSearchResults(data);
            } else if (this.spec.isShowLegacy()) {
                this.writeLegacyResults(data);
            } else {
                this.writeNonLegacyResults(data);
            }
        } else {
            this.writeCompleteAbsenceOfResults(data);
        }
    }

    private void writeCompleteAbsenceOfResults(ConfigurationReportModel data) {
        this.message("There are no " + this.spec.getFullReportedTypeDesc() + "s (including legacy " + this.spec.getReportedTypeAlias() + "s) present in project '" + data.getProjectName() + "'.");
    }

    private void writeSearchResults(ConfigurationReportModel data) {
        Optional<ReportConfiguration> searchResult = data.getConfigNamed(this.spec.getSearchTarget().get());
        if (searchResult.isPresent()) {
            this.writeResults(data, Collections.singletonList(searchResult.get()));
        } else {
            this.message("There are no " + this.spec.getFullReportedTypeDesc() + "s on project '" + data.getProjectName() + "' named '" + this.spec.getSearchTarget().get() + "'.");
        }
    }

    private void writeLegacyResults(ConfigurationReportModel data) {
        List<ReportConfiguration> legacyConfigs = data.getAllConfigs().stream().filter(c -> c.isLegacy() || this.spec.isPurelyCorrectType((ReportConfiguration)c)).collect(Collectors.toList());
        this.writeResults(data, legacyConfigs);
    }

    private void writeNonLegacyResults(ConfigurationReportModel data) {
        List<ReportConfiguration> nonLegacyConfigs = data.getAllConfigs().stream().filter(this.spec::isPurelyCorrectType).collect(Collectors.toList());
        if (nonLegacyConfigs.isEmpty()) {
            this.message("There are no purely " + this.spec.getReportedConfigurationDirection() + " " + this.spec.getReportedTypeAlias() + "s present in project '" + data.getProjectName() + "'.");
            boolean hasLegacyConfigs = data.getAllConfigs().stream().anyMatch(ReportConfiguration::isLegacy);
            if (hasLegacyConfigs) {
                this.message("Re-run this report with the '--all' flag to include legacy " + this.spec.getReportedTypeAlias() + "s (legacy = consumable and resolvable).");
            }
        } else {
            this.writeResults(data, nonLegacyConfigs);
        }
    }

    private void writeResults(ConfigurationReportModel data, List<ReportConfiguration> configs) {
        this.writeConfigurations(configs);
        if (this.spec.isIncludeRuleSchema()) {
            this.writeRuleSchema(data.getAttributesWithCompatibilityRules(), data.getAttributesWithDisambiguationRules());
        }
        this.writeLegend(configs);
    }

    private void writeConfigurations(List<ReportConfiguration> configurations) {
        configurations.forEach(this::writeConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRuleSchema(List<ReportAttribute> attributesWithCompatibilityRules, List<ReportAttribute> attributesWithDisambiguationRules) {
        Integer maxC = attributesWithCompatibilityRules.stream().map(attr -> attr.getName().length()).max(Integer::compare).orElse(0);
        if (!attributesWithCompatibilityRules.isEmpty()) {
            this.printHeader(() -> this.message("Compatibility Rules"));
            this.writeDescription("The following Attributes have compatibility rules defined.");
            this.newLine();
            try {
                ++this.depth;
                attributesWithCompatibilityRules.forEach(a -> this.writeAttribute(maxC, (ReportAttribute)a, false));
                this.newLine();
            }
            finally {
                --this.depth;
            }
        }
        Integer maxD = attributesWithDisambiguationRules.stream().map(attr -> attr.getName().length()).max(Integer::compare).orElse(0);
        if (!attributesWithDisambiguationRules.isEmpty()) {
            this.printHeader(() -> this.message("Disambiguation Rules"));
            this.writeDescription("The following Attributes have disambiguation rules defined.");
            this.newLine();
            try {
                ++this.depth;
                attributesWithDisambiguationRules.forEach(a -> this.writeAttribute(maxD, (ReportAttribute)a, this.spec.isShowAttributePrecedence()));
                this.newLine();
            }
            finally {
                --this.depth;
            }
            if (this.spec.isShowAttributePrecedence()) {
                this.writeDescription("(#): Attribute disambiguation precedence");
                this.newLine();
            }
        }
    }

    private void writeLegend(List<ReportConfiguration> configs) {
        boolean hasLegacy = configs.stream().anyMatch(ReportConfiguration::isLegacy);
        boolean hasIncubating = configs.stream().anyMatch(ReportConfiguration::hasIncubatingAttributes) || configs.stream().flatMap(c -> c.getSecondaryVariants().stream()).anyMatch(ReportSecondaryVariant::hasIncubatingAttributes);
        boolean hasVariants = configs.stream().anyMatch(ReportConfiguration::hasVariants);
        this.output.style(StyledTextOutput.Style.Info);
        if (hasLegacy) {
            this.output.println((Object)"(l) Legacy or deprecated configuration. Those are variants created for backwards compatibility which are both resolvable and consumable.");
        }
        if (hasIncubating) {
            this.output.text((Object)"(i) Configuration uses incubating attributes such as ");
            this.output.withStyle(StyledTextOutput.Style.Identifier).text((Object)"Category.VERIFICATION");
            this.output.println((Object)".");
        }
        if (this.recursiveExtensionsPrinted) {
            this.output.println((Object)"(t) Configuration extended transitively.");
        }
        if (hasVariants) {
            this.output.text((Object)"(*) Secondary variants are variants created via the ");
            this.output.withStyle(StyledTextOutput.Style.Identifier).text((Object)"Configuration#getOutgoing(): ConfigurationPublications");
            this.output.println((Object)" API which also participate in selection, in addition to the configuration itself.");
        }
    }

    private void writeConfiguration(ReportConfiguration config) {
        this.writeConfigurationNameHeader(config, this.spec.getReportedTypeAlias());
        this.writeDescription(config.getDescription());
        this.writeErrors(config.getLenientErrors());
        if (!config.getAttributes().isEmpty() || this.spec.isIncludeCapabilities() && !config.getCapabilities().isEmpty() || this.spec.isIncludeArtifacts() && !config.getArtifacts().isEmpty() || this.spec.isIncludeExtensions() && !config.getExtendedConfigurations().isEmpty() || this.spec.isIncludeVariants() && !config.getSecondaryVariants().isEmpty()) {
            this.newLine();
        }
        if (this.spec.isIncludeCapabilities()) {
            this.writeCapabilities(config.getCapabilities());
        }
        this.writeAttributes(config.getAttributes());
        if (this.spec.isIncludeArtifacts()) {
            this.writeArtifacts(config.getArtifacts());
        }
        if (this.spec.isIncludeExtensions()) {
            this.writeExtensions(config.getExtendedConfigurations(), this.spec.isIncludeExtensionsRecursively());
        }
        if (this.spec.isIncludeVariants()) {
            this.writeSecondaryVariants(config.getSecondaryVariants());
        }
        this.newLine();
    }

    private void writeConfigurationNameHeader(ReportConfiguration config, String targetName) {
        this.printHeader(() -> {
            this.output.style(StyledTextOutput.Style.Normal).text((Object)(StringUtils.capitalize((String)targetName) + " "));
            this.output.style(StyledTextOutput.Style.Header).text((Object)config.getName());
            this.output.style(StyledTextOutput.Style.Info).println((Object)this.buildIndicators(config));
        });
    }

    private void writeDescription(String description) {
        this.indent(false);
        if (description != null) {
            this.output.style(StyledTextOutput.Style.Normal).println((Object)description);
        }
    }

    private void writeErrors(List<? extends GradleException> lenientErrors) {
        if (!lenientErrors.isEmpty()) {
            this.indent(false);
            lenientErrors.forEach(ex -> this.output.style(StyledTextOutput.Style.Failure).println((Object)ex.getMessage()));
        }
    }

    private String buildIndicators(ReportConfiguration config) {
        String indicators = "";
        if (config.isLegacy()) {
            indicators = indicators + " (l)";
        }
        if (config.hasIncubatingAttributes()) {
            indicators = indicators + " (i)";
        }
        return indicators;
    }

    private void writeExtensions(List<ReportConfiguration> extensions, boolean recursive) {
        class FormattedExtension {
            final String name;
            final boolean isTransitive;

            public FormattedExtension(String name, boolean isTransitive) {
                this.name = name;
                this.isTransitive = isTransitive;
            }
        }
        List extensionsToPrint = extensions.stream().map(e -> new FormattedExtension(e.getName(), false)).collect(Collectors.toList());
        if (recursive) {
            int nonRecursiveCount = extensionsToPrint.size();
            extensionsToPrint.addAll(extensions.stream().flatMap(e -> e.getExtendedConfigurations().stream()).filter(e -> extensionsToPrint.stream().noneMatch(eToP -> eToP.name.equals(e.getName()))).map(e -> new FormattedExtension(e.getName(), true)).collect(Collectors.toList()));
            if (nonRecursiveCount != extensionsToPrint.size()) {
                this.recursiveExtensionsPrinted = true;
            }
        }
        if (!extensions.isEmpty()) {
            this.printSection("Extended Configurations", () -> extensionsToPrint.stream().sorted(Comparator.comparing(e -> e.name)).forEach(e -> {
                this.indent(true);
                this.output.withStyle(StyledTextOutput.Style.Identifier).text((Object)e.name);
                if (e.isTransitive) {
                    this.output.withStyle(StyledTextOutput.Style.Info).println((Object)" (t)");
                } else {
                    this.newLine();
                }
            }));
        }
    }

    private void writeSecondaryVariants(List<ReportSecondaryVariant> variants) {
        if (!variants.isEmpty()) {
            this.newLine();
            this.printSection("Secondary Variants (*)", () -> variants.forEach(variant -> {
                this.newLine();
                this.writeSecondaryVariant((ReportSecondaryVariant)variant);
            }));
        }
    }

    private void writeAttributes(List<ReportAttribute> attributes) {
        if (!attributes.isEmpty()) {
            Integer max = attributes.stream().map(attr -> attr.getName().length()).max(Integer::compare).orElse(0);
            this.printSection("Attributes", () -> attributes.forEach(attr -> this.writeAttribute(max, (ReportAttribute)attr, false)));
        }
    }

    private void writeAttribute(Integer max, ReportAttribute attr, boolean includePrecedence) {
        this.indent(true);
        if (attr.getValue().isPresent()) {
            this.valuePair(StringUtils.rightPad((String)attr.getName(), (int)max), String.valueOf(attr.getValue().orElse("")));
        } else {
            this.output.style(StyledTextOutput.Style.Identifier).text((Object)attr.getName());
            if (includePrecedence && attr.getDisambiguationPrecedence() != null) {
                this.output.text((Object)(" (" + attr.getDisambiguationPrecedence() + ")"));
            }
        }
        this.newLine();
    }

    private void writeArtifacts(List<ReportArtifact> artifacts) {
        if (!artifacts.isEmpty()) {
            this.printSection("Artifacts", () -> artifacts.forEach(art -> {
                this.indent(true);
                this.writeArtifact((ReportArtifact)art);
                this.newLine();
            }));
        }
    }

    private void writeArtifact(ReportArtifact artifact) {
        String type = artifact.getType();
        String classifier = artifact.getClassifier();
        this.output.style(StyledTextOutput.Style.Normal).text((Object)artifact.getDisplayName());
        if (StringUtils.isNotEmpty((String)type)) {
            this.output.text((Object)" (");
            this.output.withStyle(StyledTextOutput.Style.Description).text((Object)"artifactType");
            this.output.text((Object)" = ");
            this.output.withStyle(StyledTextOutput.Style.Identifier).text((Object)type);
            if (StringUtils.isNotEmpty((String)classifier)) {
                this.output.text((Object)", ");
                this.output.withStyle(StyledTextOutput.Style.Description).text((Object)"classifier");
                this.output.text((Object)" = ");
                this.output.withStyle(StyledTextOutput.Style.Identifier).text((Object)classifier);
            }
            this.output.text((Object)")");
        }
    }

    private void writeCapabilities(List<ReportCapability> capabilities) {
        if (!capabilities.isEmpty()) {
            this.printSection("Capabilities", () -> {
                class FormattedCapability {
                    final String gav;
                    final boolean isDefault;

                    public FormattedCapability(String name, boolean isDefault) {
                        this.gav = name;
                        this.isDefault = isDefault;
                    }
                }
                capabilities.stream().map(cap -> new FormattedCapability(cap.toGAV(), cap.isDefault())).forEach(cap -> {
                    this.indent(true);
                    this.output.style(StyledTextOutput.Style.Identifier).text((Object)cap.gav);
                    if (cap.isDefault) {
                        this.output.style(StyledTextOutput.Style.Normal).text((Object)" (default capability)");
                    }
                    this.newLine();
                });
            });
        }
    }

    private String buildIndicators(ReportSecondaryVariant config) {
        String indicators = "";
        if (config.hasIncubatingAttributes()) {
            indicators = indicators + " (i)";
        }
        return indicators;
    }

    private void writeSecondaryVariant(ReportSecondaryVariant variant) {
        this.printHeader(() -> {
            this.output.style(StyledTextOutput.Style.Normal).text((Object)"Secondary Variant ");
            this.output.withStyle(StyledTextOutput.Style.Header).text((Object)variant.getName());
            this.output.println((Object)this.buildIndicators(variant));
        });
        this.writeDescription(variant.getDescription());
        if (!variant.getAttributes().isEmpty() || !variant.getArtifacts().isEmpty()) {
            this.newLine();
        }
        this.writeAttributes(variant.getAttributes());
        this.writeArtifacts(variant.getArtifacts());
    }

    private void printHeader(Runnable action) {
        this.output.style(StyledTextOutput.Style.Header);
        this.indent(false);
        this.output.println((Object)"--------------------------------------------------");
        this.indent(false);
        action.run();
        this.output.style(StyledTextOutput.Style.Header);
        this.indent(false);
        this.output.println((Object)"--------------------------------------------------");
        this.output.style(StyledTextOutput.Style.Normal);
    }

    private void printSection(String title, Runnable action) {
        this.printSection(title, null, action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printSection(String title, @Nullable String description, Runnable action) {
        this.indent(false);
        this.output.style(StyledTextOutput.Style.Description).text((Object)title);
        this.output.style(StyledTextOutput.Style.Normal);
        if (description != null) {
            this.output.text((Object)(" : " + description));
        }
        try {
            ++this.depth;
            this.newLine();
            action.run();
        }
        finally {
            --this.depth;
        }
    }

    private void valuePair(String key, String value) {
        this.output.style(StyledTextOutput.Style.Identifier).text((Object)key);
        this.output.style(StyledTextOutput.Style.Normal).text((Object)(" = " + value));
    }

    private void indent(boolean bullet) {
        this.output.text((Object)StringUtils.repeat((String)"    ", (int)this.depth));
        if (this.depth > 0 && bullet) {
            this.output.withStyle(StyledTextOutput.Style.Normal).text((Object)"- ");
        }
    }

    private void message(String msg) {
        this.output.text((Object)msg).println();
    }

    private void newLine() {
        this.output.println();
    }
}

