/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.xml;

import java.io.Reader;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLMapper;

public class XmlBaseParsers {
    private static final XmlBaseParsers INSTANCE = new XmlBaseParsers();
    private static final XMLInputFactory inputFactory;
    private final XMLMapper mapper = XMLMapper.Factory.create();

    public static XmlBaseParsers getInstance() {
        return INSTANCE;
    }

    public static void parse(Reader reader, Object builder) throws XMLStreamException {
        INSTANCE.doParse(reader, builder);
    }

    private static void setIfSupported(XMLInputFactory inputFactory, String property, Object value) {
        if (inputFactory.isPropertySupported(property)) {
            inputFactory.setProperty(property, value);
        }
    }

    public static XMLStreamReader createXMLStreamReader(Reader reader) throws XMLStreamException {
        return inputFactory.createXMLStreamReader(reader);
    }

    protected XmlBaseParsers() {
    }

    public void plugin(QName root, XMLElementReader<?> reader) {
        this.mapper.registerRootElement(root, reader);
    }

    public void doParse(Reader reader, Object builder) throws XMLStreamException {
        this.mapper.parseDocument(builder, inputFactory.createXMLStreamReader(reader));
    }

    static {
        XMLInputFactory tmpIF = XMLInputFactory.newInstance();
        XmlBaseParsers.setIfSupported(tmpIF, "javax.xml.stream.isValidating", Boolean.FALSE);
        XmlBaseParsers.setIfSupported(tmpIF, "javax.xml.stream.supportDTD", Boolean.FALSE);
        inputFactory = tmpIF;
    }
}

