/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.dao;

import ca.sqlpower.dao.SPPersistenceException;
import ca.sqlpower.dao.SPPersister;
import ca.sqlpower.dao.upgrade.UpgradePersisterManager;
import ca.sqlpower.util.SQLPowerUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Stack;
import javax.swing.ProgressMonitor;
import org.apache.commons.codec.binary.Base64;

public class XMLPersister
implements SPPersister {
    public final String PROJECT_TAG;
    private static UpgradePersisterManager upgradePersisterManager;
    private final Stack<String> currentObject = new Stack();
    private final Stack<String> currentType = new Stack();
    private final PrintWriter out;
    private final ByteArrayOutputStream bufferedOut = new ByteArrayOutputStream();
    private final String rootObject;
    private int transactionCount = 0;
    private final OutputStream finalOut;
    private final ProgressMonitor pm;
    private int progress = 0;

    public static void setUpgradePersisterManager(UpgradePersisterManager upgradePersisterManager) {
        XMLPersister.upgradePersisterManager = upgradePersisterManager;
    }

    public XMLPersister(OutputStream out, String rootObject, String projectTag) {
        this(out, rootObject, projectTag, null);
    }

    public XMLPersister(OutputStream out, String rootObject, String projectTag, ProgressMonitor pm) {
        this.out = new PrintWriter(this.bufferedOut);
        this.finalOut = out;
        this.rootObject = rootObject;
        this.pm = pm;
        this.PROJECT_TAG = projectTag;
    }

    @Override
    public void begin() throws SPPersistenceException {
        if (this.transactionCount == 0) {
            this.out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            this.out.println("<" + this.PROJECT_TAG + " file-version=\"" + upgradePersisterManager.getStateVersion() + "\">");
        }
        ++this.transactionCount;
    }

    @Override
    public void commit() throws SPPersistenceException {
        --this.transactionCount;
        if (this.transactionCount == 0) {
            while (!this.currentType.isEmpty()) {
                this.currentObject.pop();
                this.out.println(this.tab() + "</" + this.currentType.pop().replace("$", "..") + ">");
            }
            this.out.println("</" + this.PROJECT_TAG + ">");
            this.out.flush();
            try {
                byte[] byteArray = this.bufferedOut.toByteArray();
                if (this.pm != null) {
                    this.pm.setMaximum(byteArray.length);
                }
                for (int i = 0; i < byteArray.length; ++i) {
                    this.finalOut.write(byteArray[i]);
                    if (this.pm == null) continue;
                    this.pm.setProgress(++this.progress);
                }
                this.finalOut.flush();
            }
            catch (IOException e) {
                throw new SPPersistenceException(null, e);
            }
        }
    }

    @Override
    public void persistObject(String parentUUID, String type, String uuid, int index) throws SPPersistenceException {
        if (uuid == null) {
            uuid = "";
        }
        if (parentUUID == null) {
            parentUUID = "";
        }
        while (!this.currentObject.isEmpty() && !parentUUID.equals(this.currentObject.peek())) {
            this.currentObject.pop();
            this.out.println(this.tab() + "</" + this.currentType.pop().replace("$", "..") + ">");
        }
        if (this.currentObject.isEmpty()) {
            if (!type.equals(this.rootObject)) {
                throw new SPPersistenceException(null, "This persister does not support incremental updates. The first object persisted must be the root.");
            }
        } else if (!parentUUID.equals(this.currentObject.peek())) {
            throw new SPPersistenceException(null, "This persister requires persists to be ordered. An object at [" + uuid + "] as a child of [" + parentUUID + "] was persisted while the current object was [" + this.currentObject.peek() + "]");
        }
        this.out.println(this.tab() + "<" + type.replace("$", "..") + " UUID=\"" + SQLPowerUtils.escapeXML(uuid) + "\" index=\"" + index + "\">");
        this.currentObject.push(uuid);
        this.currentType.push(type);
    }

    @Override
    public void persistProperty(String uuid, String propertyName, SPPersister.DataType propertyType, Object oldValue, Object newValue) throws SPPersistenceException {
        throw new UnsupportedOperationException("This persister does not support incremental updates. Use the unconditional persistProperty instead");
    }

    @Override
    public void persistProperty(String uuid, String propertyName, SPPersister.DataType propertyType, Object newValue) throws SPPersistenceException {
        if (uuid == null) {
            uuid = "";
        }
        if (this.currentObject.isEmpty()) {
            throw new SPPersistenceException("Recieved property for object [" + uuid + "] which does not exist");
        }
        if (!uuid.equals(this.currentObject.peek())) {
            throw new SPPersistenceException(null, "This persister requires persists to be ordered. An property of [" + uuid + "] was persisted while the current object was [" + this.currentObject.peek() + "]");
        }
        if (propertyType != SPPersister.DataType.NULL && newValue != null) {
            this.out.print(this.tab() + "<property name=\"" + SQLPowerUtils.escapeNewLines(SQLPowerUtils.escapeXML(propertyName)) + "\" type=\"" + propertyType.toString() + "\"");
            if (propertyType == SPPersister.DataType.PNG_IMG) {
                try {
                    this.out.print(" value=\"");
                    ByteArrayOutputStream data = new ByteArrayOutputStream();
                    SQLPowerUtils.copyStream((InputStream)newValue, data);
                    byte[] bytes = data.toByteArray();
                    byte[] base64Bytes = Base64.encodeBase64((byte[])bytes);
                    this.out.print(new String(base64Bytes));
                    this.out.println("\"/>");
                }
                catch (IOException e) {
                    throw new SPPersistenceException(uuid, e);
                }
            } else {
                this.out.println(" value=\"" + SQLPowerUtils.escapeXML(newValue.toString()) + "\"/>");
            }
        }
    }

    @Override
    public void removeObject(String parentUUID, String uuid) throws SPPersistenceException {
        throw new UnsupportedOperationException("This persister does not support incremental updates");
    }

    @Override
    public void rollback() {
    }

    private String tab() {
        StringBuilder tab = new StringBuilder();
        for (int i = 0; i <= this.currentObject.size(); ++i) {
            tab.append(" ");
        }
        return tab.toString();
    }
}

