/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.table;

import ca.sqlpower.architect.profile.ColumnProfileResult;
import ca.sqlpower.architect.profile.TableProfileResult;
import ca.sqlpower.swingui.table.TableModelWrapper;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class TableFilterDecorator
extends AbstractTableModel
implements TableModelWrapper {
    private TableModel wrappedModel;
    private TableProfileResult filter;
    private TableModelListener handler = new TableModelListener(){

        @Override
        public void tableChanged(TableModelEvent e) {
            TableFilterDecorator.this.fireTableChanged(e);
        }
    };

    public TableFilterDecorator(TableModel wrappedModel) {
        this.wrappedModel = wrappedModel;
        wrappedModel.addTableModelListener(this.handler);
    }

    public TableModel getWrappedModel() {
        return this.wrappedModel;
    }

    public void setWrappedModel(TableModel model) {
        this.wrappedModel.removeTableModelListener(this.handler);
        this.wrappedModel = model;
        model.addTableModelListener(this.handler);
    }

    public void setFilter(TableProfileResult filter) {
        this.filter = filter;
        this.fireTableChanged(new TableModelEvent(this));
    }

    @Override
    public int getColumnCount() {
        return this.wrappedModel.getColumnCount();
    }

    @Override
    public int getRowCount() {
        if (this.filter == null) {
            return this.wrappedModel.getRowCount();
        }
        int count = 0;
        for (int i = 0; i < this.wrappedModel.getRowCount(); ++i) {
            ColumnProfileResult cpr = (ColumnProfileResult)this.wrappedModel.getValueAt(i, -1);
            if (!this.filter.equals(cpr.getParent())) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.filter == null) {
            return this.wrappedModel.getValueAt(rowIndex, columnIndex);
        }
        int count = 0;
        int i = -1;
        while (i < rowIndex) {
            ColumnProfileResult cpr = (ColumnProfileResult)this.wrappedModel.getValueAt(count, -1);
            if (this.filter.equals(cpr.getParent())) {
                ++i;
            }
            ++count;
        }
        return this.wrappedModel.getValueAt(count - 1, columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.wrappedModel.isCellEditable(rowIndex, columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.wrappedModel.setValueAt(aValue, rowIndex, columnIndex);
    }

    @Override
    public String getColumnName(int column) {
        return this.wrappedModel.getColumnName(column);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.wrappedModel.getColumnClass(columnIndex);
    }
}

