/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.stack.congestioncontrol;

import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.RemoteEndpoint;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.core.network.stack.CongestionControlLayer;

public class PeakhopperRto
extends CongestionControlLayer {
    private int currentRtt = 0;

    public PeakhopperRto(NetworkConfig config) {
        super(config);
    }

    public void storeRttValue(RemoteEndpoint endpoint, long rtt) {
        endpoint.RTT_sample[this.currentRtt] = rtt;
        this.currentRtt = (this.currentRtt + 1) % 2;
    }

    public long getMaxRtt(RemoteEndpoint endpoint) {
        return endpoint.RTT_sample[0] > endpoint.RTT_sample[1] ? endpoint.RTT_sample[0] : endpoint.RTT_sample[1];
    }

    @Override
    public void initializeRTOEstimators(long measuredRTT, int estimatorType, RemoteEndpoint endpoint) {
        this.storeRttValue(endpoint, measuredRTT);
        long newRTO = (long)(1.75 * (double)measuredRTT);
        endpoint.updateRTO(newRTO);
    }

    @Override
    protected void updateEstimator(long measuredRTT, int estimatorType, RemoteEndpoint endpoint) {
        this.storeRttValue(endpoint, measuredRTT);
        endpoint.delta = Math.abs((double)(measuredRTT - endpoint.RTT_previous) / (double)measuredRTT);
        endpoint.B_value = Math.min(Math.max(endpoint.delta * 2.0, 0.9583333333333334 * endpoint.B_value), 1.0);
        endpoint.RTT_max = Math.max(measuredRTT, endpoint.RTT_previous);
        endpoint.RTO_min = this.getMaxRtt(endpoint) + 100L;
        long newRTO = (long)Math.max(0.9583333333333334 * (double)endpoint.getRTO(), (1.0 + endpoint.B_value) * (double)endpoint.RTT_max);
        newRTO = Math.max(Math.max(newRTO, endpoint.RTT_max + 100L), endpoint.RTO_min);
        endpoint.printPeakhopperStats();
        endpoint.RTT_previous = measuredRTT;
        endpoint.updateRTO(newRTO);
    }

    @Override
    public void processRTTmeasurement(long measuredRTT, Exchange exchange, int retransmissionCount) {
        RemoteEndpoint endpoint = this.getRemoteEndpoint(exchange);
        int rtoType = endpoint.getExchangeEstimatorState(exchange);
        if (rtoType == 3 || rtoType == 2) {
            return;
        }
        endpoint.matchCurrentRTO();
        if (endpoint.isBlindStrong() && rtoType == 1) {
            endpoint.setBlindStrong(false);
            this.initializeRTOEstimators(measuredRTT, rtoType, endpoint);
        } else {
            this.updateEstimator(measuredRTT, rtoType, endpoint);
        }
    }
}

