/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.serialization;

import org.eclipse.californium.core.coap.Message;
import org.eclipse.californium.core.network.serialization.DataSerializer;
import org.eclipse.californium.core.network.serialization.MessageHeader;
import org.eclipse.californium.elements.util.DatagramWriter;

public final class UdpDataSerializer
extends DataSerializer {
    @Override
    protected void serializeMessage(DatagramWriter writer, Message message) {
        MessageHeader header = new MessageHeader(1, message.getType(), message.getToken(), message.getRawCode(), message.getMID(), -1);
        this.serializeHeader(writer, header);
        writer.writeCurrentByte();
        UdpDataSerializer.serializeOptionsAndPayload(writer, message.getOptions(), message.getPayload());
    }

    @Override
    protected void serializeHeader(DatagramWriter writer, MessageHeader header) {
        writer.write(1, 2);
        writer.write(header.getType().value, 2);
        writer.write(header.getToken().length(), 4);
        writer.write(header.getCode(), 8);
        writer.write(header.getMID(), 16);
        writer.writeBytes(header.getToken().getBytes());
    }
}

