/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.logging.json.runtime;

import io.quarkus.logging.json.runtime.AdditionalFieldConfig;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.formatters.StructuredFormatter;

public class JsonFormatter
extends org.jboss.logmanager.formatters.JsonFormatter {
    private Set<String> excludedKeys;
    private Map<String, AdditionalFieldConfig> additionalFields;

    public JsonFormatter() {
        this.excludedKeys = new HashSet<String>();
        this.additionalFields = new HashMap<String, AdditionalFieldConfig>();
    }

    public JsonFormatter(String keyOverrides) {
        super(keyOverrides);
        this.excludedKeys = new HashSet<String>();
        this.additionalFields = new HashMap<String, AdditionalFieldConfig>();
    }

    public JsonFormatter(String keyOverrides, Set<String> excludedKeys, Map<String, AdditionalFieldConfig> additionalFields) {
        super(keyOverrides);
        this.excludedKeys = excludedKeys;
        this.additionalFields = additionalFields;
    }

    public Set<String> getExcludedKeys() {
        return this.excludedKeys;
    }

    public void setExcludedKeys(Set<String> excludedKeys) {
        this.excludedKeys = excludedKeys;
    }

    public Map<String, AdditionalFieldConfig> getAdditionalFields() {
        return this.additionalFields;
    }

    public void setAdditionalFields(Map<String, AdditionalFieldConfig> additionalFields) {
        this.additionalFields = additionalFields;
    }

    protected StructuredFormatter.Generator createGenerator(Writer writer) {
        StructuredFormatter.Generator superGenerator = super.createGenerator(writer);
        return new FormatterJsonGenerator(superGenerator, this.excludedKeys);
    }

    protected void after(StructuredFormatter.Generator generator, ExtLogRecord record) throws Exception {
        for (Map.Entry<String, AdditionalFieldConfig> entry : this.additionalFields.entrySet()) {
            switch (entry.getValue().type) {
                case STRING: {
                    generator.add(entry.getKey(), entry.getValue().value);
                    break;
                }
                case INT: {
                    generator.add(entry.getKey(), Integer.valueOf(entry.getValue().value).intValue());
                    break;
                }
                case LONG: {
                    generator.add(entry.getKey(), Long.valueOf(entry.getValue().value).longValue());
                }
            }
        }
    }

    private static class FormatterJsonGenerator
    implements StructuredFormatter.Generator {
        private final StructuredFormatter.Generator generator;
        private final Set<String> excludedKeys;

        private FormatterJsonGenerator(StructuredFormatter.Generator generator, Set<String> excludedKeys) {
            this.generator = generator;
            this.excludedKeys = excludedKeys;
        }

        public StructuredFormatter.Generator begin() throws Exception {
            this.generator.begin();
            return this;
        }

        public StructuredFormatter.Generator add(String key, int value) throws Exception {
            if (!this.excludedKeys.contains(key)) {
                this.generator.add(key, value);
            }
            return this;
        }

        public StructuredFormatter.Generator add(String key, long value) throws Exception {
            if (!this.excludedKeys.contains(key)) {
                this.generator.add(key, value);
            }
            return this;
        }

        public StructuredFormatter.Generator add(String key, Map<String, ?> value) throws Exception {
            if (!this.excludedKeys.contains(key)) {
                this.generator.add(key, value);
            }
            return this;
        }

        public StructuredFormatter.Generator add(String key, String value) throws Exception {
            if (!this.excludedKeys.contains(key)) {
                this.generator.add(key, value);
            }
            return this;
        }

        public StructuredFormatter.Generator startObject(String key) throws Exception {
            this.generator.startObject(key);
            return this;
        }

        public StructuredFormatter.Generator endObject() throws Exception {
            this.generator.endObject();
            return this;
        }

        public StructuredFormatter.Generator startArray(String key) throws Exception {
            this.generator.startArray(key);
            return this;
        }

        public StructuredFormatter.Generator endArray() throws Exception {
            this.generator.endArray();
            return this;
        }

        public StructuredFormatter.Generator end() throws Exception {
            this.generator.end();
            return this;
        }
    }
}

