/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.validator;

import com.webauthn4j.data.client.CollectedClientData;
import com.webauthn4j.data.client.Origin;
import com.webauthn4j.server.ServerProperty;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.validator.AuthenticationObject;
import com.webauthn4j.validator.OriginValidator;
import com.webauthn4j.validator.RegistrationObject;
import com.webauthn4j.validator.exception.BadOriginException;
import org.checkerframework.checker.nullness.qual.NonNull;

public class OriginValidatorImpl
implements OriginValidator {
    @Override
    public void validate(@NonNull RegistrationObject registrationObject) {
        AssertUtil.notNull((Object)registrationObject, (String)"registrationObject must not be null");
        CollectedClientData collectedClientData = registrationObject.getCollectedClientData();
        ServerProperty serverProperty = registrationObject.getServerProperty();
        this.validate(collectedClientData, serverProperty);
    }

    @Override
    public void validate(@NonNull AuthenticationObject authenticationObject) {
        AssertUtil.notNull((Object)authenticationObject, (String)"authenticationObject must not be null");
        CollectedClientData collectedClientData = authenticationObject.getCollectedClientData();
        ServerProperty serverProperty = authenticationObject.getServerProperty();
        this.validate(collectedClientData, serverProperty);
    }

    protected void validate(@NonNull CollectedClientData collectedClientData, @NonNull ServerProperty serverProperty) {
        AssertUtil.notNull((Object)collectedClientData, (String)"collectedClientData must not be null");
        AssertUtil.notNull((Object)serverProperty, (String)"serverProperty must not be null");
        Origin clientOrigin = collectedClientData.getOrigin();
        if (!serverProperty.getOrigins().contains(clientOrigin)) {
            throw new BadOriginException("The collectedClientData '" + clientOrigin + "' origin doesn't match any of the preconfigured server origin.");
        }
    }
}

