/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.statement;

import com.webauthn4j.data.attestation.statement.TPMAObject;
import com.webauthn4j.data.attestation.statement.TPMIAlgHash;
import com.webauthn4j.data.attestation.statement.TPMIAlgPublic;
import com.webauthn4j.data.attestation.statement.TPMUPublicId;
import com.webauthn4j.data.attestation.statement.TPMUPublicParms;
import com.webauthn4j.data.attestation.statement.TPMUtil;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.UnsignedNumberUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TPMTPublic
implements Serializable {
    private final TPMIAlgPublic type;
    private final TPMIAlgHash nameAlg;
    private final TPMAObject objectAttributes;
    private final byte[] authPolicy;
    private final TPMUPublicParms parameters;
    private final TPMUPublicId unique;

    public TPMTPublic(@NonNull TPMIAlgPublic type, @NonNull TPMIAlgHash nameAlg, @NonNull TPMAObject objectAttributes, @NonNull byte[] authPolicy, @NonNull TPMUPublicParms parameters, @NonNull TPMUPublicId unique) {
        this.type = type;
        this.nameAlg = nameAlg;
        this.objectAttributes = objectAttributes;
        this.authPolicy = authPolicy;
        this.parameters = parameters;
        this.unique = unique;
    }

    public @NonNull TPMIAlgPublic getType() {
        return this.type;
    }

    public @NonNull TPMIAlgHash getNameAlg() {
        return this.nameAlg;
    }

    public @NonNull TPMAObject getObjectAttributes() {
        return this.objectAttributes;
    }

    public @NonNull byte[] getAuthPolicy() {
        return ArrayUtil.clone((byte[])this.authPolicy);
    }

    public @NonNull TPMUPublicParms getParameters() {
        return this.parameters;
    }

    public @NonNull TPMUPublicId getUnique() {
        return this.unique;
    }

    public @NonNull byte[] getBytes() {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            int typeValue = this.type.getValue();
            stream.write(UnsignedNumberUtil.toBytes((int)typeValue));
            int nameAlgValue = this.getNameAlg().getValue();
            stream.write(UnsignedNumberUtil.toBytes((int)nameAlgValue));
            stream.write(this.getObjectAttributes().getBytes());
            TPMUtil.writeSizedArray(stream, this.getAuthPolicy());
            stream.write(this.getParameters().getBytes());
            stream.write(this.getUnique().getBytes());
            return stream.toByteArray();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TPMTPublic that = (TPMTPublic)o;
        return this.type == that.type && this.nameAlg == that.nameAlg && Objects.equals(this.objectAttributes, that.objectAttributes) && Arrays.equals(this.authPolicy, that.authPolicy) && Objects.equals(this.parameters, that.parameters) && Objects.equals(this.unique, that.unique);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.type, this.nameAlg, this.objectAttributes, this.parameters, this.unique});
        result = 31 * result + Arrays.hashCode(this.authPolicy);
        return result;
    }
}

