/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.runtime;

import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import java.util.Set;

public class MvnpmHandler
implements Handler<RoutingContext> {
    private final URLClassLoader mvnpmLoader;
    private final String root;
    private static final String SLASH = "/";
    private static final String BASE_DIR = "META-INF/resources";
    private static final String DOT = ".";
    private static final String DOT_JS = ".js";
    private static final String DOT_MJS = ".mjs";
    private static final String DOT_JSON = ".json";
    private static final String DOT_HTML = ".html";
    private static final String DOT_HTM = ".htm";
    private static final String DOT_XHTML = ".xhtml";
    private static final String DOT_CSS = ".css";
    private static final String DOT_XML = ".xml";
    private static final String CONTENT_TYPE_JAVASCRIPT = "application/javascript";
    private static final String CONTENT_TYPE_JSON = "application/json";
    private static final String CONTENT_TYPE_HTML = "text/html; charset=utf-8";
    private static final String CONTENT_TYPE_XHTML = "application/xhtml+xml; charset=utf-8";
    private static final String CONTENT_TYPE_XML = "application/xml; charset=utf-8";
    private static final String CONTENT_TYPE_CSS = "text/css; charset=utf-8";
    private static final String CONTENT_TYPE_TEXT = "text/plain; charset=utf-8";

    public MvnpmHandler(String root, Set<URL> mvnpmJars) {
        this.root = root;
        this.mvnpmLoader = new URLClassLoader((URL[])mvnpmJars.toArray(URL[]::new));
    }

    public void handle(RoutingContext event) {
        block10: {
            Object fullPath = event.normalizedPath().replaceFirst(this.root, SLASH);
            String[] parts = ((String)fullPath).split(SLASH);
            String fileName = parts[parts.length - 1];
            if (!fileName.contains(DOT)) {
                fullPath = (String)fullPath + DOT_JS;
            }
            try {
                URL url = this.mvnpmLoader.getResource(BASE_DIR + (String)fullPath);
                if (url == null) break block10;
                URLConnection openConnection = url.openConnection();
                long lastModified = openConnection.getLastModified();
                try (InputStream is = openConnection.getInputStream();){
                    if (is != null) {
                        byte[] contents = is.readAllBytes();
                        event.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)this.getContentType(fileName)).putHeader(HttpHeaders.CACHE_CONTROL, (CharSequence)"public, immutable, max-age=31536000").putHeader(HttpHeaders.LAST_MODIFIED, (CharSequence)this.formatDate(lastModified)).putHeader("date", this.formatDate(LocalDateTime.now())).end(Buffer.buffer((byte[])contents));
                        return;
                    }
                }
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        event.next();
    }

    private String formatDate(long m) {
        Instant i = Instant.ofEpochMilli(m);
        return this.formatDate(i);
    }

    private String formatDate(TemporalAccessor t) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH).withZone(ZoneId.of("GMT"));
        return formatter.format(t);
    }

    private String getContentType(String filename) {
        String f = filename.toLowerCase();
        if (f.endsWith(DOT_JS) || f.endsWith(DOT_MJS)) {
            return CONTENT_TYPE_JAVASCRIPT;
        }
        if (f.endsWith(DOT_JSON)) {
            return CONTENT_TYPE_JSON;
        }
        if (f.endsWith(DOT_HTML) || f.endsWith(DOT_HTM)) {
            return CONTENT_TYPE_HTML;
        }
        if (f.endsWith(DOT_XHTML)) {
            return CONTENT_TYPE_XHTML;
        }
        if (f.endsWith(DOT_CSS)) {
            return CONTENT_TYPE_CSS;
        }
        if (f.endsWith(DOT_XML)) {
            return CONTENT_TYPE_XML;
        }
        return CONTENT_TYPE_JAVASCRIPT;
    }
}

