/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance.signing;

import java.util.List;
import org.keycloak.component.ComponentModel;
import org.keycloak.component.ComponentValidationException;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.oid4vc.issuance.signing.JwtSigningService;
import org.keycloak.protocol.oid4vc.issuance.signing.SigningProperties;
import org.keycloak.protocol.oid4vc.issuance.signing.VCSigningServiceProviderFactory;
import org.keycloak.protocol.oid4vc.issuance.signing.VerifiableCredentialsSigningService;
import org.keycloak.provider.ConfigurationValidationHelper;
import org.keycloak.provider.ProviderConfigProperty;

public class JwtSigningServiceProviderFactory
implements VCSigningServiceProviderFactory {
    public static final String SUPPORTED_FORMAT = "jwt_vc";
    private static final String HELP_TEXT = "Issues JWT-VCs following the specification of https://identity.foundation/jwt-vc-presentation-profile/.";

    public VerifiableCredentialsSigningService create(KeycloakSession session, ComponentModel model) {
        String keyId = model.get(SigningProperties.KEY_ID.getKey());
        String algorithmType = model.get(SigningProperties.ALGORITHM_TYPE.getKey());
        return new JwtSigningService(session, keyId, algorithmType);
    }

    public String getHelpText() {
        return HELP_TEXT;
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return VCSigningServiceProviderFactory.configurationBuilder().property(SigningProperties.ALGORITHM_TYPE.asConfigProperty()).build();
    }

    public String getId() {
        return SUPPORTED_FORMAT;
    }

    @Override
    public void validateSpecificConfiguration(KeycloakSession session, RealmModel realm, ComponentModel model) throws ComponentValidationException {
        ConfigurationValidationHelper.check((ComponentModel)model).checkRequired(SigningProperties.ALGORITHM_TYPE.asConfigProperty());
    }

    @Override
    public String supportedFormat() {
        return SUPPORTED_FORMAT;
    }
}

