/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.commons.api.BasicCache;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.common.util.Time;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.connections.infinispan.InfinispanUtil;
import org.keycloak.infinispan.util.InfinispanUtils;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.SingleUseObjectProviderFactory;
import org.keycloak.models.session.RevokedTokenPersisterProvider;
import org.keycloak.models.sessions.infinispan.InfinispanSingleUseObjectProvider;
import org.keycloak.models.sessions.infinispan.entities.SingleUseObjectValueEntity;
import org.keycloak.models.utils.PostMigrationEvent;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.Provider;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.provider.ServerInfoAwareProviderFactory;
import org.keycloak.storage.datastore.DefaultDatastoreProviderFactory;

public class InfinispanSingleUseObjectProviderFactory
implements SingleUseObjectProviderFactory<InfinispanSingleUseObjectProvider>,
EnvironmentDependentProviderFactory,
ServerInfoAwareProviderFactory {
    public static final String CONFIG_PERSIST_REVOKED_TOKENS = "persistRevokedTokens";
    public static final boolean DEFAULT_PERSIST_REVOKED_TOKENS = true;
    public static final String LOADED = "loaded.revoked";
    private static final Logger LOG = Logger.getLogger(InfinispanSingleUseObjectProviderFactory.class);
    protected volatile Supplier<BasicCache<String, SingleUseObjectValueEntity>> singleUseObjectCache;
    private volatile boolean initialized;
    private boolean persistRevokedTokens;

    public Set<Class<? extends Provider>> dependsOn() {
        return Set.of(InfinispanConnectionProvider.class);
    }

    public InfinispanSingleUseObjectProvider create(KeycloakSession session) {
        this.initialize(session);
        return new InfinispanSingleUseObjectProvider(session, this.singleUseObjectCache, this.persistRevokedTokens);
    }

    static Supplier<BasicCache<String, SingleUseObjectValueEntity>> getSingleUseObjectCache(KeycloakSession session) {
        InfinispanConnectionProvider connections = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class);
        Cache cache = connections.getCache("actionTokens");
        RemoteCache remoteCache = InfinispanUtil.getRemoteCache(cache);
        if (remoteCache != null) {
            LOG.debugf("Having remote stores. Using remote cache '%s' for single-use cache of token", (Object)remoteCache.getName());
            return () -> remoteCache.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE});
        }
        LOG.debugf("Not having remote stores. Using basic cache '%s' for single-use cache of token", (Object)cache.getName());
        return () -> cache;
    }

    public void init(Config.Scope config) {
        this.persistRevokedTokens = config.getBoolean(CONFIG_PERSIST_REVOKED_TOKENS, Boolean.valueOf(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(KeycloakSession session) {
        if (this.persistRevokedTokens && !this.initialized) {
            InfinispanSingleUseObjectProviderFactory infinispanSingleUseObjectProviderFactory = this;
            synchronized (infinispanSingleUseObjectProviderFactory) {
                if (!this.initialized) {
                    RevokedTokenPersisterProvider provider = (RevokedTokenPersisterProvider)session.getProvider(RevokedTokenPersisterProvider.class);
                    BasicCache<String, SingleUseObjectValueEntity> cache = this.singleUseObjectCache.get();
                    if (cache.get((Object)LOADED) == null) {
                        provider.getAllRevokedTokens().forEach(revokedToken -> {
                            long lifespanSeconds = revokedToken.expiry() - (long)Time.currentTime();
                            if (lifespanSeconds > 0L) {
                                cache.put((Object)(revokedToken.tokenId() + ".revoked"), (Object)new SingleUseObjectValueEntity(Collections.emptyMap()), InfinispanUtil.toHotrodTimeMs(cache, Time.toMillis((long)lifespanSeconds)), TimeUnit.MILLISECONDS);
                            }
                        });
                        cache.put((Object)LOADED, (Object)new SingleUseObjectValueEntity(Collections.emptyMap()));
                    }
                    this.initialized = true;
                }
            }
        }
    }

    public void postInit(KeycloakSessionFactory factory) {
        if (this.singleUseObjectCache == null) {
            this.singleUseObjectCache = InfinispanSingleUseObjectProviderFactory.getSingleUseObjectCache(factory.create());
        }
        if (this.persistRevokedTokens) {
            factory.register(event -> {
                if (event instanceof PostMigrationEvent) {
                    PostMigrationEvent pme = (PostMigrationEvent)event;
                    KeycloakSessionFactory sessionFactory = pme.getFactory();
                    DefaultDatastoreProviderFactory.setupClearExpiredRevokedTokensScheduledTask((KeycloakSessionFactory)sessionFactory);
                    try (KeycloakSession session = sessionFactory.create();){
                        this.initialize(session);
                    }
                }
            });
        }
    }

    public void close() {
    }

    public String getId() {
        return "infinispan";
    }

    public int order() {
        return 1;
    }

    public boolean isSupported(Config.Scope config) {
        return InfinispanUtils.isEmbeddedInfinispan();
    }

    public Map<String, String> getOperationalInfo() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put(CONFIG_PERSIST_REVOKED_TOKENS, Boolean.toString(this.persistRevokedTokens));
        return info;
    }

    public List<ProviderConfigProperty> getConfigMetadata() {
        ProviderConfigurationBuilder builder = ProviderConfigurationBuilder.create();
        builder.property().name(CONFIG_PERSIST_REVOKED_TOKENS).type("boolean").helpText("If revoked tokens are stored persistently across restarts").defaultValue((Object)true).add();
        return builder.build();
    }
}

