/*
 * Decompiled with CFR 0.152.
 */
package org.jxmpp.xml.splitter;

import java.io.IOException;

public abstract class InvalidXmlException
extends IOException {
    private static final long serialVersionUID = 1L;
    private final char unexpectedChar;
    private final String xml;

    protected InvalidXmlException(CharSequence message, char unexpectedChar, CharSequence xml) {
        super(message.toString());
        this.unexpectedChar = unexpectedChar;
        this.xml = xml.toString();
    }

    public char getUnexpectedChar() {
        return this.unexpectedChar;
    }

    public String getParsedXmlSoFar() {
        return this.xml;
    }

    public static final class InvalidAttributeDeclarationException
    extends InvalidXmlException {
        private static final long serialVersionUID = 1L;

        private InvalidAttributeDeclarationException(CharSequence message, char c, CharSequence xml) {
            super(message, c, xml);
        }

        public static InvalidAttributeDeclarationException create(char c, CharSequence xml) {
            StringBuilder message = new StringBuilder();
            message.append("Invalid attribute declaration, expected ''' or '\"', but got '").append(c).append("'. Parsed xml so far: ").append(xml);
            return new InvalidAttributeDeclarationException(message, c, xml);
        }
    }

    public static final class InvalidEmptyTagException
    extends InvalidXmlException {
        private static final long serialVersionUID = 1L;

        private InvalidEmptyTagException(CharSequence message, char c, CharSequence xml) {
            super(message, c, xml);
        }

        public static InvalidEmptyTagException create(char c, CharSequence xml) {
            StringBuilder message = new StringBuilder();
            message.append("Invalid empty tag, expected '>', but got '").append(c).append("'. Parsed xml so far: ").append(xml);
            return new InvalidEmptyTagException(message, c, xml);
        }
    }
}

