/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.sourcesaver;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import org.jd.gui.api.API;
import org.jd.gui.api.model.Container;
import org.jd.gui.service.sourcesaver.AbstractSourceSaverProvider;
import org.jd.gui.spi.SourceSaver;
import org.jd.gui.util.exception.ExceptionUtil;

public class DirectorySourceSaverProvider
extends AbstractSourceSaverProvider {
    @Override
    public String[] getSelectors() {
        return this.appendSelectors("*:dir:*");
    }

    @Override
    public String getSourcePath(Container.Entry entry) {
        return entry.getPath() + ".src.zip";
    }

    @Override
    public int getFileCount(API api, Container.Entry entry) {
        return this.getFileCount(api, entry.getChildren());
    }

    protected int getFileCount(API api, Collection<Container.Entry> entries) {
        int count = 0;
        for (Container.Entry e : entries) {
            SourceSaver sourceSaver = api.getSourceSaver(e);
            if (sourceSaver == null) continue;
            count += sourceSaver.getFileCount(api, e);
        }
        return count;
    }

    @Override
    public void save(API api, SourceSaver.Controller controller, SourceSaver.Listener listener, Path rootPath, Container.Entry entry) {
        block2: {
            Path path = rootPath.resolve(entry.getPath());
            try {
                Files.createDirectories(path, new FileAttribute[0]);
                this.saveContent(api, controller, listener, rootPath, path, entry);
            }
            catch (IOException e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace(e)) break block2;
                throw new AssertionError();
            }
        }
    }

    @Override
    public void saveContent(API api, SourceSaver.Controller controller, SourceSaver.Listener listener, Path rootPath, Path path, Container.Entry entry) {
        for (Container.Entry e : this.getChildren(entry)) {
            if (controller.isCancelled()) break;
            SourceSaver sourceSaver = api.getSourceSaver(e);
            if (sourceSaver == null) continue;
            sourceSaver.save(api, controller, listener, rootPath, e);
        }
    }

    protected Collection<Container.Entry> getChildren(Container.Entry entry) {
        return entry.getChildren();
    }
}

