/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.shrink;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.InvokeCustomNode;
import jadx.core.dex.instructions.InvokeNode;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.InsnWrapArg;
import jadx.core.dex.instructions.args.Named;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.args.SSAVar;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.JadxVisitor;
import jadx.core.dex.visitors.ModVisitor;
import jadx.core.dex.visitors.shrink.ArgsInfo;
import jadx.core.dex.visitors.shrink.WrapInfo;
import jadx.core.utils.BlockUtils;
import jadx.core.utils.InsnList;
import jadx.core.utils.InsnRemover;
import jadx.core.utils.RegionUtils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Set;

@JadxVisitor(name="CodeShrinkVisitor", desc="Inline variables to make code smaller", runAfter={ModVisitor.class})
public class CodeShrinkVisitor
extends AbstractVisitor {
    @Override
    public void visit(MethodNode mth) {
        CodeShrinkVisitor.shrinkMethod(mth);
    }

    public static void shrinkMethod(MethodNode mth) {
        if (mth.isNoCode()) {
            return;
        }
        mth.remove(AFlag.REQUEST_CODE_SHRINK);
        for (BlockNode block : mth.getBasicBlocks()) {
            CodeShrinkVisitor.shrinkBlock(mth, block);
            CodeShrinkVisitor.simplifyMoveInsns(mth, block);
        }
    }

    private static void shrinkBlock(MethodNode mth, BlockNode block) {
        if (block.getInstructions().isEmpty()) {
            return;
        }
        InsnList insnList = new InsnList(block.getInstructions());
        int insnCount = insnList.size();
        ArrayList<ArgsInfo> argsList = new ArrayList<ArgsInfo>(insnCount);
        for (int i = 0; i < insnCount; ++i) {
            argsList.add(new ArgsInfo(insnList.get(i), argsList, i));
        }
        ArrayList<WrapInfo> wrapList = new ArrayList<WrapInfo>();
        for (ArgsInfo argsInfo : argsList) {
            List<RegisterArg> args = argsInfo.getArgs();
            if (args.isEmpty()) continue;
            ListIterator<RegisterArg> it = args.listIterator(args.size());
            while (it.hasPrevious()) {
                RegisterArg arg = it.previous();
                CodeShrinkVisitor.checkInline(mth, block, insnList, wrapList, argsInfo, arg);
            }
        }
        if (!wrapList.isEmpty()) {
            for (WrapInfo wrapInfo : wrapList) {
                CodeShrinkVisitor.inline(mth, wrapInfo.getArg(), wrapInfo.getInsn(), block);
            }
        }
    }

    private static void checkInline(MethodNode mth, BlockNode block, InsnList insnList, List<WrapInfo> wrapList, ArgsInfo argsInfo, RegisterArg arg) {
        if (arg.contains(AFlag.DONT_INLINE) || arg.getParentInsn() == null || arg.getParentInsn().contains(AFlag.DONT_GENERATE)) {
            return;
        }
        SSAVar sVar = arg.getSVar();
        if (sVar == null || sVar.getAssign().contains(AFlag.DONT_INLINE)) {
            return;
        }
        InsnNode assignInsn = sVar.getAssign().getParentInsn();
        if (assignInsn == null || assignInsn.contains(AFlag.DONT_INLINE) || assignInsn.contains(AFlag.WRAPPED)) {
            return;
        }
        boolean assignInline = assignInsn.contains(AFlag.FORCE_ASSIGN_INLINE);
        if (!assignInline && sVar.isUsedInPhi()) {
            return;
        }
        int useCount = 0;
        for (RegisterArg useArg : sVar.getUseList()) {
            InsnNode parentInsn = useArg.getParentInsn();
            if (parentInsn != null && parentInsn.contains(AFlag.DONT_GENERATE)) continue;
            if (!assignInline && useArg.contains(AFlag.DONT_INLINE_CONST)) {
                return;
            }
            ++useCount;
        }
        if (!assignInline && useCount != 1) {
            return;
        }
        if (!(assignInline || sVar.getName() == null || CodeShrinkVisitor.searchArgWithName(assignInsn, sVar.getName()) || CodeShrinkVisitor.varWithSameNameExists(mth, sVar))) {
            return;
        }
        if (!CodeShrinkVisitor.checkLambdaInline(arg, assignInsn)) {
            return;
        }
        int assignPos = insnList.getIndex(assignInsn);
        if (assignPos != -1) {
            WrapInfo wrapInfo = argsInfo.checkInline(assignPos, arg);
            if (wrapInfo != null) {
                wrapList.add(wrapInfo);
            }
        } else {
            BlockNode assignBlock = BlockUtils.getBlockByInsn(mth, assignInsn);
            if (assignBlock != null && assignInsn != arg.getParentInsn() && CodeShrinkVisitor.canMoveBetweenBlocks(mth, assignInsn, assignBlock, block, argsInfo.getInsn())) {
                if (assignInline) {
                    CodeShrinkVisitor.assignInline(mth, arg, assignInsn, assignBlock);
                } else {
                    CodeShrinkVisitor.inline(mth, arg, assignInsn, assignBlock);
                }
            }
        }
    }

    private static boolean checkLambdaInline(RegisterArg arg, InsnNode assignInsn) {
        if (assignInsn.getType() == InsnType.INVOKE && assignInsn instanceof InvokeCustomNode) {
            for (RegisterArg useArg : arg.getSVar().getUseList()) {
                InvokeNode invokeNode;
                InsnArg instArg;
                InsnNode parentInsn = useArg.getParentInsn();
                if (parentInsn == null || parentInsn.getType() != InsnType.INVOKE || (instArg = (invokeNode = (InvokeNode)parentInsn).getInstanceArg()) == null || instArg != useArg) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean varWithSameNameExists(MethodNode mth, SSAVar inlineVar) {
        for (SSAVar ssaVar : mth.getSVars()) {
            if (ssaVar == inlineVar || ssaVar.getCodeVar() == inlineVar.getCodeVar() || !Objects.equals(ssaVar.getName(), inlineVar.getName())) continue;
            return ssaVar.getUseCount() > inlineVar.getUseCount();
        }
        return false;
    }

    private static boolean searchArgWithName(InsnNode assignInsn, String varName) {
        InsnArg result = assignInsn.visitArgs(insnArg -> {
            String argName;
            if (insnArg instanceof Named && Objects.equals(argName = ((Named)((Object)insnArg)).getName(), varName)) {
                return insnArg;
            }
            return null;
        });
        return result != null;
    }

    private static boolean assignInline(MethodNode mth, RegisterArg arg, InsnNode assignInsn, BlockNode assignBlock) {
        RegisterArg useArg = arg.getSVar().getUseList().get(0);
        InsnNode useInsn = useArg.getParentInsn();
        if (useInsn == null || useInsn.contains(AFlag.DONT_GENERATE)) {
            return false;
        }
        if (!InsnRemover.removeWithoutUnbind(mth, assignBlock, assignInsn)) {
            return false;
        }
        InsnArg replaceArg = InsnArg.wrapInsnIntoArg(assignInsn);
        useInsn.replaceArg(useArg, replaceArg);
        return true;
    }

    private static boolean inline(MethodNode mth, RegisterArg arg, InsnNode insn, BlockNode block) {
        boolean replaced;
        if (insn.contains(AFlag.FORCE_ASSIGN_INLINE)) {
            return CodeShrinkVisitor.assignInline(mth, arg, insn, block);
        }
        InsnArg wrappedArg = arg.wrapInstruction(mth, insn, false);
        boolean bl = replaced = wrappedArg != null;
        if (replaced) {
            InsnNode parentInsn = arg.getParentInsn();
            if (parentInsn != null) {
                parentInsn.inheritMetadata(insn);
            }
            InsnRemover.unbindResult(mth, insn);
            InsnRemover.removeWithoutUnbind(mth, block, insn);
        }
        return replaced;
    }

    private static boolean canMoveBetweenBlocks(MethodNode mth, InsnNode assignInsn, BlockNode assignBlock, BlockNode useBlock, InsnNode useInsn) {
        if (!BlockUtils.isPathExists(assignBlock, useBlock)) {
            return false;
        }
        List<RegisterArg> argsList = ArgsInfo.getArgs(assignInsn);
        BitSet args = new BitSet();
        for (RegisterArg registerArg : argsList) {
            args.set(registerArg.getRegNum());
        }
        boolean startCheck = false;
        for (InsnNode insn : assignBlock.getInstructions()) {
            if (startCheck && (!insn.canReorder() || ArgsInfo.usedArgAssign(insn, args))) {
                return false;
            }
            if (insn != assignInsn) continue;
            startCheck = true;
        }
        Set<BlockNode> set = BlockUtils.getAllPathsBlocks(assignBlock, useBlock);
        set.remove(assignBlock);
        set.remove(useBlock);
        for (BlockNode block : set) {
            if (block.contains(AFlag.DONT_GENERATE)) {
                if (!BlockUtils.checkLastInsnType(block, InsnType.MONITOR_EXIT) || RegionUtils.isBlocksInSameRegion(mth, assignBlock, useBlock)) continue;
                return false;
            }
            for (InsnNode insn : block.getInstructions()) {
                if (insn.canReorder() && !ArgsInfo.usedArgAssign(insn, args)) continue;
                return false;
            }
        }
        for (InsnNode insn : useBlock.getInstructions()) {
            if (insn == useInsn) {
                return true;
            }
            if (insn.canReorder() && !ArgsInfo.usedArgAssign(insn, args)) continue;
            return false;
        }
        throw new JadxRuntimeException("Can't process instruction move : " + assignBlock);
    }

    private static void simplifyMoveInsns(MethodNode mth, BlockNode block) {
        List<InsnNode> insns = block.getInstructions();
        int size = insns.size();
        for (int i = 0; i < size; ++i) {
            InsnArg arg;
            InsnNode insn = insns.get(i);
            if (insn.getType() != InsnType.MOVE || !(arg = insn.getArg(0)).isInsnWrap()) continue;
            InsnNode wrapInsn = ((InsnWrapArg)arg).getWrapInsn();
            InsnRemover.unbindResult(mth, wrapInsn);
            wrapInsn.setResult(insn.getResult().duplicate());
            wrapInsn.inheritMetadata(insn);
            wrapInsn.setOffset(insn.getOffset());
            wrapInsn.remove(AFlag.WRAPPED);
            block.getInstructions().set(i, wrapInsn);
        }
    }
}

