/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.calls.DslMarkerUtils;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.DslScopeViolationCallChecker$checkCallImplicitReceiver$;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.ResolvedCallUtilKt;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J,\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/DslScopeViolationCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "checkCallImplicitReceiver", "callImplicitReceiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "frontend"})
@SourceDebugExtension(value={"SMAP\nDslScopeViolationCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DslScopeViolationCallChecker.kt\norg/jetbrains/kotlin/resolve/calls/checkers/DslScopeViolationCallChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,95:1\n1557#2:96\n1628#2,3:97\n1557#2:101\n1628#2,3:102\n295#2:105\n1755#2,3:106\n296#2:109\n295#2:110\n1755#2,3:111\n296#2:114\n477#3:100\n*S KotlinDebug\n*F\n+ 1 DslScopeViolationCallChecker.kt\norg/jetbrains/kotlin/resolve/calls/checkers/DslScopeViolationCallChecker\n*L\n35#1:96\n35#1:97,3\n63#1:101\n63#1:102,3\n66#1:105\n67#1:106,3\n66#1:109\n79#1:110\n81#1:111,3\n79#1:114\n53#1:100\n*E\n"})
public final class DslScopeViolationCallChecker
implements CallChecker {
    @NotNull
    public static final DslScopeViolationCallChecker INSTANCE = new DslScopeViolationCallChecker();

    private DslScopeViolationCallChecker() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Collection collection;
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context, "context");
        if (!context.getLanguageVersionSettings().supportsFeature(LanguageFeature.DslMarkersSupport)) {
            return;
        }
        Collection callImplicitReceivers = ResolvedCallUtilKt.getImplicitReceivers(resolvedCall2);
        if (context.getLanguageVersionSettings().supportsFeature(LanguageFeature.NewInference)) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = callImplicitReceivers;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ReceiverValue receiverValue = (ReceiverValue)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it.getOriginal());
            }
            collection = (List)destination$iv$iv;
        } else {
            collection = callImplicitReceivers;
        }
        Collection originalReceivers = collection;
        for (ReceiverValue callImplicitReceiver : originalReceivers) {
            this.checkCallImplicitReceiver(callImplicitReceiver, resolvedCall2, reportOn, context);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkCallImplicitReceiver(ReceiverValue callImplicitReceiver, ResolvedCall<?> resolvedCall2, PsiElement reportOn, CallCheckerContext context) {
        Object v4;
        block16: {
            Object v2;
            List dslMarkersFromOuterReceivers;
            Set<FqName> additionalCallDslMarkers;
            Set<FqName> callDslMarkers;
            block14: {
                Iterator $this$mapTo$iv$iv;
                void $this$map$iv;
                void $this$filterIsInstance$iv;
                boolean isNewInferenceEnabled = context.getLanguageVersionSettings().supportsFeature(LanguageFeature.NewInference);
                Object object = ScopeUtilsKt.getParentsWithSelf(context.getScope());
                boolean $i$f$filterIsInstance = false;
                Sequence sequence2 = SequencesKt.filter($this$filterIsInstance$iv, checkCallImplicitReceiver$$inlined$filterIsInstance$1.INSTANCE);
                Intrinsics.checkNotNull(sequence2, "null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
                List<ReceiverValue> receiversUntilOneFromTheCall = SequencesKt.toList(SequencesKt.takeWhile(SequencesKt.map(SequencesKt.flatMapIterable(sequence2, DslScopeViolationCallChecker::checkCallImplicitReceiver$lambda$1), arg_0 -> DslScopeViolationCallChecker.checkCallImplicitReceiver$lambda$2(isNewInferenceEnabled, arg_0)), arg_0 -> DslScopeViolationCallChecker.checkCallImplicitReceiver$lambda$3(callImplicitReceiver, arg_0)));
                if (receiversUntilOneFromTheCall.isEmpty()) {
                    return;
                }
                object = DslMarkerUtils.INSTANCE.extractDslMarkerFqNames(callImplicitReceiver);
                callDslMarkers = ((DslMarkerUtils.DslMarkersFromReceiver)object).component1();
                additionalCallDslMarkers = ((DslMarkerUtils.DslMarkersFromReceiver)object).component2();
                if (callDslMarkers.isEmpty() && additionalCallDslMarkers.isEmpty()) {
                    return;
                }
                Iterable iterable = receiversUntilOneFromTheCall;
                DslMarkerUtils dslMarkerUtils = DslMarkerUtils.INSTANCE;
                boolean $i$f$map = false;
                void var14_15 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                Iterator iterator2 = $this$mapTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    void p0;
                    Object item$iv$iv = iterator2.next();
                    ReceiverValue receiverValue = (ReceiverValue)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(dslMarkerUtils.extractDslMarkerFqNames((ReceiverValue)p0));
                }
                dslMarkersFromOuterReceivers = (List)destination$iv$iv;
                Iterable $this$firstOrNull$iv = dslMarkersFromOuterReceivers;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    boolean bl;
                    block13: {
                        DslMarkerUtils.DslMarkersFromReceiver dslMarkersFromReceiver = (DslMarkerUtils.DslMarkersFromReceiver)element$iv;
                        boolean bl2 = false;
                        Set<FqName> dslMarkersFromReceiver2 = dslMarkersFromReceiver.component1();
                        Iterable $this$any$iv = dslMarkersFromReceiver2;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv) {
                                FqName p0 = (FqName)element$iv2;
                                boolean bl3 = false;
                                if (!callDslMarkers.contains(p0)) continue;
                                bl = true;
                                break block13;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) continue;
                    v2 = element$iv;
                    break block14;
                }
                v2 = null;
            }
            DslMarkerUtils.DslMarkersFromReceiver closestAnotherReceiverWithSameDslMarker = v2;
            if (closestAnotherReceiverWithSameDslMarker != null) {
                context.getTrace().report(Errors.DSL_SCOPE_VIOLATION.on(reportOn, (CallableDescriptor)resolvedCall2.getResultingDescriptor()));
                return;
            }
            Set<FqName> allDslMarkersFromCall = SetsKt.plus(callDslMarkers, (Iterable)additionalCallDslMarkers);
            Iterable $this$firstOrNull$iv = dslMarkersFromOuterReceivers;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                boolean bl;
                block15: {
                    DslMarkerUtils.DslMarkersFromReceiver dslMarkersFromReceiver = (DslMarkerUtils.DslMarkersFromReceiver)element$iv;
                    boolean bl4 = false;
                    Set<FqName> dslMarkersFromReceiver3 = dslMarkersFromReceiver.component1();
                    Set<FqName> additionalDslMarkersFromReceiver = dslMarkersFromReceiver.component2();
                    Set<FqName> allMarkersFromReceiver = SetsKt.plus(dslMarkersFromReceiver3, (Iterable)additionalDslMarkersFromReceiver);
                    Iterable $this$any$iv = allDslMarkersFromCall;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv3 : $this$any$iv) {
                            FqName p0 = (FqName)element$iv3;
                            boolean bl5 = false;
                            if (!allMarkersFromReceiver.contains(p0)) continue;
                            bl = true;
                            break block15;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                v4 = element$iv;
                break block16;
            }
            v4 = null;
        }
        DslMarkerUtils.DslMarkersFromReceiver closestAnotherReceiverWithSameDslMarkerWithDeprecation = v4;
        if (closestAnotherReceiverWithSameDslMarkerWithDeprecation != null) {
            DiagnosticFactory1<PsiElement, CallableDescriptor> diagnostic = context.getLanguageVersionSettings().supportsFeature(LanguageFeature.DslMarkerOnFunctionTypeReceiver) ? Errors.DSL_SCOPE_VIOLATION : Errors.DSL_SCOPE_VIOLATION_WARNING;
            context.getTrace().report(diagnostic.on(reportOn, (CallableDescriptor)resolvedCall2.getResultingDescriptor()));
        }
    }

    private static final Iterable checkCallImplicitReceiver$lambda$1(LexicalScope it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull(it.getImplicitReceiver()), (Iterable)it.getContextReceiversGroup());
    }

    private static final ReceiverValue checkCallImplicitReceiver$lambda$2(boolean $isNewInferenceEnabled, ReceiverParameterDescriptor it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return $isNewInferenceEnabled ? it.getValue().getOriginal() : it.getValue();
    }

    private static final boolean checkCallImplicitReceiver$lambda$3(ReceiverValue $callImplicitReceiver, ReceiverValue it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return !Intrinsics.areEqual(it, $callImplicitReceiver);
    }
}

