/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.declaration;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.backend.ast.metadata.HasMetadata;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.declaration.PropertyTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a.\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n\u001a$\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n\u001a4\u0010\u000b\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\r\u001a\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0005\u001a(\u0010\u0012\u001a\u00020\n*\u00020\n2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0010\u001a\n\u0010\u0018\u001a\u00020\u0019*\u00020\u0005\u001a\n\u0010\u001a\u001a\u00020\u0019*\u00020\u0005\u00a8\u0006\u001b"}, d2={"translateAccessors", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptorWithAccessors;", "declaration", "Lorg/jetbrains/kotlin/psi/KtProperty;", "result", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsPropertyInitializer;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "addGetterAndSetter", "generateGetter", "Lkotlin/Function0;", "generateSetter", "translateDelegateOrInitializerExpression", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "expression", "contextWithPropertyMetadataCreationIntrinsified", "delegatedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "property", "host", "hasCustomGetter", "", "hasCustomSetter", "js.translator"})
@SourceDebugExtension(value={"SMAP\nPropertyTranslator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PropertyTranslator.kt\norg/jetbrains/kotlin/js/translate/declaration/PropertyTranslatorKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,294:1\n1#2:295\n*E\n"})
public final class PropertyTranslatorKt {
    public static final void translateAccessors(@NotNull VariableDescriptorWithAccessors descriptor, @Nullable KtProperty declaration, @NotNull List<JsPropertyInitializer> result2, @NotNull TranslationContext context) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        Intrinsics.checkNotNullParameter(result2, "result");
        Intrinsics.checkNotNullParameter(context, "context");
        if (descriptor instanceof PropertyDescriptor && (((PropertyDescriptor)descriptor).getModality() == Modality.ABSTRACT || JsDescriptorUtils.isSimpleFinalProperty((PropertyDescriptor)descriptor))) {
            return;
        }
        new PropertyTranslator(descriptor, declaration, context).translate(result2);
    }

    public static final void translateAccessors(@NotNull VariableDescriptorWithAccessors descriptor, @NotNull List<JsPropertyInitializer> result2, @NotNull TranslationContext context) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        Intrinsics.checkNotNullParameter(result2, "result");
        Intrinsics.checkNotNullParameter(context, "context");
        PropertyTranslatorKt.translateAccessors(descriptor, null, result2, context);
    }

    public static final void addGetterAndSetter(@NotNull List<JsPropertyInitializer> $this$addGetterAndSetter, @NotNull VariableDescriptorWithAccessors descriptor, @NotNull Function0<? extends JsPropertyInitializer> generateGetter, @NotNull Function0<? extends JsPropertyInitializer> generateSetter) {
        Intrinsics.checkNotNullParameter($this$addGetterAndSetter, "<this>");
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        Intrinsics.checkNotNullParameter(generateGetter, "generateGetter");
        Intrinsics.checkNotNullParameter(generateSetter, "generateSetter");
        $this$addGetterAndSetter.add(generateGetter.invoke());
        if (descriptor.isVar()) {
            $this$addGetterAndSetter.add(generateSetter.invoke());
        }
    }

    @Nullable
    public static final JsExpression translateDelegateOrInitializerExpression(@NotNull TranslationContext $this$translateDelegateOrInitializerExpression, @NotNull KtProperty expression2) {
        JsExpression jsExpression;
        Intrinsics.checkNotNullParameter($this$translateDelegateOrInitializerExpression, "<this>");
        Intrinsics.checkNotNullParameter(expression2, "expression");
        DeclarationDescriptor declarationDescriptor = BindingUtils.getDescriptorForElement($this$translateDelegateOrInitializerExpression.bindingContext(), expression2);
        Intrinsics.checkNotNull(declarationDescriptor, "null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors");
        VariableDescriptorWithAccessors propertyDescriptor = (VariableDescriptorWithAccessors)declarationDescriptor;
        KtExpression ktExpression = expression2.getDelegateExpressionOrInitializer();
        if (ktExpression == null) {
            return null;
        }
        KtExpression expressionPsi = ktExpression;
        JsExpression jsExpression2 = Translation.translateAsExpression(expressionPsi, $this$translateDelegateOrInitializerExpression);
        Intrinsics.checkNotNullExpressionValue(jsExpression2, "translateAsExpression(...)");
        JsExpression initializer = jsExpression2;
        ResolvedCall provideDelegateCall = (ResolvedCall)$this$translateDelegateOrInitializerExpression.bindingContext().get(BindingContext.PROVIDE_DELEGATE_RESOLVED_CALL, propertyDescriptor);
        if (provideDelegateCall != null) {
            TranslationContext innerContext = PropertyTranslatorKt.contextWithPropertyMetadataCreationIntrinsified($this$translateDelegateOrInitializerExpression, provideDelegateCall, propertyDescriptor, new JsThisRef());
            jsExpression = CallTranslator.translate(innerContext, provideDelegateCall, initializer);
        } else {
            jsExpression = TranslationUtils.coerce($this$translateDelegateOrInitializerExpression, initializer, propertyDescriptor.getType());
        }
        return jsExpression;
    }

    @NotNull
    public static final TranslationContext contextWithPropertyMetadataCreationIntrinsified(@NotNull TranslationContext $this$contextWithPropertyMetadataCreationIntrinsified, @NotNull ResolvedCall<FunctionDescriptor> delegatedCall, @NotNull VariableDescriptorWithAccessors property, @NotNull JsExpression host) {
        Pair[] pairArray;
        Intrinsics.checkNotNullParameter($this$contextWithPropertyMetadataCreationIntrinsified, "<this>");
        Intrinsics.checkNotNullParameter(delegatedCall, "delegatedCall");
        Intrinsics.checkNotNullParameter(property, "property");
        Intrinsics.checkNotNullParameter(host, "host");
        List<ResolvedValueArgument> list = delegatedCall.getValueArgumentsByIndex();
        Intrinsics.checkNotNull(list);
        ResolvedValueArgument resolvedValueArgument = list.get(0);
        Intrinsics.checkNotNull(resolvedValueArgument, "null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument");
        ValueArgument valueArgument = ((ExpressionValueArgument)resolvedValueArgument).getValueArgument();
        Intrinsics.checkNotNull(valueArgument);
        KtExpression hostExpression = valueArgument.getArgumentExpression();
        List<ResolvedValueArgument> list2 = delegatedCall.getValueArgumentsByIndex();
        Intrinsics.checkNotNull(list2);
        ResolvedValueArgument resolvedValueArgument2 = list2.get(1);
        Intrinsics.checkNotNull(resolvedValueArgument2, "null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument");
        ValueArgument valueArgument2 = ((ExpressionValueArgument)resolvedValueArgument2).getValueArgument();
        Intrinsics.checkNotNull(valueArgument2);
        KtExpression fakeArgumentExpression = valueArgument2.getArgumentExpression();
        Pair[] $this$contextWithPropertyMetadataCreationIntrinsified_u24lambda_u240 = pairArray = JsAstUtils.pureFqn($this$contextWithPropertyMetadataCreationIntrinsified.getVariableForPropertyMetadata(property), null);
        boolean bl = false;
        Intrinsics.checkNotNull($this$contextWithPropertyMetadataCreationIntrinsified_u24lambda_u240);
        MetadataProperties.setSynthetic((HasMetadata)$this$contextWithPropertyMetadataCreationIntrinsified_u24lambda_u240, true);
        Intrinsics.checkNotNullExpressionValue(pairArray, "apply(...)");
        Pair[] metadataRef = pairArray;
        pairArray = new Pair[]{TuplesKt.to(hostExpression, host), TuplesKt.to(fakeArgumentExpression, metadataRef)};
        TranslationContext translationContext = $this$contextWithPropertyMetadataCreationIntrinsified.innerContextWithAliasesForExpressions(MapsKt.mapOf(pairArray));
        Intrinsics.checkNotNullExpressionValue(translationContext, "innerContextWithAliasesForExpressions(...)");
        return translationContext;
    }

    public static final boolean hasCustomGetter(@NotNull KtProperty $this$hasCustomGetter) {
        Intrinsics.checkNotNullParameter($this$hasCustomGetter, "<this>");
        KtPropertyAccessor ktPropertyAccessor = $this$hasCustomGetter.getGetter();
        return ktPropertyAccessor != null ? ktPropertyAccessor.hasBody() : false;
    }

    public static final boolean hasCustomSetter(@NotNull KtProperty $this$hasCustomSetter) {
        Intrinsics.checkNotNullParameter($this$hasCustomSetter, "<this>");
        KtPropertyAccessor ktPropertyAccessor = $this$hasCustomSetter.getSetter();
        return ktPropertyAccessor != null ? ktPropertyAccessor.hasBody() : false;
    }
}

