/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.incremental.IncrementalCompilationContext;
import org.jetbrains.kotlin.incremental.IncrementalJvmCacheKt;
import org.jetbrains.kotlin.incremental.IrTranslationResultValueExternalizer;
import org.jetbrains.kotlin.incremental.js.IrTranslationResultValue;
import org.jetbrains.kotlin.incremental.storage.AbstractBasicMap;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\t\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016JX\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00102\b\u0010\u0018\u001a\u0004\u0018\u00010\u0010\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/incremental/IrTranslationResultMap;", "Lorg/jetbrains/kotlin/incremental/storage/AbstractBasicMap;", "Ljava/io/File;", "Lorg/jetbrains/kotlin/incremental/js/IrTranslationResultValue;", "storageFile", "icContext", "Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;", "<init>", "(Ljava/io/File;Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;)V", "dumpValue", "", "value", "put", "", "sourceFile", "newFiledata", "", "newTypes", "newSignatures", "newStrings", "newDeclarations", "newBodies", "fqn", "newFileMetadata", "debugInfos", "kotlin-build-common"})
final class IrTranslationResultMap
extends AbstractBasicMap<File, IrTranslationResultValue> {
    public IrTranslationResultMap(@NotNull File storageFile, @NotNull IncrementalCompilationContext icContext) {
        Intrinsics.checkNotNullParameter(storageFile, "storageFile");
        Intrinsics.checkNotNullParameter(icContext, "icContext");
        super(storageFile, icContext.getFileDescriptorForSourceFiles(), IrTranslationResultValueExternalizer.INSTANCE, icContext);
    }

    @Override
    @NotNull
    public String dumpValue(@NotNull IrTranslationResultValue value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        return "Filedata: " + IncrementalJvmCacheKt.md5(value2.getFileData()) + ", Types: " + IncrementalJvmCacheKt.md5(value2.getTypes()) + ", Signatures: " + IncrementalJvmCacheKt.md5(value2.getSignatures()) + ", Strings: " + IncrementalJvmCacheKt.md5(value2.getStrings()) + ", Declarations: " + IncrementalJvmCacheKt.md5(value2.getDeclarations()) + ", Bodies: " + IncrementalJvmCacheKt.md5(value2.getBodies());
    }

    public final synchronized void put(@NotNull File sourceFile, @NotNull byte[] newFiledata, @NotNull byte[] newTypes, @NotNull byte[] newSignatures, @NotNull byte[] newStrings, @NotNull byte[] newDeclarations, @NotNull byte[] newBodies, @NotNull byte[] fqn, @NotNull byte[] newFileMetadata, @Nullable byte[] debugInfos2) {
        Intrinsics.checkNotNullParameter(sourceFile, "sourceFile");
        Intrinsics.checkNotNullParameter(newFiledata, "newFiledata");
        Intrinsics.checkNotNullParameter(newTypes, "newTypes");
        Intrinsics.checkNotNullParameter(newSignatures, "newSignatures");
        Intrinsics.checkNotNullParameter(newStrings, "newStrings");
        Intrinsics.checkNotNullParameter(newDeclarations, "newDeclarations");
        Intrinsics.checkNotNullParameter(newBodies, "newBodies");
        Intrinsics.checkNotNullParameter(fqn, "fqn");
        Intrinsics.checkNotNullParameter(newFileMetadata, "newFileMetadata");
        this.set(sourceFile, new IrTranslationResultValue(newFiledata, newTypes, newSignatures, newStrings, newDeclarations, newBodies, fqn, newFileMetadata, debugInfos2));
    }
}

