/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.type;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirOptInUsageBaseChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.type.FirTypeChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.types.AbbreviatedTypeAttributeKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirQualifierPart;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirUserTypeRef;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.checkers.OptInNames;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J&\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J7\u0010\u0013\u001a\u00020\u0007*\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0082\u0010\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirOptInUsageTypeRefChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirTypeChecker;", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirTypeRefChecker;", "<init>", "()V", "check", "", "typeRef", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "loadClassifierExperimentalities", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker$Experimentality;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "isSupertypeRef", "", "checkContainingClasses", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "qualifier", "", "Lorg/jetbrains/kotlin/fir/types/FirQualifierPart;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirOptInUsageTypeRefChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirOptInUsageTypeRefChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/type/FirOptInUsageTypeRefChecker\n+ 2 FirTypeUtils.kt\norg/jetbrains/kotlin/fir/types/FirTypeUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n26#2:92\n1#3:93\n1755#4,3:94\n*S KotlinDebug\n*F\n+ 1 FirOptInUsageTypeRefChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/type/FirOptInUsageTypeRefChecker\n*L\n34#1:92\n85#1:94,3\n*E\n"})
public final class FirOptInUsageTypeRefChecker
extends FirTypeChecker<FirTypeRef> {
    @NotNull
    public static final FirOptInUsageTypeRefChecker INSTANCE = new FirOptInUsageTypeRefChecker();

    private FirOptInUsageTypeRefChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirTypeRef typeRef, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        FirDeclaration firDeclaration;
        FirClassLikeSymbol<?> typeAliasExpandedSymbol;
        FirClassLikeSymbol<?> symbol;
        ConeClassLikeType coneType;
        block17: {
            ClassId classId;
            FirClassLikeSymbol<?> processedSymbol;
            FirTypeRef delegatedTypeRef;
            KtSourceElement source;
            block16: {
                FirAnnotation lastAnnotationCall;
                ConeClassLikeType coneClassLikeType;
                Intrinsics.checkNotNullParameter(typeRef, "typeRef");
                Intrinsics.checkNotNullParameter(context, "context");
                Intrinsics.checkNotNullParameter(reporter, "reporter");
                source = typeRef.getSource();
                FirResolvedTypeRef firResolvedTypeRef = typeRef instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)typeRef : null;
                delegatedTypeRef = firResolvedTypeRef != null ? firResolvedTypeRef.getDelegatedTypeRef() : null;
                KtSourceElement ktSourceElement = source;
                if (!((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtRealSourceElementKind)) {
                    return;
                }
                FirTypeRef $this$coneTypeSafe$iv = typeRef;
                boolean $i$f$coneTypeSafe22 = false;
                FirResolvedTypeRef firResolvedTypeRef2 = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
                ConeKotlinType coneKotlinType = firResolvedTypeRef2 != null ? firResolvedTypeRef2.getType() : null;
                if (!(coneKotlinType instanceof ConeClassLikeType)) {
                    coneKotlinType = null;
                }
                ConeClassLikeType coneClassLikeType2 = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType));
                if (coneClassLikeType2 == null) {
                    return;
                }
                ConeClassLikeType expandedTypealiasType = coneClassLikeType2;
                ConeKotlinType $i$f$coneTypeSafe22 = AbbreviatedTypeAttributeKt.getAbbreviatedTypeOrSelf(expandedTypealiasType);
                ConeClassLikeType coneClassLikeType3 = $i$f$coneTypeSafe22 instanceof ConeClassLikeType ? (ConeClassLikeType)$i$f$coneTypeSafe22 : null;
                if (coneClassLikeType3 == null) {
                    return;
                }
                coneType = coneClassLikeType3;
                FirClassLikeSymbol<?> firClassLikeSymbol = TypeUtilsKt.toSymbol(coneType, context.getSession());
                if (firClassLikeSymbol == null) {
                    return;
                }
                symbol = firClassLikeSymbol;
                ConeClassLikeType it = coneClassLikeType = expandedTypealiasType;
                boolean $i$a$-takeIf-FirOptInUsageTypeRefChecker$check$typeAliasExpandedSymbol$22 = false;
                ConeClassLikeType coneClassLikeType4 = AbbreviatedTypeAttributeKt.isTypealiasExpansion(it) ? coneClassLikeType : null;
                typeAliasExpandedSymbol = coneClassLikeType4 != null ? TypeUtilsKt.toSymbol(coneClassLikeType4, context.getSession()) : null;
                FirClassLikeSymbol<?> firClassLikeSymbol2 = typeAliasExpandedSymbol;
                if (firClassLikeSymbol2 == null) {
                    firClassLikeSymbol2 = symbol;
                }
                processedSymbol = firClassLikeSymbol2;
                classId = processedSymbol.getClassId();
                FirStatement $i$a$-takeIf-FirOptInUsageTypeRefChecker$check$typeAliasExpandedSymbol$22 = CollectionsKt.lastOrNull(context.getCallsOrAssignments());
                FirAnnotation firAnnotation = lastAnnotationCall = $i$a$-takeIf-FirOptInUsageTypeRefChecker$check$typeAliasExpandedSymbol$22 instanceof FirAnnotation ? (FirAnnotation)$i$a$-takeIf-FirOptInUsageTypeRefChecker$check$typeAliasExpandedSymbol$22 : null;
                if (lastAnnotationCall == null) break block16;
                if (lastAnnotationCall.getAnnotationTypeRef() == typeRef) break block17;
            }
            if (Intrinsics.areEqual(classId, OptInNames.INSTANCE.getREQUIRES_OPT_IN_CLASS_ID()) || Intrinsics.areEqual(classId, OptInNames.INSTANCE.getOPT_IN_CLASS_ID())) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getOPT_IN_CAN_ONLY_BE_USED_AS_ANNOTATION(), (DiagnosticContext)context, null, 8, null);
            } else if (FirOptInUsageBaseChecker.INSTANCE.isExperimentalMarker(processedSymbol, context.getSession())) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getOPT_IN_MARKER_CAN_ONLY_BE_USED_AS_ANNOTATION_OR_ARGUMENT_IN_OPT_IN(), (DiagnosticContext)context, null, 8, null);
            } else if (delegatedTypeRef instanceof FirUserTypeRef && !((Collection)((FirUserTypeRef)delegatedTypeRef).getQualifier()).isEmpty()) {
                this.checkContainingClasses(processedSymbol, source, ((FirUserTypeRef)delegatedTypeRef).getQualifier(), context, reporter);
            }
        }
        FirClass firClass = (firDeclaration = CollectionsKt.lastOrNull(context.getContainingDeclarations())) instanceof FirClass ? (FirClass)firDeclaration : null;
        List<FirTypeRef> list = firClass != null ? firClass.getSuperTypeRefs() : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        boolean isSupertypeRef = list.contains(typeRef);
        FirOptInUsageBaseChecker $this$check_u24lambda_u241 = FirOptInUsageBaseChecker.INSTANCE;
        boolean bl = false;
        Set experimentalities = new LinkedHashSet();
        experimentalities.addAll((Collection)INSTANCE.loadClassifierExperimentalities(symbol, context, isSupertypeRef));
        if (typeAliasExpandedSymbol != null) {
            experimentalities.addAll((Collection)INSTANCE.loadClassifierExperimentalities(typeAliasExpandedSymbol, context, isSupertypeRef));
        }
        experimentalities.addAll((Collection)$this$check_u24lambda_u241.loadExperimentalitiesFromConeArguments(context, ArraysKt.toList(coneType.getTypeArguments())));
        FirOptInUsageBaseChecker.reportNotAcceptedExperimentalities$default($this$check_u24lambda_u241, experimentalities, typeRef, context, reporter, null, 16, null);
    }

    private final Set<FirOptInUsageBaseChecker.Experimentality> loadClassifierExperimentalities(FirClassLikeSymbol<?> $this$loadClassifierExperimentalities, CheckerContext context, boolean isSupertypeRef) {
        return isSupertypeRef ? FirOptInUsageBaseChecker.INSTANCE.loadExperimentalitiesFromSupertype($this$loadClassifierExperimentalities, context) : FirOptInUsageBaseChecker.INSTANCE.loadExperimentalities((FirBasedSymbol)$this$loadClassifierExperimentalities, context, false, null);
    }

    private final void checkContainingClasses(FirClassLikeSymbol<?> $this$checkContainingClasses, KtSourceElement source, List<? extends FirQualifierPart> qualifier, CheckerContext context, DiagnosticReporter reporter) {
        FirOptInUsageTypeRefChecker firOptInUsageTypeRefChecker = this;
        while (true) {
            boolean bl;
            Object containingClassSymbol;
            block6: {
                Object object;
                if ((object = ClassMembersKt.getContainingClassLookupTag($this$checkContainingClasses)) == null || (object = LookupTagUtilsKt.toSymbol((ConeClassLikeLookupTag)object, context.getSession())) == null) {
                    return;
                }
                containingClassSymbol = object;
                Iterable $this$any$iv = (Iterable)qualifier;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirQualifierPart it = (FirQualifierPart)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual(it.getName(), ((FirClassLikeSymbol)containingClassSymbol).getName())) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (bl && FirOptInUsageBaseChecker.INSTANCE.isExperimentalMarker((FirClassLikeSymbol<?>)containingClassSymbol, context.getSession())) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getOPT_IN_MARKER_CAN_ONLY_BE_USED_AS_ANNOTATION_OR_ARGUMENT_IN_OPT_IN(), (DiagnosticContext)context, null, 8, null);
            }
            FirOptInUsageTypeRefChecker firOptInUsageTypeRefChecker2 = firOptInUsageTypeRefChecker;
            KtSourceElement ktSourceElement = source;
            Object object = qualifier;
            CheckerContext checkerContext = context;
            DiagnosticReporter diagnosticReporter = reporter;
            firOptInUsageTypeRefChecker = firOptInUsageTypeRefChecker2;
            $this$checkContainingClasses = containingClassSymbol;
            source = ktSourceElement;
            qualifier = object;
            context = checkerContext;
            reporter = diagnosticReporter;
        }
    }
}

