/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.build.report.statistics;

import com.google.gson.Gson;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.buildtools.api.KotlinLogger;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/build/report/statistics/HttpReportService;", "Ljava/io/Serializable;", "url", "", "password", "user", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "invalidUrl", "", "requestPreviousFailed", "checkResponseAndLog", "", "connection", "Ljava/net/HttpURLConnection;", "log", "Lorg/jetbrains/kotlin/buildtools/api/KotlinLogger;", "sendData", "data", "", "kotlin-build-statistics"})
@SourceDebugExtension(value={"SMAP\nHttpReportService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpReportService.kt\norg/jetbrains/kotlin/build/report/statistics/HttpReportService\n+ 2 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,77:1\n17#2,6:78\n*S KotlinDebug\n*F\n+ 1 HttpReportService.kt\norg/jetbrains/kotlin/build/report/statistics/HttpReportService\n*L\n40#1:78,6\n*E\n"})
public final class HttpReportService
implements Serializable {
    @NotNull
    private final String url;
    @Nullable
    private final String password;
    @Nullable
    private final String user;
    private boolean invalidUrl;
    private boolean requestPreviousFailed;

    public HttpReportService(@NotNull String url, @Nullable String password, @Nullable String user) {
        Intrinsics.checkNotNullParameter(url, "url");
        this.url = url;
        this.password = password;
        this.user = user;
    }

    private final void checkResponseAndLog(HttpURLConnection connection, KotlinLogger log2) {
        boolean isResponseBad;
        int n = connection.getResponseCode();
        boolean bl = isResponseBad = !(200 <= n ? n < 300 : false);
        if (isResponseBad) {
            String message = "Failed to send statistic to " + connection.getURL() + " with " + connection.getResponseCode() + ": " + connection.getResponseMessage();
            if (!this.requestPreviousFailed) {
                log2.warn(message);
            } else {
                log2.debug(message);
            }
            this.requestPreviousFailed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sendData(@NotNull Object data, @NotNull KotlinLogger log2) {
        HttpURLConnection httpURLConnection;
        Intrinsics.checkNotNullParameter(data, "data");
        Intrinsics.checkNotNullParameter(log2, "log");
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        if (this.invalidUrl) {
            return;
        }
        try {
            URLConnection uRLConnection = new URL(this.url).openConnection();
            Intrinsics.checkNotNull(uRLConnection, "null cannot be cast to non-null type java.net.HttpURLConnection");
            httpURLConnection = (HttpURLConnection)uRLConnection;
        }
        catch (IOException e) {
            log2.warn("Unable to open connection to " + this.url + ": " + e.getMessage());
            this.invalidUrl = true;
            return;
        }
        HttpURLConnection connection = httpURLConnection;
        try {
            Object auth;
            Object object;
            Object object2;
            if (this.user != null && this.password != null) {
                Base64.Encoder encoder = Base64.getEncoder();
                byte[] byArray = (this.user + ':' + this.password).getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
                byte[] byArray2 = encoder.encode(byArray);
                Intrinsics.checkNotNullExpressionValue(byArray2, "encode(...)");
                object2 = byArray2;
                object = Charsets.UTF_8;
                auth = new String((byte[])object2, (Charset)object);
                connection.addRequestProperty("Authorization", "Basic " + (String)auth);
            }
            connection.addRequestProperty("Content-Type", "application/json");
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            auth = connection.getOutputStream();
            object2 = null;
            try {
                OutputStream it = (OutputStream)auth;
                boolean bl2 = false;
                String string2 = new Gson().toJson(data);
                Intrinsics.checkNotNullExpressionValue(string2, "toJson(...)");
                byte[] byArray = string2.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
                it.write(byArray);
                object = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)auth, (Throwable)object2);
            }
            connection.connect();
            this.checkResponseAndLog(connection, log2);
        }
        catch (Exception e) {
            log2.warn("Unexpected exception happened " + e.getMessage() + ": " + e.getStackTrace());
            this.checkResponseAndLog(connection, log2);
        }
        finally {
            connection.disconnect();
        }
        long elapsedTime = System.currentTimeMillis() - start$iv;
        log2.debug("Report statistic by http takes " + elapsedTime + " ms");
    }
}

