/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.PathUtilRt;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public final class OSAgnosticPathUtil {
    public static final Comparator<String> COMPARATOR = (path1, path2) -> {
        if (Strings.areSameInstance(path1, path2)) {
            return 0;
        }
        if (path1 == null) {
            return -1;
        }
        if (path2 == null) {
            return 1;
        }
        int length1 = path1.length();
        int length2 = path2.length();
        boolean ignoreCase = !SystemInfoRt.isFileSystemCaseSensitive;
        for (int pos = 0; pos < length1 && pos < length2; ++pos) {
            char ch2;
            char ch1 = path1.charAt(pos);
            if (ch1 == (ch2 = path2.charAt(pos))) continue;
            if (ch1 == '/') {
                if (ch2 == '\\') continue;
                return -1;
            }
            if (ch1 == '\\') {
                if (ch2 == '/') continue;
                return -1;
            }
            if (ch2 == '/' || ch2 == '\\') {
                return 1;
            }
            int diff = StringUtil.compare(ch1, ch2, ignoreCase);
            if (diff == 0) continue;
            return diff;
        }
        return Integer.compare(length1, length2);
    };

    public static boolean isAbsoluteDosPath(@NotNull String path) {
        if (path == null) {
            OSAgnosticPathUtil.$$$reportNull$$$0(1);
        }
        return path.length() > 2 && OSAgnosticPathUtil.startsWithWindowsDrive(path) && PathUtilRt.isSeparator(path.charAt(2));
    }

    public static boolean startsWithWindowsDrive(@NotNull String path) {
        if (path == null) {
            OSAgnosticPathUtil.$$$reportNull$$$0(2);
        }
        return path.length() >= 2 && path.charAt(1) == ':' && OSAgnosticPathUtil.isDriveLetter(path.charAt(0));
    }

    public static boolean isDriveLetter(char c) {
        return 'A' <= c && c <= 'Z' || 'a' <= c && c <= 'z';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/util/io/OSAgnosticPathUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAbsolute";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isAbsoluteDosPath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "startsWithWindowsDrive";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isUncPath";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "startsWith";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getParent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

